import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AllocateIpamPoolCidrRequest, AllocateIpamPoolCidrResult } from "../models/models_0";
import { deserializeAws_ec2AllocateIpamPoolCidrCommand, serializeAws_ec2AllocateIpamPoolCidrCommand, } from "../protocols/Aws_ec2";
var AllocateIpamPoolCidrCommand = (function (_super) {
    __extends(AllocateIpamPoolCidrCommand, _super);
    function AllocateIpamPoolCidrCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AllocateIpamPoolCidrCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AllocateIpamPoolCidrCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AllocateIpamPoolCidrRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AllocateIpamPoolCidrResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AllocateIpamPoolCidrCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AllocateIpamPoolCidrCommand(input, context);
    };
    AllocateIpamPoolCidrCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AllocateIpamPoolCidrCommand(output, context);
    };
    return AllocateIpamPoolCidrCommand;
}($Command));
export { AllocateIpamPoolCidrCommand };
