import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AllocateAddressRequest, AllocateAddressResult } from "../models/models_0";
import { deserializeAws_ec2AllocateAddressCommand, serializeAws_ec2AllocateAddressCommand } from "../protocols/Aws_ec2";
var AllocateAddressCommand = (function (_super) {
    __extends(AllocateAddressCommand, _super);
    function AllocateAddressCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AllocateAddressCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AllocateAddressCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AllocateAddressRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AllocateAddressResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AllocateAddressCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AllocateAddressCommand(input, context);
    };
    AllocateAddressCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AllocateAddressCommand(output, context);
    };
    return AllocateAddressCommand;
}($Command));
export { AllocateAddressCommand };
