import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AcceptReservedInstancesExchangeQuoteRequest, AcceptReservedInstancesExchangeQuoteResult, } from "../models/models_0";
import { deserializeAws_ec2AcceptReservedInstancesExchangeQuoteCommand, serializeAws_ec2AcceptReservedInstancesExchangeQuoteCommand, } from "../protocols/Aws_ec2";
var AcceptReservedInstancesExchangeQuoteCommand = (function (_super) {
    __extends(AcceptReservedInstancesExchangeQuoteCommand, _super);
    function AcceptReservedInstancesExchangeQuoteCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AcceptReservedInstancesExchangeQuoteCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AcceptReservedInstancesExchangeQuoteCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AcceptReservedInstancesExchangeQuoteRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AcceptReservedInstancesExchangeQuoteResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AcceptReservedInstancesExchangeQuoteCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AcceptReservedInstancesExchangeQuoteCommand(input, context);
    };
    AcceptReservedInstancesExchangeQuoteCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AcceptReservedInstancesExchangeQuoteCommand(output, context);
    };
    return AcceptReservedInstancesExchangeQuoteCommand;
}($Command));
export { AcceptReservedInstancesExchangeQuoteCommand };
