"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilVpcPeeringConnectionExists = exports.waitForVpcPeeringConnectionExists = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const DescribeVpcPeeringConnectionsCommand_1 = require("../commands/DescribeVpcPeeringConnectionsCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeVpcPeeringConnectionsCommand_1.DescribeVpcPeeringConnectionsCommand(input));
        reason = result;
        return { state: util_waiter_1.WaiterState.SUCCESS, reason };
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "InvalidVpcPeeringConnectionID.NotFound") {
            return { state: util_waiter_1.WaiterState.RETRY, reason };
        }
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForVpcPeeringConnectionExists = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    return util_waiter_1.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForVpcPeeringConnectionExists = waitForVpcPeeringConnectionExists;
const waitUntilVpcPeeringConnectionExists = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    const result = await util_waiter_1.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return util_waiter_1.checkExceptions(result);
};
exports.waitUntilVpcPeeringConnectionExists = waitUntilVpcPeeringConnectionExists;
