"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilSpotInstanceRequestFulfilled = exports.waitForSpotInstanceRequestFulfilled = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const DescribeSpotInstanceRequestsCommand_1 = require("../commands/DescribeSpotInstanceRequestsCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeSpotInstanceRequestsCommand_1.DescribeSpotInstanceRequestsCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.SpotInstanceRequests);
                const projection_3 = flat_1.map((element_2) => {
                    return element_2.Status.Code;
                });
                return projection_3;
            };
            let allStringEq_5 = returnComparator().length > 0;
            for (const element_4 of returnComparator()) {
                allStringEq_5 = allStringEq_5 && element_4 == "fulfilled";
            }
            if (allStringEq_5) {
                return { state: util_waiter_1.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.SpotInstanceRequests);
                const projection_3 = flat_1.map((element_2) => {
                    return element_2.Status.Code;
                });
                return projection_3;
            };
            let allStringEq_5 = returnComparator().length > 0;
            for (const element_4 of returnComparator()) {
                allStringEq_5 = allStringEq_5 && element_4 == "request-canceled-and-instance-running";
            }
            if (allStringEq_5) {
                return { state: util_waiter_1.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.SpotInstanceRequests);
                const projection_3 = flat_1.map((element_2) => {
                    return element_2.Status.Code;
                });
                return projection_3;
            };
            for (const anyStringEq_4 of returnComparator()) {
                if (anyStringEq_4 == "schedule-expired") {
                    return { state: util_waiter_1.WaiterState.FAILURE, reason };
                }
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.SpotInstanceRequests);
                const projection_3 = flat_1.map((element_2) => {
                    return element_2.Status.Code;
                });
                return projection_3;
            };
            for (const anyStringEq_4 of returnComparator()) {
                if (anyStringEq_4 == "canceled-before-fulfillment") {
                    return { state: util_waiter_1.WaiterState.FAILURE, reason };
                }
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.SpotInstanceRequests);
                const projection_3 = flat_1.map((element_2) => {
                    return element_2.Status.Code;
                });
                return projection_3;
            };
            for (const anyStringEq_4 of returnComparator()) {
                if (anyStringEq_4 == "bad-parameters") {
                    return { state: util_waiter_1.WaiterState.FAILURE, reason };
                }
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.SpotInstanceRequests);
                const projection_3 = flat_1.map((element_2) => {
                    return element_2.Status.Code;
                });
                return projection_3;
            };
            for (const anyStringEq_4 of returnComparator()) {
                if (anyStringEq_4 == "system-error") {
                    return { state: util_waiter_1.WaiterState.FAILURE, reason };
                }
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "InvalidSpotInstanceRequestID.NotFound") {
            return { state: util_waiter_1.WaiterState.RETRY, reason };
        }
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForSpotInstanceRequestFulfilled = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    return util_waiter_1.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForSpotInstanceRequestFulfilled = waitForSpotInstanceRequestFulfilled;
const waitUntilSpotInstanceRequestFulfilled = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    const result = await util_waiter_1.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return util_waiter_1.checkExceptions(result);
};
exports.waitUntilSpotInstanceRequestFulfilled = waitUntilSpotInstanceRequestFulfilled;
