"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilNetworkInterfaceAvailable = exports.waitForNetworkInterfaceAvailable = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const DescribeNetworkInterfacesCommand_1 = require("../commands/DescribeNetworkInterfacesCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeNetworkInterfacesCommand_1.DescribeNetworkInterfacesCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.NetworkInterfaces);
                const projection_3 = flat_1.map((element_2) => {
                    return element_2.Status;
                });
                return projection_3;
            };
            let allStringEq_5 = returnComparator().length > 0;
            for (const element_4 of returnComparator()) {
                allStringEq_5 = allStringEq_5 && element_4 == "available";
            }
            if (allStringEq_5) {
                return { state: util_waiter_1.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "InvalidNetworkInterfaceID.NotFound") {
            return { state: util_waiter_1.WaiterState.FAILURE, reason };
        }
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForNetworkInterfaceAvailable = async (params, input) => {
    const serviceDefaults = { minDelay: 20, maxDelay: 120 };
    return util_waiter_1.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForNetworkInterfaceAvailable = waitForNetworkInterfaceAvailable;
const waitUntilNetworkInterfaceAvailable = async (params, input) => {
    const serviceDefaults = { minDelay: 20, maxDelay: 120 };
    const result = await util_waiter_1.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return util_waiter_1.checkExceptions(result);
};
exports.waitUntilNetworkInterfaceAvailable = waitUntilNetworkInterfaceAvailable;
