"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilInstanceStopped = exports.waitForInstanceStopped = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const DescribeInstancesCommand_1 = require("../commands/DescribeInstancesCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeInstancesCommand_1.DescribeInstancesCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.Reservations);
                const projection_3 = flat_1.map((element_2) => {
                    return element_2.Instances;
                });
                const flat_4 = [].concat(...projection_3);
                const projection_6 = flat_4.map((element_5) => {
                    return element_5.State.Name;
                });
                return projection_6;
            };
            let allStringEq_8 = returnComparator().length > 0;
            for (const element_7 of returnComparator()) {
                allStringEq_8 = allStringEq_8 && element_7 == "stopped";
            }
            if (allStringEq_8) {
                return { state: util_waiter_1.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.Reservations);
                const projection_3 = flat_1.map((element_2) => {
                    return element_2.Instances;
                });
                const flat_4 = [].concat(...projection_3);
                const projection_6 = flat_4.map((element_5) => {
                    return element_5.State.Name;
                });
                return projection_6;
            };
            for (const anyStringEq_7 of returnComparator()) {
                if (anyStringEq_7 == "pending") {
                    return { state: util_waiter_1.WaiterState.FAILURE, reason };
                }
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.Reservations);
                const projection_3 = flat_1.map((element_2) => {
                    return element_2.Instances;
                });
                const flat_4 = [].concat(...projection_3);
                const projection_6 = flat_4.map((element_5) => {
                    return element_5.State.Name;
                });
                return projection_6;
            };
            for (const anyStringEq_7 of returnComparator()) {
                if (anyStringEq_7 == "terminated") {
                    return { state: util_waiter_1.WaiterState.FAILURE, reason };
                }
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForInstanceStopped = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    return util_waiter_1.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForInstanceStopped = waitForInstanceStopped;
const waitUntilInstanceStopped = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    const result = await util_waiter_1.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return util_waiter_1.checkExceptions(result);
};
exports.waitUntilInstanceStopped = waitUntilInstanceStopped;
