"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateGetIpamResourceCidrs = void 0;
const GetIpamResourceCidrsCommand_1 = require("../commands/GetIpamResourceCidrsCommand");
const EC2_1 = require("../EC2");
const EC2Client_1 = require("../EC2Client");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new GetIpamResourceCidrsCommand_1.GetIpamResourceCidrsCommand(input), ...args);
};
const makePagedRequest = async (client, input, ...args) => {
    return await client.getIpamResourceCidrs(input, ...args);
};
async function* paginateGetIpamResourceCidrs(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof EC2_1.EC2) {
            page = await makePagedRequest(config.client, input, ...additionalArguments);
        }
        else if (config.client instanceof EC2Client_1.EC2Client) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected EC2 | EC2Client");
        }
        yield page;
        token = page.NextToken;
        hasNext = !!token;
    }
    return undefined;
}
exports.paginateGetIpamResourceCidrs = paginateGetIpamResourceCidrs;
