import * as apigatewayV2 from '@aws-cdk/aws-apigatewayv2';
import * as lamdbaPython from '@aws-cdk/aws-lambda-python';
import { Construct } from '@aws-cdk/core';
import { ServerInstance } from './server-instance-constuct';
/**
 * @stability stable
 */
export interface ManagementAPIProps {
    /**
     * @stability stable
     */
    readonly apiName: string;
    /**
     * @stability stable
     */
    readonly serverInstance: ServerInstance;
}
/**
 * @stability stable
 */
export declare class ManagementAPI extends Construct {
    /**
     * @stability stable
     */
    readonly managementAPIGateway: apigatewayV2.HttpApi;
    /**
     * @stability stable
     */
    readonly statusLambda: lamdbaPython.PythonFunction;
    /**
     * @stability stable
     */
    readonly startServerLambda: lamdbaPython.PythonFunction;
    /**
     * @stability stable
     */
    readonly shutdownServerLambda: lamdbaPython.PythonFunction;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: ManagementAPIProps);
}
