# [AutoSys][1]

[![netlify badge](https://api.netlify.com/api/v1/badges/416b8ca3-82db-470f-9adf-a6d06264ca75/deploy-status)][link_netlify] [![Build Status](https://travis-ci.com/skeptycal/autosys.svg?branch=master)][link_travis]

[![Twitter Follow](https://img.shields.io/twitter/follow/skeptycal.svg?style=social)][link_twitter] [![GitHub followers](https://img.shields.io/github/followers/skeptycal.svg?label=GitHub&style=social)][link_github]

---

### **An even more desperate way to make requests for Humans™.**

-   Why does this have to suck so much?
-   Why do my tools make me work for them?
-   Why can't I ask for something I want to know and see it in a way I want to see it?
-   Why haven't my tools changed in 30 years?
-   Why do we need 100 different cryptic patchworks of messy code to get something done?
-   Why do I have to change and contort to accomodate my tools?

## _Why don't my tools work with the way humans think?_

---

### _If computers can do so much, why can't we do any of the things we want to do?_ That is the question that we seek to answer with **_Implore_**.

---

[![test coverage](https://img.shields.io/badge/test_coverage-100%25-6600CC.svg?logo=Coveralls&color=3F5767)](https://coveralls.io) ![CII Best Practices](https://bestpractices.coreinfrastructure.org/projects/3454/badge)

### **Integrates easily in a simple, human way with:**

-   Google Calendars, Contacts, Drive, Docs, Sheets
-   Dictionaries, References, and language tools
-   Analyze news for fake stories and spoofs
-   Professional Journal searches
-   Linux/macOS Command Line
-   simple image edits and pdfs
-   and nearly any public API
-   Latex / BibTex documents
-   macOS Text Messaging
-   Common web browsers
-   Microsoft Excel, Word
-   Reference formatting
-   Text Messaging
-   NLP Processes
-   Apple iTunes
-   Blog Posts
-   Youtube
-   Netflix

_Tell your computer what to do!"_

> Copyright © 2018-2020 [Michael Treanor](https:/skeptycal.github.com) | [MIT License](https://opensource.org/licenses/MIT) - enjoy ...

[![License](https://img.shields.io/badge/License-MIT-darkblue)](https://skeptycal.mit-license.org/1976/) [![macOS Version](https://img.shields.io/badge/macOS-10.15%20Catalina-orange?logo=apple)](https://www.apple.com) [![code style: prettier](https://img.shields.io/badge/code_style-prettier-ff69b4.svg?logo=prettier)](https://github.com/prettier/prettier)

---

## Implore (with Autosys) version 0.4.4

### Features include:

-   **Send text messages** based on results and presets
-   Figure out the annoying **Netflix** recommendations
-   **Watch** for cookies and other local security issues
-   **Research** topics based on logic and language
-   **NLP analysis** of web pages or sets of pages
-   Test **API** functionality and build an interface
-   Perform spoof analysis and **fact checking**
-   **Block** specific activities of certain sites
-   **Convert** websites to 3d object visuals
-   Timing social media and blog **posts**
-   Interact with underlying **database**
-   Create a **command line** interface
-   **Parse** html and language results
-   Watch **Twitter** for specific topics
-   Create link and image **catalogs**
-   Collect **metadata** and tag info
-   **Google Calendar** automation
-   **Collect** website html code
-   **Timestamp** html versions
-   Direct Request from user
-   Create visual **sitemaps**
-   Calendar **reminders**
-   **CSS** Updating
-   **Scripting**
-   **BibTex**
-   **Time**

_Implore requires Python 3.8+ and works best with **lxml** (fast html) and **ujson** (fast json) installed. Text messaging requires macOS._

[![GitHub Pipenv locked Python version](https://img.shields.io/badge/Python-3.8-yellow?color=3776AB&logo=python&logoColor=yellow)](https://www.python.org/) ![Django v3](https://img.shields.io/badge/Django-v3-%23092E20?logo=django&color=#339933)

---

## Contributing

[![Contributor Covenant](https://img.shields.io/badge/Contributor%20Covenant-v1.4%20adopted-ff69b4.svg)](CODE_OF_CONDUCT.md)

**Please feel free to offer suggestions and changes** (contribution instructions below). I have been coding for many years, but mostly as a side activity ... as a tool to assist me in other endeavors ... so I have not had the 'hard time' invested of constant coding that many of you have.

---

## A solid foundation

> Implore uses _Requests_ and _Beautiful Soup_ to parse html and scrape web data. Website output if mostly _Flask_ based. The majority of other functionality is original code.

---

## Requests: HTTP for Humans™

![Requests graphic](images/requests-sidebar.jpg)

_Requests is an elegant and simple HTTP library for Python, built for human beings._

[Requests Documentation](https://requests.readthedocs.io/en/master/)

> Requests allows you to send HTTP/1.1 requests extremely easily. There’s no need to manually add query strings to your URLs, or to form-encode your POST data. Keep-alive and HTTP connection pooling are 100% automatic, thanks to urllib3.

#### Beloved Features

_Requests is ready for today’s web._

-   Keep-Alive & Connection Pooling
-   International Domains and URLs
-   Sessions with Cookie Persistence
-   Browser-style SSL Verification
-   Automatic Content Decoding
-   Basic/Digest Authentication
-   Elegant Key/Value Cookies
-   Automatic Decompression
-   Unicode Response Bodies
-   HTTP(S) Proxy Support
-   Multipart File Uploads
-   Streaming Downloads
-   Connection Timeouts
-   Chunked Requests
-   .netrc Support

---

## Beautiful Soup

![Beautiful Soup graphic](images/bs4.png)

_Elixir and Tonic_
"The Screen-Scraper's Friend"
[Beautiful Soup Documentation](http://www.crummy.com/software/BeautifulSoup/bs4/doc/)
Copyright (c) 2004-2019 Leonard Richardson
MIT License

> Beautiful Soup uses a pluggable XML or HTML parser to parse a (possibly invalid) document into a tree representation. Beautiful Soup provides methods and Pythonic idioms that make it easy to navigate, search, and modify the parse tree.

---

## Flask

![Flask](images/flask.png)

_Web development, one drop at a time_
[Flask Documentation](https://palletsprojects.com/p/flask/)

> Flask is a lightweight WSGI web application framework. It is designed to make getting started quick and easy, with the ability to scale up to complex applications. It began as a simple wrapper around Werkzeug and Jinja and has become one of the most popular Python web application frameworks.

[1]: (https://www.github.com/skeptycal/autosys)
[link_netlify]: (https://app.netlify.com/sites/mystifying-keller-ab5658/deploys)
[link_travis]: (https://travis-ci.com/skeptycal/autosys)
[link_twitter]: (https://www.twitter.com/skeptycal)
[link_github]: (https://www.github.com/skeptycal)
