import os


def capital_camel_case(path):
    return "".join(
        [i.capitalize() for i in os.path.basename(path).split(".")[0].split("_")]
    )


def gen_cassette_name():
    current_test = os.environ.get("PYTEST_CURRENT_TEST")
    test_dir, test_name = current_test.split("::")
    test_dir = capital_camel_case(os.path.basename(test_dir))
    test_name = test_name.split(" ")[0]
    return f"{test_dir}.{test_name}"
