from credmgr.models import RedditApp, UserVerification


def test_resolve_user_with_object(recorder, credential_manager):
    user = credential_manager.current_user
    reddit_apps = credential_manager.reddit_apps(owner=user)
    for reddit_app in reddit_apps:
        assert isinstance(reddit_app, RedditApp)
        assert reddit_app.owner == user


def test_resolve_user_with_username(recorder, credential_manager):
    user = credential_manager.current_user
    reddit_apps = credential_manager.reddit_apps(owner=user.username)
    for reddit_app in reddit_apps:
        assert isinstance(reddit_app, RedditApp)
        assert reddit_app.owner == user


def test_resolve_model_with_object(recorder, credential_manager):
    reddit_app = credential_manager.reddit_app(26)
    user_verification = credential_manager.user_verification.create(
        user_id="testuserid", reddit_app=reddit_app
    )
    assert isinstance(user_verification, UserVerification)


def test_resolve_model_with_id(recorder, credential_manager):
    reddit_app = credential_manager.reddit_app(26)
    user_verification = credential_manager.user_verification.create(
        user_id="testuserid", reddit_app=reddit_app.id
    )
    assert isinstance(user_verification, UserVerification)
