import pytest

from credmgr.exceptions import NotFound
from credmgr.models import RefreshToken


def test_delete_refresh_token(recorder, credential_manager):
    refresh_token = credential_manager.refresh_token(id=1)
    refresh_token.delete()
    with pytest.raises(NotFound):
        _ = credential_manager.refresh_token(id=1)


def test_list_refresh_tokens(recorder, credential_manager):
    refresh_tokens = credential_manager.refresh_tokens()
    for refresh_token in refresh_tokens:
        assert isinstance(refresh_token, RefreshToken)
