import pytest

from credmgr.exceptions import InitializationError


def test_user_helper_get_by_id(recorder, credential_manager):
    user = credential_manager.user(1)
    assert getattr(user, user._name_attr) == "spaz"


def test_user_helper_get_by_name(recorder, credential_manager):
    user = credential_manager.user("spaz")
    assert getattr(user, user._name_attr) == "spaz"


def test_user_verification_helper_get_by_id(recorder, credential_manager):
    user_verification = credential_manager.user_verification("0123456789")
    assert getattr(user_verification, user_verification._name_attr) == "0123456789"


def test_user_verification_helper_get_by_name(recorder, credential_manager):
    data = {"user_id": "123456", "reddit_app_id": 22}
    user_verification = credential_manager.user_verification(**data)
    for key, value in data.items():
        assert getattr(user_verification, key) == value


def test_refresh_token_helper_get_by_id(recorder, credential_manager):
    refresh_token = credential_manager.refresh_token(
        redditor="Lil_SpazJoekp", reddit_app_id=2
    )
    assert getattr(refresh_token, refresh_token._name_attr) == "Lil_SpazJoekp"


def test_refresh_token_helper_get_by_name(recorder, credential_manager):
    data = {"redditor": "Lil_SpazJoekp", "reddit_app_id": 2}
    refresh_token = credential_manager.refresh_token(**data)
    for key, value in data.items():
        assert getattr(refresh_token, key) == value


def test_refresh_token_helper_get_by_name_fail(recorder, credential_manager):
    with pytest.raises(InitializationError):
        _ = credential_manager.refresh_token("Lil_SpazJoekp")


def test_refresh_token_helper_get_by_name_missing_name(recorder, credential_manager):
    data = {"reddit_app_id": 2}
    with pytest.raises(InitializationError):
        _ = credential_manager.refresh_token(**data)


def test_sentry_token_helper_get_by_id(recorder, credential_manager):
    sentry_token = credential_manager.sentry_token(1)
    assert getattr(sentry_token, sentry_token._name_attr) == "test"


def test_reddit_app_helper_get_by_id(recorder, credential_manager):
    reddit_app = credential_manager.reddit_app(1)
    assert getattr(reddit_app, reddit_app._name_attr) == "DankMemesModAbuse"


def test_database_credential_helper_get_by_id(recorder, credential_manager):
    database_credential = credential_manager.database_credential(1)
    assert getattr(database_credential, database_credential._name_attr) == "test"


def test_bot_helper_get_by_id(recorder, credential_manager):
    bot = credential_manager.bot(1)
    assert getattr(bot, bot._name_attr) == "test"


def test_bot_helper_get_by_name(recorder, credential_manager):
    bot = credential_manager.bot("test")
    assert getattr(bot, bot._name_attr) == "test"


def test_base_helper_call_with_name_fail(recorder, credential_manager):
    with pytest.raises(InitializationError):
        _ = credential_manager.reddit_app("test")
