import pytest
from betamax import Betamax


def test_base_equal(recorder, credential_manager):
    bot = credential_manager.bot(1)
    bot2 = credential_manager.bot(1)
    assert bot == bot2


def test_base_not_equal(recorder, credential_manager):
    bot = credential_manager.bot(1)
    bot2 = credential_manager.bot(4)
    assert bot != bot2


def test_base_equal_different_type(recorder, credential_manager):
    item = credential_manager.bot(1)
    item2 = item.reddit_app
    assert item != item2


def test_base_camel_case(credential_manager):
    with Betamax(credential_manager._requestor._session).use_cassette(
        "TestBase.test_base_equal_different_type"
    ):
        item = credential_manager.bot(1)
        reddit_app = item.reddit_app
        with pytest.deprecated_call():
            redditApp = item.redditApp
        assert reddit_app == redditApp
