# MassCube

[![Generic badge](https://img.shields.io/badge/masscube-ver_1.0.17-%3CCOLOR%3E.svg)](https://github.com/huaxuyu/masscube/)
![Maintainer](https://img.shields.io/badge/maintainer-Huaxu_Yu-blue)
[![PyPI Downloads](https://img.shields.io/pypi/dm/bago.svg?label=PyPI%20downloads)](https://pypi.org/project/masscube/)

**masscube** is an integrated Python package for liquid chromatography-mass spectrometry (LC-MS) data processing.

- **Documentation:** https://huaxuyu.github.io/masscubedocs/
- **Source code:** https://github.com/huaxuyu/masscube/
- **Bug reports:** https://github.com/huaxuyu/masscube/issues/

It provides:

- High performance feature detection based on signal clustering.
- Comprehensive feature quality evaluation.
- Confident annotation of isotopes, adducts, and in-source fragments.
- Ultra-fast annotation of MS/MS spectra.

## Installation

```bash
pip install masscube
```

To upgrade **masscube** to the latest version:

```bash
pip install masscube --upgrade
```

## Quick start

Start your untargeted metabolomics data processing from [here](https://huaxuyu.github.io/masscubedocs/docs/quickstart/)

## Contribute to masscube

The **masscube** project is excited to have your expertise and passion on board!

We value all enhancements or corrections. For those thinking about making significant contributions to the codebase, we encourage you to get in touch with us!

- Huaxu Yu, hxuyu@ucdavis.edu
