# Generated by Django 2.1.15 on 2020-01-11 15:25
from django.conf import settings
from django.contrib.auth import get_user_model
from django.db import migrations


def forwards(apps, schema_editor):
    if schema_editor.connection.alias != 'default':
        return
    token_bucket_model = apps.get_model('django_token_bucket', 'TokenBucket')
    content_type_model = apps.get_model('contenttypes', 'ContentType')
    for row in token_bucket_model.objects.all():
        if not row.content_type:
            row.content_type = content_type_model.objects.using('default').get_for_model(get_user_model())
            row.save(update_fields=['content_type'])


class Migration(migrations.Migration):

    dependencies = [
        ('django_token_bucket', '0002_auto_20191216_1228'),
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.RunPython(forwards, migrations.RunPython.noop),
    ]
