# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 2
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isi_sdk_7_2.models.sync_job_policy_file_matching_pattern import SyncJobPolicyFileMatchingPattern  # noqa: F401,E501
from isi_sdk_7_2.models.sync_policy_source_network import SyncPolicySourceNetwork  # noqa: F401,E501


class SyncPolicyCreateParams(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'action': 'str',
        'burst_mode': 'bool',
        'changelist': 'bool',
        'check_integrity': 'bool',
        'description': 'str',
        'disable_file_split': 'bool',
        'disable_fofb': 'bool',
        'disable_stf': 'bool',
        'enabled': 'bool',
        'expected_dataloss': 'bool',
        'file_matching_pattern': 'SyncJobPolicyFileMatchingPattern',
        'force_interface': 'bool',
        'log_level': 'str',
        'log_removed_files': 'bool',
        'name': 'str',
        'password': 'str',
        'report_max_age': 'int',
        'report_max_count': 'int',
        'restrict_target_network': 'bool',
        'schedule': 'str',
        'skip_lookup': 'bool',
        'source_exclude_directories': 'list[str]',
        'source_include_directories': 'list[str]',
        'source_network': 'SyncPolicySourceNetwork',
        'source_root_path': 'str',
        'source_snapshot_archive': 'bool',
        'source_snapshot_expiration': 'int',
        'source_snapshot_pattern': 'str',
        'target_compare_initial_sync': 'bool',
        'target_detect_modifications': 'bool',
        'target_host': 'str',
        'target_path': 'str',
        'target_snapshot_alias': 'str',
        'target_snapshot_archive': 'bool',
        'target_snapshot_expiration': 'int',
        'target_snapshot_pattern': 'str',
        'workers_per_node': 'int'
    }

    attribute_map = {
        'action': 'action',
        'burst_mode': 'burst_mode',
        'changelist': 'changelist',
        'check_integrity': 'check_integrity',
        'description': 'description',
        'disable_file_split': 'disable_file_split',
        'disable_fofb': 'disable_fofb',
        'disable_stf': 'disable_stf',
        'enabled': 'enabled',
        'expected_dataloss': 'expected_dataloss',
        'file_matching_pattern': 'file_matching_pattern',
        'force_interface': 'force_interface',
        'log_level': 'log_level',
        'log_removed_files': 'log_removed_files',
        'name': 'name',
        'password': 'password',
        'report_max_age': 'report_max_age',
        'report_max_count': 'report_max_count',
        'restrict_target_network': 'restrict_target_network',
        'schedule': 'schedule',
        'skip_lookup': 'skip_lookup',
        'source_exclude_directories': 'source_exclude_directories',
        'source_include_directories': 'source_include_directories',
        'source_network': 'source_network',
        'source_root_path': 'source_root_path',
        'source_snapshot_archive': 'source_snapshot_archive',
        'source_snapshot_expiration': 'source_snapshot_expiration',
        'source_snapshot_pattern': 'source_snapshot_pattern',
        'target_compare_initial_sync': 'target_compare_initial_sync',
        'target_detect_modifications': 'target_detect_modifications',
        'target_host': 'target_host',
        'target_path': 'target_path',
        'target_snapshot_alias': 'target_snapshot_alias',
        'target_snapshot_archive': 'target_snapshot_archive',
        'target_snapshot_expiration': 'target_snapshot_expiration',
        'target_snapshot_pattern': 'target_snapshot_pattern',
        'workers_per_node': 'workers_per_node'
    }

    def __init__(self, action=None, burst_mode=None, changelist=None, check_integrity=None, description=None, disable_file_split=None, disable_fofb=None, disable_stf=None, enabled=None, expected_dataloss=None, file_matching_pattern=None, force_interface=None, log_level=None, log_removed_files=None, name=None, password=None, report_max_age=None, report_max_count=None, restrict_target_network=None, schedule=None, skip_lookup=None, source_exclude_directories=None, source_include_directories=None, source_network=None, source_root_path=None, source_snapshot_archive=None, source_snapshot_expiration=None, source_snapshot_pattern=None, target_compare_initial_sync=None, target_detect_modifications=None, target_host=None, target_path=None, target_snapshot_alias=None, target_snapshot_archive=None, target_snapshot_expiration=None, target_snapshot_pattern=None, workers_per_node=None):  # noqa: E501
        """SyncPolicyCreateParams - a model defined in Swagger"""  # noqa: E501

        self._action = None
        self._burst_mode = None
        self._changelist = None
        self._check_integrity = None
        self._description = None
        self._disable_file_split = None
        self._disable_fofb = None
        self._disable_stf = None
        self._enabled = None
        self._expected_dataloss = None
        self._file_matching_pattern = None
        self._force_interface = None
        self._log_level = None
        self._log_removed_files = None
        self._name = None
        self._password = None
        self._report_max_age = None
        self._report_max_count = None
        self._restrict_target_network = None
        self._schedule = None
        self._skip_lookup = None
        self._source_exclude_directories = None
        self._source_include_directories = None
        self._source_network = None
        self._source_root_path = None
        self._source_snapshot_archive = None
        self._source_snapshot_expiration = None
        self._source_snapshot_pattern = None
        self._target_compare_initial_sync = None
        self._target_detect_modifications = None
        self._target_host = None
        self._target_path = None
        self._target_snapshot_alias = None
        self._target_snapshot_archive = None
        self._target_snapshot_expiration = None
        self._target_snapshot_pattern = None
        self._workers_per_node = None
        self.discriminator = None

        self.action = action
        if burst_mode is not None:
            self.burst_mode = burst_mode
        if changelist is not None:
            self.changelist = changelist
        if check_integrity is not None:
            self.check_integrity = check_integrity
        if description is not None:
            self.description = description
        if disable_file_split is not None:
            self.disable_file_split = disable_file_split
        if disable_fofb is not None:
            self.disable_fofb = disable_fofb
        if disable_stf is not None:
            self.disable_stf = disable_stf
        if enabled is not None:
            self.enabled = enabled
        if expected_dataloss is not None:
            self.expected_dataloss = expected_dataloss
        if file_matching_pattern is not None:
            self.file_matching_pattern = file_matching_pattern
        if force_interface is not None:
            self.force_interface = force_interface
        if log_level is not None:
            self.log_level = log_level
        if log_removed_files is not None:
            self.log_removed_files = log_removed_files
        self.name = name
        if password is not None:
            self.password = password
        if report_max_age is not None:
            self.report_max_age = report_max_age
        if report_max_count is not None:
            self.report_max_count = report_max_count
        if restrict_target_network is not None:
            self.restrict_target_network = restrict_target_network
        if schedule is not None:
            self.schedule = schedule
        if skip_lookup is not None:
            self.skip_lookup = skip_lookup
        if source_exclude_directories is not None:
            self.source_exclude_directories = source_exclude_directories
        if source_include_directories is not None:
            self.source_include_directories = source_include_directories
        if source_network is not None:
            self.source_network = source_network
        self.source_root_path = source_root_path
        if source_snapshot_archive is not None:
            self.source_snapshot_archive = source_snapshot_archive
        if source_snapshot_expiration is not None:
            self.source_snapshot_expiration = source_snapshot_expiration
        if source_snapshot_pattern is not None:
            self.source_snapshot_pattern = source_snapshot_pattern
        if target_compare_initial_sync is not None:
            self.target_compare_initial_sync = target_compare_initial_sync
        if target_detect_modifications is not None:
            self.target_detect_modifications = target_detect_modifications
        self.target_host = target_host
        self.target_path = target_path
        if target_snapshot_alias is not None:
            self.target_snapshot_alias = target_snapshot_alias
        if target_snapshot_archive is not None:
            self.target_snapshot_archive = target_snapshot_archive
        if target_snapshot_expiration is not None:
            self.target_snapshot_expiration = target_snapshot_expiration
        if target_snapshot_pattern is not None:
            self.target_snapshot_pattern = target_snapshot_pattern
        if workers_per_node is not None:
            self.workers_per_node = workers_per_node

    @property
    def action(self):
        """Gets the action of this SyncPolicyCreateParams.  # noqa: E501

        If 'copy', source files will be copied to the target cluster.  If 'sync', the target directory will be made an image of the source directory:  Files and directories that have been deleted on the source, have been moved within the target directory, or no longer match the selection criteria will be deleted from the target directory.  # noqa: E501

        :return: The action of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this SyncPolicyCreateParams.

        If 'copy', source files will be copied to the target cluster.  If 'sync', the target directory will be made an image of the source directory:  Files and directories that have been deleted on the source, have been moved within the target directory, or no longer match the selection criteria will be deleted from the target directory.  # noqa: E501

        :param action: The action of this SyncPolicyCreateParams.  # noqa: E501
        :type: str
        """
        if action is None:
            raise ValueError("Invalid value for `action`, must not be `None`")  # noqa: E501
        allowed_values = ["copy", "sync"]  # noqa: E501
        if action not in allowed_values:
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}"  # noqa: E501
                .format(action, allowed_values)
            )

        self._action = action

    @property
    def burst_mode(self):
        """Gets the burst_mode of this SyncPolicyCreateParams.  # noqa: E501

        NOTE: This field should not be changed without the help of Isilon support.  Enable/disable UDP-based data transfer.  # noqa: E501

        :return: The burst_mode of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._burst_mode

    @burst_mode.setter
    def burst_mode(self, burst_mode):
        """Sets the burst_mode of this SyncPolicyCreateParams.

        NOTE: This field should not be changed without the help of Isilon support.  Enable/disable UDP-based data transfer.  # noqa: E501

        :param burst_mode: The burst_mode of this SyncPolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._burst_mode = burst_mode

    @property
    def changelist(self):
        """Gets the changelist of this SyncPolicyCreateParams.  # noqa: E501

        If true, retain previous source snapshot and incremental repstate, both of which are required for changelist creation.  # noqa: E501

        :return: The changelist of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._changelist

    @changelist.setter
    def changelist(self, changelist):
        """Sets the changelist of this SyncPolicyCreateParams.

        If true, retain previous source snapshot and incremental repstate, both of which are required for changelist creation.  # noqa: E501

        :param changelist: The changelist of this SyncPolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._changelist = changelist

    @property
    def check_integrity(self):
        """Gets the check_integrity of this SyncPolicyCreateParams.  # noqa: E501

        If true, the sync target performs cyclic redundancy checks (CRC) on the data as it is received.  # noqa: E501

        :return: The check_integrity of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._check_integrity

    @check_integrity.setter
    def check_integrity(self, check_integrity):
        """Sets the check_integrity of this SyncPolicyCreateParams.

        If true, the sync target performs cyclic redundancy checks (CRC) on the data as it is received.  # noqa: E501

        :param check_integrity: The check_integrity of this SyncPolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._check_integrity = check_integrity

    @property
    def description(self):
        """Gets the description of this SyncPolicyCreateParams.  # noqa: E501

        User-assigned description of this sync policy.  # noqa: E501

        :return: The description of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this SyncPolicyCreateParams.

        User-assigned description of this sync policy.  # noqa: E501

        :param description: The description of this SyncPolicyCreateParams.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def disable_file_split(self):
        """Gets the disable_file_split of this SyncPolicyCreateParams.  # noqa: E501

        NOTE: This field should not be changed without the help of Isilon support.  If true, the 7.2+ file splitting capability will be disabled.  # noqa: E501

        :return: The disable_file_split of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._disable_file_split

    @disable_file_split.setter
    def disable_file_split(self, disable_file_split):
        """Sets the disable_file_split of this SyncPolicyCreateParams.

        NOTE: This field should not be changed without the help of Isilon support.  If true, the 7.2+ file splitting capability will be disabled.  # noqa: E501

        :param disable_file_split: The disable_file_split of this SyncPolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._disable_file_split = disable_file_split

    @property
    def disable_fofb(self):
        """Gets the disable_fofb of this SyncPolicyCreateParams.  # noqa: E501

        NOTE: This field should not be changed without the help of Isilon support.  Enable/disable sync failover/failback.  # noqa: E501

        :return: The disable_fofb of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._disable_fofb

    @disable_fofb.setter
    def disable_fofb(self, disable_fofb):
        """Sets the disable_fofb of this SyncPolicyCreateParams.

        NOTE: This field should not be changed without the help of Isilon support.  Enable/disable sync failover/failback.  # noqa: E501

        :param disable_fofb: The disable_fofb of this SyncPolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._disable_fofb = disable_fofb

    @property
    def disable_stf(self):
        """Gets the disable_stf of this SyncPolicyCreateParams.  # noqa: E501

        NOTE: This field should not be changed without the help of Isilon support.  Enable/disable the 6.5+ STF based data transfer and uses only treewalk.  # noqa: E501

        :return: The disable_stf of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._disable_stf

    @disable_stf.setter
    def disable_stf(self, disable_stf):
        """Sets the disable_stf of this SyncPolicyCreateParams.

        NOTE: This field should not be changed without the help of Isilon support.  Enable/disable the 6.5+ STF based data transfer and uses only treewalk.  # noqa: E501

        :param disable_stf: The disable_stf of this SyncPolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._disable_stf = disable_stf

    @property
    def enabled(self):
        """Gets the enabled of this SyncPolicyCreateParams.  # noqa: E501

        If true, jobs will be automatically run based on this policy, according to its schedule.  # noqa: E501

        :return: The enabled of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this SyncPolicyCreateParams.

        If true, jobs will be automatically run based on this policy, according to its schedule.  # noqa: E501

        :param enabled: The enabled of this SyncPolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def expected_dataloss(self):
        """Gets the expected_dataloss of this SyncPolicyCreateParams.  # noqa: E501

        NOTE: This field should not be changed without the help of Isilon support.  Continue sending files even with the corrupted filesystem.  # noqa: E501

        :return: The expected_dataloss of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._expected_dataloss

    @expected_dataloss.setter
    def expected_dataloss(self, expected_dataloss):
        """Sets the expected_dataloss of this SyncPolicyCreateParams.

        NOTE: This field should not be changed without the help of Isilon support.  Continue sending files even with the corrupted filesystem.  # noqa: E501

        :param expected_dataloss: The expected_dataloss of this SyncPolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._expected_dataloss = expected_dataloss

    @property
    def file_matching_pattern(self):
        """Gets the file_matching_pattern of this SyncPolicyCreateParams.  # noqa: E501

        A file matching pattern, organized as an OR'ed set of AND'ed file criteria, for example ((a AND b) OR (x AND y)) used to define a set of files with specific properties.  Policies of type 'sync' cannot use 'path' or time criteria in their matching patterns, but policies of type 'copy' can use all listed criteria.  # noqa: E501

        :return: The file_matching_pattern of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: SyncJobPolicyFileMatchingPattern
        """
        return self._file_matching_pattern

    @file_matching_pattern.setter
    def file_matching_pattern(self, file_matching_pattern):
        """Sets the file_matching_pattern of this SyncPolicyCreateParams.

        A file matching pattern, organized as an OR'ed set of AND'ed file criteria, for example ((a AND b) OR (x AND y)) used to define a set of files with specific properties.  Policies of type 'sync' cannot use 'path' or time criteria in their matching patterns, but policies of type 'copy' can use all listed criteria.  # noqa: E501

        :param file_matching_pattern: The file_matching_pattern of this SyncPolicyCreateParams.  # noqa: E501
        :type: SyncJobPolicyFileMatchingPattern
        """

        self._file_matching_pattern = file_matching_pattern

    @property
    def force_interface(self):
        """Gets the force_interface of this SyncPolicyCreateParams.  # noqa: E501

        NOTE: This field should not be changed without the help of Isilon support.  Determines whether data is sent only through the subnet and pool specified in the \"source_network\" field. This option can be useful if there are multiple interfaces for the given source subnet.  If you enable this option, the net.inet.ip.choose_ifa_by_ipsrc sysctl should be set.  # noqa: E501

        :return: The force_interface of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._force_interface

    @force_interface.setter
    def force_interface(self, force_interface):
        """Sets the force_interface of this SyncPolicyCreateParams.

        NOTE: This field should not be changed without the help of Isilon support.  Determines whether data is sent only through the subnet and pool specified in the \"source_network\" field. This option can be useful if there are multiple interfaces for the given source subnet.  If you enable this option, the net.inet.ip.choose_ifa_by_ipsrc sysctl should be set.  # noqa: E501

        :param force_interface: The force_interface of this SyncPolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._force_interface = force_interface

    @property
    def log_level(self):
        """Gets the log_level of this SyncPolicyCreateParams.  # noqa: E501

        Severity an event must reach before it is logged.  # noqa: E501

        :return: The log_level of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._log_level

    @log_level.setter
    def log_level(self, log_level):
        """Sets the log_level of this SyncPolicyCreateParams.

        Severity an event must reach before it is logged.  # noqa: E501

        :param log_level: The log_level of this SyncPolicyCreateParams.  # noqa: E501
        :type: str
        """
        allowed_values = ["fatal", "error", "notice", "info", "copy", "debug", "trace"]  # noqa: E501
        if log_level not in allowed_values:
            raise ValueError(
                "Invalid value for `log_level` ({0}), must be one of {1}"  # noqa: E501
                .format(log_level, allowed_values)
            )

        self._log_level = log_level

    @property
    def log_removed_files(self):
        """Gets the log_removed_files of this SyncPolicyCreateParams.  # noqa: E501

        If true, the system will log any files or directories that are deleted due to a sync.  # noqa: E501

        :return: The log_removed_files of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._log_removed_files

    @log_removed_files.setter
    def log_removed_files(self, log_removed_files):
        """Sets the log_removed_files of this SyncPolicyCreateParams.

        If true, the system will log any files or directories that are deleted due to a sync.  # noqa: E501

        :param log_removed_files: The log_removed_files of this SyncPolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._log_removed_files = log_removed_files

    @property
    def name(self):
        """Gets the name of this SyncPolicyCreateParams.  # noqa: E501

        User-assigned name of this sync policy.  # noqa: E501

        :return: The name of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SyncPolicyCreateParams.

        User-assigned name of this sync policy.  # noqa: E501

        :param name: The name of this SyncPolicyCreateParams.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def password(self):
        """Gets the password of this SyncPolicyCreateParams.  # noqa: E501

        The password for the target cluster.  This field is not readable.  # noqa: E501

        :return: The password of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this SyncPolicyCreateParams.

        The password for the target cluster.  This field is not readable.  # noqa: E501

        :param password: The password of this SyncPolicyCreateParams.  # noqa: E501
        :type: str
        """

        self._password = password

    @property
    def report_max_age(self):
        """Gets the report_max_age of this SyncPolicyCreateParams.  # noqa: E501

        Length of time (in seconds) a policy report will be stored.  # noqa: E501

        :return: The report_max_age of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._report_max_age

    @report_max_age.setter
    def report_max_age(self, report_max_age):
        """Sets the report_max_age of this SyncPolicyCreateParams.

        Length of time (in seconds) a policy report will be stored.  # noqa: E501

        :param report_max_age: The report_max_age of this SyncPolicyCreateParams.  # noqa: E501
        :type: int
        """
        if report_max_age is not None and report_max_age < 0:  # noqa: E501
            raise ValueError("Invalid value for `report_max_age`, must be a value greater than or equal to `0`")  # noqa: E501

        self._report_max_age = report_max_age

    @property
    def report_max_count(self):
        """Gets the report_max_count of this SyncPolicyCreateParams.  # noqa: E501

        Maximum number of policy reports that will be stored on the system.  # noqa: E501

        :return: The report_max_count of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._report_max_count

    @report_max_count.setter
    def report_max_count(self, report_max_count):
        """Sets the report_max_count of this SyncPolicyCreateParams.

        Maximum number of policy reports that will be stored on the system.  # noqa: E501

        :param report_max_count: The report_max_count of this SyncPolicyCreateParams.  # noqa: E501
        :type: int
        """
        if report_max_count is not None and report_max_count > 2000:  # noqa: E501
            raise ValueError("Invalid value for `report_max_count`, must be a value less than or equal to `2000`")  # noqa: E501
        if report_max_count is not None and report_max_count < 1:  # noqa: E501
            raise ValueError("Invalid value for `report_max_count`, must be a value greater than or equal to `1`")  # noqa: E501

        self._report_max_count = report_max_count

    @property
    def restrict_target_network(self):
        """Gets the restrict_target_network of this SyncPolicyCreateParams.  # noqa: E501

        If you specify true, and you specify a SmartConnect zone in the \"target_host\" field, replication policies will connect only to nodes in the specified SmartConnect zone.  If you specify false, replication policies are not restricted to specific nodes on the target cluster.  # noqa: E501

        :return: The restrict_target_network of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._restrict_target_network

    @restrict_target_network.setter
    def restrict_target_network(self, restrict_target_network):
        """Sets the restrict_target_network of this SyncPolicyCreateParams.

        If you specify true, and you specify a SmartConnect zone in the \"target_host\" field, replication policies will connect only to nodes in the specified SmartConnect zone.  If you specify false, replication policies are not restricted to specific nodes on the target cluster.  # noqa: E501

        :param restrict_target_network: The restrict_target_network of this SyncPolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._restrict_target_network = restrict_target_network

    @property
    def schedule(self):
        """Gets the schedule of this SyncPolicyCreateParams.  # noqa: E501

        The schedule on which new jobs will be run for this policy.  # noqa: E501

        :return: The schedule of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule):
        """Sets the schedule of this SyncPolicyCreateParams.

        The schedule on which new jobs will be run for this policy.  # noqa: E501

        :param schedule: The schedule of this SyncPolicyCreateParams.  # noqa: E501
        :type: str
        """

        self._schedule = schedule

    @property
    def skip_lookup(self):
        """Gets the skip_lookup of this SyncPolicyCreateParams.  # noqa: E501

        Skip DNS lookup of target IPs.  # noqa: E501

        :return: The skip_lookup of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._skip_lookup

    @skip_lookup.setter
    def skip_lookup(self, skip_lookup):
        """Sets the skip_lookup of this SyncPolicyCreateParams.

        Skip DNS lookup of target IPs.  # noqa: E501

        :param skip_lookup: The skip_lookup of this SyncPolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._skip_lookup = skip_lookup

    @property
    def source_exclude_directories(self):
        """Gets the source_exclude_directories of this SyncPolicyCreateParams.  # noqa: E501

        Directories that will be excluded from the sync.  Modifying this field will result in a full synchronization of all data.  # noqa: E501

        :return: The source_exclude_directories of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._source_exclude_directories

    @source_exclude_directories.setter
    def source_exclude_directories(self, source_exclude_directories):
        """Sets the source_exclude_directories of this SyncPolicyCreateParams.

        Directories that will be excluded from the sync.  Modifying this field will result in a full synchronization of all data.  # noqa: E501

        :param source_exclude_directories: The source_exclude_directories of this SyncPolicyCreateParams.  # noqa: E501
        :type: list[str]
        """

        self._source_exclude_directories = source_exclude_directories

    @property
    def source_include_directories(self):
        """Gets the source_include_directories of this SyncPolicyCreateParams.  # noqa: E501

        Directories that will be included in the sync.  Modifying this field will result in a full synchronization of all data.  # noqa: E501

        :return: The source_include_directories of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._source_include_directories

    @source_include_directories.setter
    def source_include_directories(self, source_include_directories):
        """Sets the source_include_directories of this SyncPolicyCreateParams.

        Directories that will be included in the sync.  Modifying this field will result in a full synchronization of all data.  # noqa: E501

        :param source_include_directories: The source_include_directories of this SyncPolicyCreateParams.  # noqa: E501
        :type: list[str]
        """

        self._source_include_directories = source_include_directories

    @property
    def source_network(self):
        """Gets the source_network of this SyncPolicyCreateParams.  # noqa: E501

        Restricts replication policies on the local cluster to running on the specified subnet and pool.  # noqa: E501

        :return: The source_network of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: SyncPolicySourceNetwork
        """
        return self._source_network

    @source_network.setter
    def source_network(self, source_network):
        """Sets the source_network of this SyncPolicyCreateParams.

        Restricts replication policies on the local cluster to running on the specified subnet and pool.  # noqa: E501

        :param source_network: The source_network of this SyncPolicyCreateParams.  # noqa: E501
        :type: SyncPolicySourceNetwork
        """

        self._source_network = source_network

    @property
    def source_root_path(self):
        """Gets the source_root_path of this SyncPolicyCreateParams.  # noqa: E501

        The root directory on the source cluster the files will be synced from.  Modifying this field will result in a full synchronization of all data.  # noqa: E501

        :return: The source_root_path of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._source_root_path

    @source_root_path.setter
    def source_root_path(self, source_root_path):
        """Sets the source_root_path of this SyncPolicyCreateParams.

        The root directory on the source cluster the files will be synced from.  Modifying this field will result in a full synchronization of all data.  # noqa: E501

        :param source_root_path: The source_root_path of this SyncPolicyCreateParams.  # noqa: E501
        :type: str
        """
        if source_root_path is None:
            raise ValueError("Invalid value for `source_root_path`, must not be `None`")  # noqa: E501

        self._source_root_path = source_root_path

    @property
    def source_snapshot_archive(self):
        """Gets the source_snapshot_archive of this SyncPolicyCreateParams.  # noqa: E501

        If true, archival snapshots of the source data will be taken on the source cluster before a sync.  # noqa: E501

        :return: The source_snapshot_archive of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._source_snapshot_archive

    @source_snapshot_archive.setter
    def source_snapshot_archive(self, source_snapshot_archive):
        """Sets the source_snapshot_archive of this SyncPolicyCreateParams.

        If true, archival snapshots of the source data will be taken on the source cluster before a sync.  # noqa: E501

        :param source_snapshot_archive: The source_snapshot_archive of this SyncPolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._source_snapshot_archive = source_snapshot_archive

    @property
    def source_snapshot_expiration(self):
        """Gets the source_snapshot_expiration of this SyncPolicyCreateParams.  # noqa: E501

        The length of time in seconds to keep snapshots on the source cluster.  # noqa: E501

        :return: The source_snapshot_expiration of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._source_snapshot_expiration

    @source_snapshot_expiration.setter
    def source_snapshot_expiration(self, source_snapshot_expiration):
        """Sets the source_snapshot_expiration of this SyncPolicyCreateParams.

        The length of time in seconds to keep snapshots on the source cluster.  # noqa: E501

        :param source_snapshot_expiration: The source_snapshot_expiration of this SyncPolicyCreateParams.  # noqa: E501
        :type: int
        """
        if source_snapshot_expiration is not None and source_snapshot_expiration < 0:  # noqa: E501
            raise ValueError("Invalid value for `source_snapshot_expiration`, must be a value greater than or equal to `0`")  # noqa: E501

        self._source_snapshot_expiration = source_snapshot_expiration

    @property
    def source_snapshot_pattern(self):
        """Gets the source_snapshot_pattern of this SyncPolicyCreateParams.  # noqa: E501

        The name pattern for snapshots taken on the source cluster before a sync.  # noqa: E501

        :return: The source_snapshot_pattern of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._source_snapshot_pattern

    @source_snapshot_pattern.setter
    def source_snapshot_pattern(self, source_snapshot_pattern):
        """Sets the source_snapshot_pattern of this SyncPolicyCreateParams.

        The name pattern for snapshots taken on the source cluster before a sync.  # noqa: E501

        :param source_snapshot_pattern: The source_snapshot_pattern of this SyncPolicyCreateParams.  # noqa: E501
        :type: str
        """

        self._source_snapshot_pattern = source_snapshot_pattern

    @property
    def target_compare_initial_sync(self):
        """Gets the target_compare_initial_sync of this SyncPolicyCreateParams.  # noqa: E501

        If true, the target creates diffs against the original sync.  # noqa: E501

        :return: The target_compare_initial_sync of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._target_compare_initial_sync

    @target_compare_initial_sync.setter
    def target_compare_initial_sync(self, target_compare_initial_sync):
        """Sets the target_compare_initial_sync of this SyncPolicyCreateParams.

        If true, the target creates diffs against the original sync.  # noqa: E501

        :param target_compare_initial_sync: The target_compare_initial_sync of this SyncPolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._target_compare_initial_sync = target_compare_initial_sync

    @property
    def target_detect_modifications(self):
        """Gets the target_detect_modifications of this SyncPolicyCreateParams.  # noqa: E501

        If true, target cluster will detect if files have been changed on the target by legacy tree walk syncs.  # noqa: E501

        :return: The target_detect_modifications of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._target_detect_modifications

    @target_detect_modifications.setter
    def target_detect_modifications(self, target_detect_modifications):
        """Sets the target_detect_modifications of this SyncPolicyCreateParams.

        If true, target cluster will detect if files have been changed on the target by legacy tree walk syncs.  # noqa: E501

        :param target_detect_modifications: The target_detect_modifications of this SyncPolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._target_detect_modifications = target_detect_modifications

    @property
    def target_host(self):
        """Gets the target_host of this SyncPolicyCreateParams.  # noqa: E501

        Hostname or IP address of sync target cluster.  Modifying the target cluster host can result in the policy being unrunnable if the new target does not match the current target association.  # noqa: E501

        :return: The target_host of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._target_host

    @target_host.setter
    def target_host(self, target_host):
        """Sets the target_host of this SyncPolicyCreateParams.

        Hostname or IP address of sync target cluster.  Modifying the target cluster host can result in the policy being unrunnable if the new target does not match the current target association.  # noqa: E501

        :param target_host: The target_host of this SyncPolicyCreateParams.  # noqa: E501
        :type: str
        """
        if target_host is None:
            raise ValueError("Invalid value for `target_host`, must not be `None`")  # noqa: E501

        self._target_host = target_host

    @property
    def target_path(self):
        """Gets the target_path of this SyncPolicyCreateParams.  # noqa: E501

        Absolute filesystem path on the target cluster for the sync destination.  # noqa: E501

        :return: The target_path of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._target_path

    @target_path.setter
    def target_path(self, target_path):
        """Sets the target_path of this SyncPolicyCreateParams.

        Absolute filesystem path on the target cluster for the sync destination.  # noqa: E501

        :param target_path: The target_path of this SyncPolicyCreateParams.  # noqa: E501
        :type: str
        """
        if target_path is None:
            raise ValueError("Invalid value for `target_path`, must not be `None`")  # noqa: E501

        self._target_path = target_path

    @property
    def target_snapshot_alias(self):
        """Gets the target_snapshot_alias of this SyncPolicyCreateParams.  # noqa: E501

        The alias of the snapshot taken on the target cluster after the sync completes. A value of @DEFAULT will reset this field to the default creation value.  # noqa: E501

        :return: The target_snapshot_alias of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._target_snapshot_alias

    @target_snapshot_alias.setter
    def target_snapshot_alias(self, target_snapshot_alias):
        """Sets the target_snapshot_alias of this SyncPolicyCreateParams.

        The alias of the snapshot taken on the target cluster after the sync completes. A value of @DEFAULT will reset this field to the default creation value.  # noqa: E501

        :param target_snapshot_alias: The target_snapshot_alias of this SyncPolicyCreateParams.  # noqa: E501
        :type: str
        """

        self._target_snapshot_alias = target_snapshot_alias

    @property
    def target_snapshot_archive(self):
        """Gets the target_snapshot_archive of this SyncPolicyCreateParams.  # noqa: E501

        If true, archival snapshots of the target data will be taken on the target cluster after successful sync completions.  # noqa: E501

        :return: The target_snapshot_archive of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._target_snapshot_archive

    @target_snapshot_archive.setter
    def target_snapshot_archive(self, target_snapshot_archive):
        """Sets the target_snapshot_archive of this SyncPolicyCreateParams.

        If true, archival snapshots of the target data will be taken on the target cluster after successful sync completions.  # noqa: E501

        :param target_snapshot_archive: The target_snapshot_archive of this SyncPolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._target_snapshot_archive = target_snapshot_archive

    @property
    def target_snapshot_expiration(self):
        """Gets the target_snapshot_expiration of this SyncPolicyCreateParams.  # noqa: E501

        The length of time in seconds to keep snapshots on the target cluster.  # noqa: E501

        :return: The target_snapshot_expiration of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._target_snapshot_expiration

    @target_snapshot_expiration.setter
    def target_snapshot_expiration(self, target_snapshot_expiration):
        """Sets the target_snapshot_expiration of this SyncPolicyCreateParams.

        The length of time in seconds to keep snapshots on the target cluster.  # noqa: E501

        :param target_snapshot_expiration: The target_snapshot_expiration of this SyncPolicyCreateParams.  # noqa: E501
        :type: int
        """
        if target_snapshot_expiration is not None and target_snapshot_expiration < 0:  # noqa: E501
            raise ValueError("Invalid value for `target_snapshot_expiration`, must be a value greater than or equal to `0`")  # noqa: E501

        self._target_snapshot_expiration = target_snapshot_expiration

    @property
    def target_snapshot_pattern(self):
        """Gets the target_snapshot_pattern of this SyncPolicyCreateParams.  # noqa: E501

        The name pattern for snapshots taken on the target cluster after the sync completes.  A value of @DEFAULT will reset this field to the default creation value.  # noqa: E501

        :return: The target_snapshot_pattern of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._target_snapshot_pattern

    @target_snapshot_pattern.setter
    def target_snapshot_pattern(self, target_snapshot_pattern):
        """Sets the target_snapshot_pattern of this SyncPolicyCreateParams.

        The name pattern for snapshots taken on the target cluster after the sync completes.  A value of @DEFAULT will reset this field to the default creation value.  # noqa: E501

        :param target_snapshot_pattern: The target_snapshot_pattern of this SyncPolicyCreateParams.  # noqa: E501
        :type: str
        """

        self._target_snapshot_pattern = target_snapshot_pattern

    @property
    def workers_per_node(self):
        """Gets the workers_per_node of this SyncPolicyCreateParams.  # noqa: E501

        The number of worker threads on a node performing a sync.  # noqa: E501

        :return: The workers_per_node of this SyncPolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._workers_per_node

    @workers_per_node.setter
    def workers_per_node(self, workers_per_node):
        """Sets the workers_per_node of this SyncPolicyCreateParams.

        The number of worker threads on a node performing a sync.  # noqa: E501

        :param workers_per_node: The workers_per_node of this SyncPolicyCreateParams.  # noqa: E501
        :type: int
        """
        if workers_per_node is not None and workers_per_node > 20:  # noqa: E501
            raise ValueError("Invalid value for `workers_per_node`, must be a value less than or equal to `20`")  # noqa: E501
        if workers_per_node is not None and workers_per_node < 1:  # noqa: E501
            raise ValueError("Invalid value for `workers_per_node`, must be a value greater than or equal to `1`")  # noqa: E501

        self._workers_per_node = workers_per_node

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SyncPolicyCreateParams):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
