# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 2
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isi_sdk_7_2.models.cluster_config_device import ClusterConfigDevice  # noqa: F401,E501
from isi_sdk_7_2.models.cluster_config_onefs_version import ClusterConfigOnefsVersion  # noqa: F401,E501
from isi_sdk_7_2.models.cluster_config_timezone import ClusterConfigTimezone  # noqa: F401,E501


class ClusterConfig(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'description': 'str',
        'devices': 'list[ClusterConfigDevice]',
        'encoding': 'str',
        'guid': 'str',
        'is_compliance': 'bool',
        'is_rolling_upgrade': 'bool',
        'join_mode': 'str',
        'local_devid': 'int',
        'local_lnn': 'int',
        'local_serial': 'str',
        'name': 'str',
        'onefs_version': 'ClusterConfigOnefsVersion',
        'timezone': 'ClusterConfigTimezone'
    }

    attribute_map = {
        'description': 'description',
        'devices': 'devices',
        'encoding': 'encoding',
        'guid': 'guid',
        'is_compliance': 'is_compliance',
        'is_rolling_upgrade': 'is_rolling_upgrade',
        'join_mode': 'join_mode',
        'local_devid': 'local_devid',
        'local_lnn': 'local_lnn',
        'local_serial': 'local_serial',
        'name': 'name',
        'onefs_version': 'onefs_version',
        'timezone': 'timezone'
    }

    def __init__(self, description=None, devices=None, encoding=None, guid=None, is_compliance=None, is_rolling_upgrade=None, join_mode=None, local_devid=None, local_lnn=None, local_serial=None, name=None, onefs_version=None, timezone=None):  # noqa: E501
        """ClusterConfig - a model defined in Swagger"""  # noqa: E501

        self._description = None
        self._devices = None
        self._encoding = None
        self._guid = None
        self._is_compliance = None
        self._is_rolling_upgrade = None
        self._join_mode = None
        self._local_devid = None
        self._local_lnn = None
        self._local_serial = None
        self._name = None
        self._onefs_version = None
        self._timezone = None
        self.discriminator = None

        self.description = description
        self.devices = devices
        self.encoding = encoding
        self.guid = guid
        self.is_compliance = is_compliance
        self.is_rolling_upgrade = is_rolling_upgrade
        self.join_mode = join_mode
        self.local_devid = local_devid
        self.local_lnn = local_lnn
        self.local_serial = local_serial
        self.name = name
        self.onefs_version = onefs_version
        self.timezone = timezone

    @property
    def description(self):
        """Gets the description of this ClusterConfig.  # noqa: E501

        Customer configurable description.  # noqa: E501

        :return: The description of this ClusterConfig.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ClusterConfig.

        Customer configurable description.  # noqa: E501

        :param description: The description of this ClusterConfig.  # noqa: E501
        :type: str
        """
        if description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def devices(self):
        """Gets the devices of this ClusterConfig.  # noqa: E501


        :return: The devices of this ClusterConfig.  # noqa: E501
        :rtype: list[ClusterConfigDevice]
        """
        return self._devices

    @devices.setter
    def devices(self, devices):
        """Sets the devices of this ClusterConfig.


        :param devices: The devices of this ClusterConfig.  # noqa: E501
        :type: list[ClusterConfigDevice]
        """
        if devices is None:
            raise ValueError("Invalid value for `devices`, must not be `None`")  # noqa: E501

        self._devices = devices

    @property
    def encoding(self):
        """Gets the encoding of this ClusterConfig.  # noqa: E501

        Default encoding.  # noqa: E501

        :return: The encoding of this ClusterConfig.  # noqa: E501
        :rtype: str
        """
        return self._encoding

    @encoding.setter
    def encoding(self, encoding):
        """Sets the encoding of this ClusterConfig.

        Default encoding.  # noqa: E501

        :param encoding: The encoding of this ClusterConfig.  # noqa: E501
        :type: str
        """
        if encoding is None:
            raise ValueError("Invalid value for `encoding`, must not be `None`")  # noqa: E501

        self._encoding = encoding

    @property
    def guid(self):
        """Gets the guid of this ClusterConfig.  # noqa: E501

        Cluster GUID.  # noqa: E501

        :return: The guid of this ClusterConfig.  # noqa: E501
        :rtype: str
        """
        return self._guid

    @guid.setter
    def guid(self, guid):
        """Sets the guid of this ClusterConfig.

        Cluster GUID.  # noqa: E501

        :param guid: The guid of this ClusterConfig.  # noqa: E501
        :type: str
        """
        if guid is None:
            raise ValueError("Invalid value for `guid`, must not be `None`")  # noqa: E501

        self._guid = guid

    @property
    def is_compliance(self):
        """Gets the is_compliance of this ClusterConfig.  # noqa: E501

        If true, the cluster is in compliance mode.  Compliance mode clusters do not allow root access and have stricter WORM (Write Once Read Many) features for retaining data in compliance with U.S. Securities and Exchange Commission rule 17a-4.  # noqa: E501

        :return: The is_compliance of this ClusterConfig.  # noqa: E501
        :rtype: bool
        """
        return self._is_compliance

    @is_compliance.setter
    def is_compliance(self, is_compliance):
        """Sets the is_compliance of this ClusterConfig.

        If true, the cluster is in compliance mode.  Compliance mode clusters do not allow root access and have stricter WORM (Write Once Read Many) features for retaining data in compliance with U.S. Securities and Exchange Commission rule 17a-4.  # noqa: E501

        :param is_compliance: The is_compliance of this ClusterConfig.  # noqa: E501
        :type: bool
        """
        if is_compliance is None:
            raise ValueError("Invalid value for `is_compliance`, must not be `None`")  # noqa: E501

        self._is_compliance = is_compliance

    @property
    def is_rolling_upgrade(self):
        """Gets the is_rolling_upgrade of this ClusterConfig.  # noqa: E501

        If true, the cluster is currently performing a rolling upgrade.  # noqa: E501

        :return: The is_rolling_upgrade of this ClusterConfig.  # noqa: E501
        :rtype: bool
        """
        return self._is_rolling_upgrade

    @is_rolling_upgrade.setter
    def is_rolling_upgrade(self, is_rolling_upgrade):
        """Sets the is_rolling_upgrade of this ClusterConfig.

        If true, the cluster is currently performing a rolling upgrade.  # noqa: E501

        :param is_rolling_upgrade: The is_rolling_upgrade of this ClusterConfig.  # noqa: E501
        :type: bool
        """
        if is_rolling_upgrade is None:
            raise ValueError("Invalid value for `is_rolling_upgrade`, must not be `None`")  # noqa: E501

        self._is_rolling_upgrade = is_rolling_upgrade

    @property
    def join_mode(self):
        """Gets the join_mode of this ClusterConfig.  # noqa: E501

        Node join mode: 'manual', 'automatic', or 'secure'.  # noqa: E501

        :return: The join_mode of this ClusterConfig.  # noqa: E501
        :rtype: str
        """
        return self._join_mode

    @join_mode.setter
    def join_mode(self, join_mode):
        """Sets the join_mode of this ClusterConfig.

        Node join mode: 'manual', 'automatic', or 'secure'.  # noqa: E501

        :param join_mode: The join_mode of this ClusterConfig.  # noqa: E501
        :type: str
        """
        if join_mode is None:
            raise ValueError("Invalid value for `join_mode`, must not be `None`")  # noqa: E501

        self._join_mode = join_mode

    @property
    def local_devid(self):
        """Gets the local_devid of this ClusterConfig.  # noqa: E501

        Device ID of the queried node.  # noqa: E501

        :return: The local_devid of this ClusterConfig.  # noqa: E501
        :rtype: int
        """
        return self._local_devid

    @local_devid.setter
    def local_devid(self, local_devid):
        """Sets the local_devid of this ClusterConfig.

        Device ID of the queried node.  # noqa: E501

        :param local_devid: The local_devid of this ClusterConfig.  # noqa: E501
        :type: int
        """
        if local_devid is None:
            raise ValueError("Invalid value for `local_devid`, must not be `None`")  # noqa: E501

        self._local_devid = local_devid

    @property
    def local_lnn(self):
        """Gets the local_lnn of this ClusterConfig.  # noqa: E501

        Device logical node number of the queried node.  # noqa: E501

        :return: The local_lnn of this ClusterConfig.  # noqa: E501
        :rtype: int
        """
        return self._local_lnn

    @local_lnn.setter
    def local_lnn(self, local_lnn):
        """Sets the local_lnn of this ClusterConfig.

        Device logical node number of the queried node.  # noqa: E501

        :param local_lnn: The local_lnn of this ClusterConfig.  # noqa: E501
        :type: int
        """
        if local_lnn is None:
            raise ValueError("Invalid value for `local_lnn`, must not be `None`")  # noqa: E501

        self._local_lnn = local_lnn

    @property
    def local_serial(self):
        """Gets the local_serial of this ClusterConfig.  # noqa: E501

        Device serial number of the queried node.  # noqa: E501

        :return: The local_serial of this ClusterConfig.  # noqa: E501
        :rtype: str
        """
        return self._local_serial

    @local_serial.setter
    def local_serial(self, local_serial):
        """Sets the local_serial of this ClusterConfig.

        Device serial number of the queried node.  # noqa: E501

        :param local_serial: The local_serial of this ClusterConfig.  # noqa: E501
        :type: str
        """
        if local_serial is None:
            raise ValueError("Invalid value for `local_serial`, must not be `None`")  # noqa: E501

        self._local_serial = local_serial

    @property
    def name(self):
        """Gets the name of this ClusterConfig.  # noqa: E501

        Cluster name.  # noqa: E501

        :return: The name of this ClusterConfig.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ClusterConfig.

        Cluster name.  # noqa: E501

        :param name: The name of this ClusterConfig.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def onefs_version(self):
        """Gets the onefs_version of this ClusterConfig.  # noqa: E501

          # noqa: E501

        :return: The onefs_version of this ClusterConfig.  # noqa: E501
        :rtype: ClusterConfigOnefsVersion
        """
        return self._onefs_version

    @onefs_version.setter
    def onefs_version(self, onefs_version):
        """Sets the onefs_version of this ClusterConfig.

          # noqa: E501

        :param onefs_version: The onefs_version of this ClusterConfig.  # noqa: E501
        :type: ClusterConfigOnefsVersion
        """
        if onefs_version is None:
            raise ValueError("Invalid value for `onefs_version`, must not be `None`")  # noqa: E501

        self._onefs_version = onefs_version

    @property
    def timezone(self):
        """Gets the timezone of this ClusterConfig.  # noqa: E501

          # noqa: E501

        :return: The timezone of this ClusterConfig.  # noqa: E501
        :rtype: ClusterConfigTimezone
        """
        return self._timezone

    @timezone.setter
    def timezone(self, timezone):
        """Sets the timezone of this ClusterConfig.

          # noqa: E501

        :param timezone: The timezone of this ClusterConfig.  # noqa: E501
        :type: ClusterConfigTimezone
        """
        if timezone is None:
            raise ValueError("Invalid value for `timezone`, must not be `None`")  # noqa: E501

        self._timezone = timezone

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
