# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 2
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isi_sdk_7_2.api_client import ApiClient


class SyncApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_sync_job(self, sync_job, **kwargs):  # noqa: E501
        """create_sync_job  # noqa: E501

        Start a SyncIQ job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_sync_job(sync_job, async=True)
        >>> result = thread.get()

        :param async bool
        :param SyncJobCreateParams sync_job: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_sync_job_with_http_info(sync_job, **kwargs)  # noqa: E501
        else:
            (data) = self.create_sync_job_with_http_info(sync_job, **kwargs)  # noqa: E501
            return data

    def create_sync_job_with_http_info(self, sync_job, **kwargs):  # noqa: E501
        """create_sync_job  # noqa: E501

        Start a SyncIQ job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_sync_job_with_http_info(sync_job, async=True)
        >>> result = thread.get()

        :param async bool
        :param SyncJobCreateParams sync_job: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_job']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sync_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_job' is set
        if ('sync_job' not in params or
                params['sync_job'] is None):
            raise ValueError("Missing the required parameter `sync_job` when calling `create_sync_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sync_job' in params:
            body_params = params['sync_job']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/jobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_sync_policy(self, sync_policy, **kwargs):  # noqa: E501
        """create_sync_policy  # noqa: E501

        Create a SyncIQ policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_sync_policy(sync_policy, async=True)
        >>> result = thread.get()

        :param async bool
        :param SyncPolicyCreateParams sync_policy: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_sync_policy_with_http_info(sync_policy, **kwargs)  # noqa: E501
        else:
            (data) = self.create_sync_policy_with_http_info(sync_policy, **kwargs)  # noqa: E501
            return data

    def create_sync_policy_with_http_info(self, sync_policy, **kwargs):  # noqa: E501
        """create_sync_policy  # noqa: E501

        Create a SyncIQ policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_sync_policy_with_http_info(sync_policy, async=True)
        >>> result = thread.get()

        :param async bool
        :param SyncPolicyCreateParams sync_policy: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_policy']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sync_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_policy' is set
        if ('sync_policy' not in params or
                params['sync_policy'] is None):
            raise ValueError("Missing the required parameter `sync_policy` when calling `create_sync_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sync_policy' in params:
            body_params = params['sync_policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/policies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_sync_reports_rotate_item(self, sync_reports_rotate_item, **kwargs):  # noqa: E501
        """create_sync_reports_rotate_item  # noqa: E501

        Rotate the records in the database(s).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_sync_reports_rotate_item(sync_reports_rotate_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param Empty sync_reports_rotate_item: (required)
        :return: CreateSyncReportsRotateItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_sync_reports_rotate_item_with_http_info(sync_reports_rotate_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_sync_reports_rotate_item_with_http_info(sync_reports_rotate_item, **kwargs)  # noqa: E501
            return data

    def create_sync_reports_rotate_item_with_http_info(self, sync_reports_rotate_item, **kwargs):  # noqa: E501
        """create_sync_reports_rotate_item  # noqa: E501

        Rotate the records in the database(s).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_sync_reports_rotate_item_with_http_info(sync_reports_rotate_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param Empty sync_reports_rotate_item: (required)
        :return: CreateSyncReportsRotateItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_reports_rotate_item']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sync_reports_rotate_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_reports_rotate_item' is set
        if ('sync_reports_rotate_item' not in params or
                params['sync_reports_rotate_item'] is None):
            raise ValueError("Missing the required parameter `sync_reports_rotate_item` when calling `create_sync_reports_rotate_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sync_reports_rotate_item' in params:
            body_params = params['sync_reports_rotate_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/reports-rotate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateSyncReportsRotateItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_sync_rule(self, sync_rule, **kwargs):  # noqa: E501
        """create_sync_rule  # noqa: E501

        Create a new SyncIQ performance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_sync_rule(sync_rule, async=True)
        >>> result = thread.get()

        :param async bool
        :param SyncRuleCreateParams sync_rule: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_sync_rule_with_http_info(sync_rule, **kwargs)  # noqa: E501
        else:
            (data) = self.create_sync_rule_with_http_info(sync_rule, **kwargs)  # noqa: E501
            return data

    def create_sync_rule_with_http_info(self, sync_rule, **kwargs):  # noqa: E501
        """create_sync_rule  # noqa: E501

        Create a new SyncIQ performance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_sync_rule_with_http_info(sync_rule, async=True)
        >>> result = thread.get()

        :param async bool
        :param SyncRuleCreateParams sync_rule: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_rule']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sync_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_rule' is set
        if ('sync_rule' not in params or
                params['sync_rule'] is None):
            raise ValueError("Missing the required parameter `sync_rule` when calling `create_sync_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sync_rule' in params:
            body_params = params['sync_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/rules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_sync_policies(self, **kwargs):  # noqa: E501
        """delete_sync_policies  # noqa: E501

        Delete all SyncIQ policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_sync_policies(async=True)
        >>> result = thread.get()

        :param async bool
        :param bool local_only: Skip deleting the policy association on the target.
        :param bool force: Ignore any running jobs when preparing to delete a policy.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_sync_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_sync_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_sync_policies_with_http_info(self, **kwargs):  # noqa: E501
        """delete_sync_policies  # noqa: E501

        Delete all SyncIQ policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_sync_policies_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param bool local_only: Skip deleting the policy association on the target.
        :param bool force: Ignore any running jobs when preparing to delete a policy.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['local_only', 'force']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sync_policies" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'local_only' in params:
            query_params.append(('local_only', params['local_only']))  # noqa: E501
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/policies', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_sync_policy(self, sync_policy_id, **kwargs):  # noqa: E501
        """delete_sync_policy  # noqa: E501

        Delete a single SyncIQ policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_sync_policy(sync_policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str sync_policy_id: Delete a single SyncIQ policy. (required)
        :param bool local_only: Skip deleting the policy association on the target.
        :param bool force: Ignore any running jobs when preparing to delete a policy.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_sync_policy_with_http_info(sync_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_sync_policy_with_http_info(sync_policy_id, **kwargs)  # noqa: E501
            return data

    def delete_sync_policy_with_http_info(self, sync_policy_id, **kwargs):  # noqa: E501
        """delete_sync_policy  # noqa: E501

        Delete a single SyncIQ policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_sync_policy_with_http_info(sync_policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str sync_policy_id: Delete a single SyncIQ policy. (required)
        :param bool local_only: Skip deleting the policy association on the target.
        :param bool force: Ignore any running jobs when preparing to delete a policy.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_policy_id', 'local_only', 'force']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sync_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_policy_id' is set
        if ('sync_policy_id' not in params or
                params['sync_policy_id'] is None):
            raise ValueError("Missing the required parameter `sync_policy_id` when calling `delete_sync_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_policy_id' in params:
            path_params['SyncPolicyId'] = params['sync_policy_id']  # noqa: E501

        query_params = []
        if 'local_only' in params:
            query_params.append(('local_only', params['local_only']))  # noqa: E501
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/policies/{SyncPolicyId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_sync_rule(self, sync_rule_id, **kwargs):  # noqa: E501
        """delete_sync_rule  # noqa: E501

        Delete a single SyncIQ performance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_sync_rule(sync_rule_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str sync_rule_id: Delete a single SyncIQ performance rule. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_sync_rule_with_http_info(sync_rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_sync_rule_with_http_info(sync_rule_id, **kwargs)  # noqa: E501
            return data

    def delete_sync_rule_with_http_info(self, sync_rule_id, **kwargs):  # noqa: E501
        """delete_sync_rule  # noqa: E501

        Delete a single SyncIQ performance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_sync_rule_with_http_info(sync_rule_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str sync_rule_id: Delete a single SyncIQ performance rule. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_rule_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sync_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_rule_id' is set
        if ('sync_rule_id' not in params or
                params['sync_rule_id'] is None):
            raise ValueError("Missing the required parameter `sync_rule_id` when calling `delete_sync_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_rule_id' in params:
            path_params['SyncRuleId'] = params['sync_rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/rules/{SyncRuleId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_sync_rules(self, **kwargs):  # noqa: E501
        """delete_sync_rules  # noqa: E501

        Delete all SyncIQ performance rules or all rules of a specified type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_sync_rules(async=True)
        >>> result = thread.get()

        :param async bool
        :param str type: Delete all rules of the specified rule type only.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_sync_rules_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_sync_rules_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_sync_rules_with_http_info(self, **kwargs):  # noqa: E501
        """delete_sync_rules  # noqa: E501

        Delete all SyncIQ performance rules or all rules of a specified type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_sync_rules_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str type: Delete all rules of the specified rule type only.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sync_rules" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/rules', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_target_policy(self, target_policy_id, **kwargs):  # noqa: E501
        """delete_target_policy  # noqa: E501

        Break the target association with this cluster for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_target_policy(target_policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str target_policy_id: Break the target association with this cluster for this policy. (required)
        :param bool force: Ignore any running jobs when preparing to delete the policy target association.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_target_policy_with_http_info(target_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_target_policy_with_http_info(target_policy_id, **kwargs)  # noqa: E501
            return data

    def delete_target_policy_with_http_info(self, target_policy_id, **kwargs):  # noqa: E501
        """delete_target_policy  # noqa: E501

        Break the target association with this cluster for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_target_policy_with_http_info(target_policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str target_policy_id: Break the target association with this cluster for this policy. (required)
        :param bool force: Ignore any running jobs when preparing to delete the policy target association.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['target_policy_id', 'force']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_target_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'target_policy_id' is set
        if ('target_policy_id' not in params or
                params['target_policy_id'] is None):
            raise ValueError("Missing the required parameter `target_policy_id` when calling `delete_target_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'target_policy_id' in params:
            path_params['TargetPolicyId'] = params['target_policy_id']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/target/policies/{TargetPolicyId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_history_file(self, **kwargs):  # noqa: E501
        """get_history_file  # noqa: E501

        List file operations performance data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_history_file(async=True)
        >>> result = thread.get()

        :param async bool
        :param int begin: Begin timestamp for time-series report.
        :param int end: End timestamp for time-series report.
        :return: HistoryFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_history_file_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_history_file_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_history_file_with_http_info(self, **kwargs):  # noqa: E501
        """get_history_file  # noqa: E501

        List file operations performance data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_history_file_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int begin: Begin timestamp for time-series report.
        :param int end: End timestamp for time-series report.
        :return: HistoryFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['begin', 'end']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_history_file" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/history/file', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryFile',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_history_network(self, **kwargs):  # noqa: E501
        """get_history_network  # noqa: E501

        List network operations performance data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_history_network(async=True)
        >>> result = thread.get()

        :param async bool
        :param int begin: Begin timestamp for time-series report.
        :param int end: End timestamp for time-series report.
        :return: HistoryFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_history_network_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_history_network_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_history_network_with_http_info(self, **kwargs):  # noqa: E501
        """get_history_network  # noqa: E501

        List network operations performance data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_history_network_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int begin: Begin timestamp for time-series report.
        :param int end: End timestamp for time-series report.
        :return: HistoryFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['begin', 'end']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_history_network" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/history/network', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryFile',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sync_job(self, sync_job_id, **kwargs):  # noqa: E501
        """get_sync_job  # noqa: E501

        View a single SyncIQ job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sync_job(sync_job_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str sync_job_id: View a single SyncIQ job. (required)
        :return: SyncJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_sync_job_with_http_info(sync_job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sync_job_with_http_info(sync_job_id, **kwargs)  # noqa: E501
            return data

    def get_sync_job_with_http_info(self, sync_job_id, **kwargs):  # noqa: E501
        """get_sync_job  # noqa: E501

        View a single SyncIQ job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sync_job_with_http_info(sync_job_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str sync_job_id: View a single SyncIQ job. (required)
        :return: SyncJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_job_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sync_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_job_id' is set
        if ('sync_job_id' not in params or
                params['sync_job_id'] is None):
            raise ValueError("Missing the required parameter `sync_job_id` when calling `get_sync_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_job_id' in params:
            path_params['SyncJobId'] = params['sync_job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/jobs/{SyncJobId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncJobs',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sync_license(self, **kwargs):  # noqa: E501
        """get_sync_license  # noqa: E501

        Retrieve license information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sync_license(async=True)
        >>> result = thread.get()

        :param async bool
        :return: LicenseLicense
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_sync_license_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_sync_license_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_sync_license_with_http_info(self, **kwargs):  # noqa: E501
        """get_sync_license  # noqa: E501

        Retrieve license information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sync_license_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: LicenseLicense
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sync_license" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/license', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LicenseLicense',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sync_policy(self, sync_policy_id, **kwargs):  # noqa: E501
        """get_sync_policy  # noqa: E501

        View a single SyncIQ policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sync_policy(sync_policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str sync_policy_id: View a single SyncIQ policy. (required)
        :return: SyncPolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_sync_policy_with_http_info(sync_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sync_policy_with_http_info(sync_policy_id, **kwargs)  # noqa: E501
            return data

    def get_sync_policy_with_http_info(self, sync_policy_id, **kwargs):  # noqa: E501
        """get_sync_policy  # noqa: E501

        View a single SyncIQ policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sync_policy_with_http_info(sync_policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str sync_policy_id: View a single SyncIQ policy. (required)
        :return: SyncPolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_policy_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sync_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_policy_id' is set
        if ('sync_policy_id' not in params or
                params['sync_policy_id'] is None):
            raise ValueError("Missing the required parameter `sync_policy_id` when calling `get_sync_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_policy_id' in params:
            path_params['SyncPolicyId'] = params['sync_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/policies/{SyncPolicyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncPolicies',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sync_report(self, sync_report_id, **kwargs):  # noqa: E501
        """get_sync_report  # noqa: E501

        View a single SyncIQ report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sync_report(sync_report_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str sync_report_id: View a single SyncIQ report. (required)
        :return: SyncReports
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_sync_report_with_http_info(sync_report_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sync_report_with_http_info(sync_report_id, **kwargs)  # noqa: E501
            return data

    def get_sync_report_with_http_info(self, sync_report_id, **kwargs):  # noqa: E501
        """get_sync_report  # noqa: E501

        View a single SyncIQ report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sync_report_with_http_info(sync_report_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str sync_report_id: View a single SyncIQ report. (required)
        :return: SyncReports
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_report_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sync_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_report_id' is set
        if ('sync_report_id' not in params or
                params['sync_report_id'] is None):
            raise ValueError("Missing the required parameter `sync_report_id` when calling `get_sync_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_report_id' in params:
            path_params['SyncReportId'] = params['sync_report_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/reports/{SyncReportId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncReports',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sync_reports(self, **kwargs):  # noqa: E501
        """get_sync_reports  # noqa: E501

        Get a list of SyncIQ reports.  By default 10 reports are returned per policy, unless otherwise specified by 'reports_per_policy'.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sync_reports(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int newer_than: Filter the returned reports to include only those whose jobs started more recently than the specified number of days ago.
        :param str policy_name: Filter the returned reports to include only those with this policy name.
        :param str state: Filter the returned reports to include only those whose jobs are in this state.
        :param int limit: Return no more than this many results at once (see resume).
        :param int reports_per_policy: If specified, only the N most recent reports will be returned per policy.  If no other query args are present this argument defaults to 10. 
        :param str dir: The direction of the sort.
        :return: SyncReportsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_sync_reports_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_sync_reports_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_sync_reports_with_http_info(self, **kwargs):  # noqa: E501
        """get_sync_reports  # noqa: E501

        Get a list of SyncIQ reports.  By default 10 reports are returned per policy, unless otherwise specified by 'reports_per_policy'.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sync_reports_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int newer_than: Filter the returned reports to include only those whose jobs started more recently than the specified number of days ago.
        :param str policy_name: Filter the returned reports to include only those with this policy name.
        :param str state: Filter the returned reports to include only those whose jobs are in this state.
        :param int limit: Return no more than this many results at once (see resume).
        :param int reports_per_policy: If specified, only the N most recent reports will be returned per policy.  If no other query args are present this argument defaults to 10. 
        :param str dir: The direction of the sort.
        :return: SyncReportsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'resume', 'newer_than', 'policy_name', 'state', 'limit', 'reports_per_policy', 'dir']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sync_reports" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_sync_reports`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'newer_than' in params:
            query_params.append(('newer_than', params['newer_than']))  # noqa: E501
        if 'policy_name' in params:
            query_params.append(('policy_name', params['policy_name']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'reports_per_policy' in params:
            query_params.append(('reports_per_policy', params['reports_per_policy']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncReportsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sync_rule(self, sync_rule_id, **kwargs):  # noqa: E501
        """get_sync_rule  # noqa: E501

        View a single SyncIQ performance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sync_rule(sync_rule_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str sync_rule_id: View a single SyncIQ performance rule. (required)
        :return: SyncRules
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_sync_rule_with_http_info(sync_rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sync_rule_with_http_info(sync_rule_id, **kwargs)  # noqa: E501
            return data

    def get_sync_rule_with_http_info(self, sync_rule_id, **kwargs):  # noqa: E501
        """get_sync_rule  # noqa: E501

        View a single SyncIQ performance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sync_rule_with_http_info(sync_rule_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str sync_rule_id: View a single SyncIQ performance rule. (required)
        :return: SyncRules
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_rule_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sync_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_rule_id' is set
        if ('sync_rule_id' not in params or
                params['sync_rule_id'] is None):
            raise ValueError("Missing the required parameter `sync_rule_id` when calling `get_sync_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_rule_id' in params:
            path_params['SyncRuleId'] = params['sync_rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/rules/{SyncRuleId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncRules',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sync_settings(self, **kwargs):  # noqa: E501
        """get_sync_settings  # noqa: E501

        Retrieve the global SyncIQ settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sync_settings(async=True)
        >>> result = thread.get()

        :param async bool
        :return: SyncSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_sync_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_sync_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_sync_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_sync_settings  # noqa: E501

        Retrieve the global SyncIQ settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sync_settings_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: SyncSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sync_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncSettings',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_target_policies(self, **kwargs):  # noqa: E501
        """get_target_policies  # noqa: E501

        List all SyncIQ target policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_target_policies(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str target_path: Filter the returned policies to include only those with this target path.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: TargetPoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_target_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_target_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_target_policies_with_http_info(self, **kwargs):  # noqa: E501
        """get_target_policies  # noqa: E501

        List all SyncIQ target policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_target_policies_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str target_path: Filter the returned policies to include only those with this target path.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: TargetPoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'target_path', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_target_policies" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_target_policies`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'target_path' in params:
            query_params.append(('target_path', params['target_path']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/target/policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TargetPoliciesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_target_policy(self, target_policy_id, **kwargs):  # noqa: E501
        """get_target_policy  # noqa: E501

        View a single SyncIQ target policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_target_policy(target_policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str target_policy_id: View a single SyncIQ target policy. (required)
        :return: TargetPolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_target_policy_with_http_info(target_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_target_policy_with_http_info(target_policy_id, **kwargs)  # noqa: E501
            return data

    def get_target_policy_with_http_info(self, target_policy_id, **kwargs):  # noqa: E501
        """get_target_policy  # noqa: E501

        View a single SyncIQ target policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_target_policy_with_http_info(target_policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str target_policy_id: View a single SyncIQ target policy. (required)
        :return: TargetPolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['target_policy_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_target_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'target_policy_id' is set
        if ('target_policy_id' not in params or
                params['target_policy_id'] is None):
            raise ValueError("Missing the required parameter `target_policy_id` when calling `get_target_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'target_policy_id' in params:
            path_params['TargetPolicyId'] = params['target_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/target/policies/{TargetPolicyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TargetPolicies',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_target_report(self, target_report_id, **kwargs):  # noqa: E501
        """get_target_report  # noqa: E501

        View a single SyncIQ target report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_target_report(target_report_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str target_report_id: View a single SyncIQ target report. (required)
        :return: TargetReports
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_target_report_with_http_info(target_report_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_target_report_with_http_info(target_report_id, **kwargs)  # noqa: E501
            return data

    def get_target_report_with_http_info(self, target_report_id, **kwargs):  # noqa: E501
        """get_target_report  # noqa: E501

        View a single SyncIQ target report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_target_report_with_http_info(target_report_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str target_report_id: View a single SyncIQ target report. (required)
        :return: TargetReports
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['target_report_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_target_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'target_report_id' is set
        if ('target_report_id' not in params or
                params['target_report_id'] is None):
            raise ValueError("Missing the required parameter `target_report_id` when calling `get_target_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'target_report_id' in params:
            path_params['TargetReportId'] = params['target_report_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/target/reports/{TargetReportId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TargetReports',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_target_reports(self, **kwargs):  # noqa: E501
        """get_target_reports  # noqa: E501

        Get a list of SyncIQ target reports.  By default 10 reports are returned per policy, unless otherwise specified by 'reports_per_policy'.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_target_reports(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int newer_than: Filter the returned reports to include only those whose jobs started more recently than the specified number of days ago.
        :param str policy_name: Filter the returned reports to include only those with this policy name.
        :param str state: Filter the returned reports to include only those whose jobs are in this state.
        :param int limit: Return no more than this many results at once (see resume).
        :param int reports_per_policy: If specified, only the N most recent reports will be returned per policy.  If no other query args are present this argument defaults to 10. 
        :param str dir: The direction of the sort.
        :return: TargetReportsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_target_reports_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_target_reports_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_target_reports_with_http_info(self, **kwargs):  # noqa: E501
        """get_target_reports  # noqa: E501

        Get a list of SyncIQ target reports.  By default 10 reports are returned per policy, unless otherwise specified by 'reports_per_policy'.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_target_reports_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int newer_than: Filter the returned reports to include only those whose jobs started more recently than the specified number of days ago.
        :param str policy_name: Filter the returned reports to include only those with this policy name.
        :param str state: Filter the returned reports to include only those whose jobs are in this state.
        :param int limit: Return no more than this many results at once (see resume).
        :param int reports_per_policy: If specified, only the N most recent reports will be returned per policy.  If no other query args are present this argument defaults to 10. 
        :param str dir: The direction of the sort.
        :return: TargetReportsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'resume', 'newer_than', 'policy_name', 'state', 'limit', 'reports_per_policy', 'dir']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_target_reports" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_target_reports`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'newer_than' in params:
            query_params.append(('newer_than', params['newer_than']))  # noqa: E501
        if 'policy_name' in params:
            query_params.append(('policy_name', params['policy_name']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'reports_per_policy' in params:
            query_params.append(('reports_per_policy', params['reports_per_policy']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/target/reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TargetReportsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_sync_jobs(self, **kwargs):  # noqa: E501
        """list_sync_jobs  # noqa: E501

        Get a list of SyncIQ jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_sync_jobs(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str state: The state of the job.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SyncJobsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_sync_jobs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_sync_jobs_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_sync_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """list_sync_jobs  # noqa: E501

        Get a list of SyncIQ jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_sync_jobs_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str state: The state of the job.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SyncJobsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'state', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_sync_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_sync_jobs`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncJobsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_sync_policies(self, **kwargs):  # noqa: E501
        """list_sync_policies  # noqa: E501

        List all SyncIQ policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_sync_policies(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool summary: Show only summary properties
        :param int limit: Return no more than this many results at once (see resume).
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str dir: The direction of the sort.
        :return: SyncPoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_sync_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_sync_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_sync_policies_with_http_info(self, **kwargs):  # noqa: E501
        """list_sync_policies  # noqa: E501

        List all SyncIQ policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_sync_policies_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool summary: Show only summary properties
        :param int limit: Return no more than this many results at once (see resume).
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str dir: The direction of the sort.
        :return: SyncPoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'resume', 'summary', 'limit', 'scope', 'dir']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_sync_policies" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_sync_policies`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'summary' in params:
            query_params.append(('summary', params['summary']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncPoliciesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_sync_reports_rotate(self, **kwargs):  # noqa: E501
        """list_sync_reports_rotate  # noqa: E501

        Whether the rotation is still running or not.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_sync_reports_rotate(async=True)
        >>> result = thread.get()

        :param async bool
        :return: SyncReportsRotate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_sync_reports_rotate_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_sync_reports_rotate_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_sync_reports_rotate_with_http_info(self, **kwargs):  # noqa: E501
        """list_sync_reports_rotate  # noqa: E501

        Whether the rotation is still running or not.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_sync_reports_rotate_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: SyncReportsRotate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_sync_reports_rotate" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/reports-rotate', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncReportsRotate',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_sync_rules(self, **kwargs):  # noqa: E501
        """list_sync_rules  # noqa: E501

        List all SyncIQ performance rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_sync_rules(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str type: Filter the returned rules to include only those with this rule type.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SyncRulesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_sync_rules_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_sync_rules_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_sync_rules_with_http_info(self, **kwargs):  # noqa: E501
        """list_sync_rules  # noqa: E501

        List all SyncIQ performance rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_sync_rules_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str type: Filter the returned rules to include only those with this rule type.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SyncRulesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'type', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_sync_rules" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_sync_rules`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncRulesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_sync_job(self, sync_job, sync_job_id, **kwargs):  # noqa: E501
        """update_sync_job  # noqa: E501

        Perform an action (pause, cancel, etc...) on a single job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_sync_job(sync_job, sync_job_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param SyncJob sync_job: (required)
        :param str sync_job_id: Perform an action (pause, cancel, etc...) on a single job. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_sync_job_with_http_info(sync_job, sync_job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_sync_job_with_http_info(sync_job, sync_job_id, **kwargs)  # noqa: E501
            return data

    def update_sync_job_with_http_info(self, sync_job, sync_job_id, **kwargs):  # noqa: E501
        """update_sync_job  # noqa: E501

        Perform an action (pause, cancel, etc...) on a single job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_sync_job_with_http_info(sync_job, sync_job_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param SyncJob sync_job: (required)
        :param str sync_job_id: Perform an action (pause, cancel, etc...) on a single job. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_job', 'sync_job_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_sync_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_job' is set
        if ('sync_job' not in params or
                params['sync_job'] is None):
            raise ValueError("Missing the required parameter `sync_job` when calling `update_sync_job`")  # noqa: E501
        # verify the required parameter 'sync_job_id' is set
        if ('sync_job_id' not in params or
                params['sync_job_id'] is None):
            raise ValueError("Missing the required parameter `sync_job_id` when calling `update_sync_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_job_id' in params:
            path_params['SyncJobId'] = params['sync_job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sync_job' in params:
            body_params = params['sync_job']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/jobs/{SyncJobId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_sync_policy(self, sync_policy, sync_policy_id, **kwargs):  # noqa: E501
        """update_sync_policy  # noqa: E501

        Modify a single SyncIQ policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_sync_policy(sync_policy, sync_policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param SyncPolicy sync_policy: (required)
        :param str sync_policy_id: Modify a single SyncIQ policy. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_sync_policy_with_http_info(sync_policy, sync_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_sync_policy_with_http_info(sync_policy, sync_policy_id, **kwargs)  # noqa: E501
            return data

    def update_sync_policy_with_http_info(self, sync_policy, sync_policy_id, **kwargs):  # noqa: E501
        """update_sync_policy  # noqa: E501

        Modify a single SyncIQ policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_sync_policy_with_http_info(sync_policy, sync_policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param SyncPolicy sync_policy: (required)
        :param str sync_policy_id: Modify a single SyncIQ policy. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_policy', 'sync_policy_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_sync_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_policy' is set
        if ('sync_policy' not in params or
                params['sync_policy'] is None):
            raise ValueError("Missing the required parameter `sync_policy` when calling `update_sync_policy`")  # noqa: E501
        # verify the required parameter 'sync_policy_id' is set
        if ('sync_policy_id' not in params or
                params['sync_policy_id'] is None):
            raise ValueError("Missing the required parameter `sync_policy_id` when calling `update_sync_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_policy_id' in params:
            path_params['SyncPolicyId'] = params['sync_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sync_policy' in params:
            body_params = params['sync_policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/policies/{SyncPolicyId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_sync_rule(self, sync_rule, sync_rule_id, **kwargs):  # noqa: E501
        """update_sync_rule  # noqa: E501

        Modify a single SyncIQ performance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_sync_rule(sync_rule, sync_rule_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param SyncRule sync_rule: (required)
        :param str sync_rule_id: Modify a single SyncIQ performance rule. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_sync_rule_with_http_info(sync_rule, sync_rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_sync_rule_with_http_info(sync_rule, sync_rule_id, **kwargs)  # noqa: E501
            return data

    def update_sync_rule_with_http_info(self, sync_rule, sync_rule_id, **kwargs):  # noqa: E501
        """update_sync_rule  # noqa: E501

        Modify a single SyncIQ performance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_sync_rule_with_http_info(sync_rule, sync_rule_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param SyncRule sync_rule: (required)
        :param str sync_rule_id: Modify a single SyncIQ performance rule. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_rule', 'sync_rule_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_sync_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_rule' is set
        if ('sync_rule' not in params or
                params['sync_rule'] is None):
            raise ValueError("Missing the required parameter `sync_rule` when calling `update_sync_rule`")  # noqa: E501
        # verify the required parameter 'sync_rule_id' is set
        if ('sync_rule_id' not in params or
                params['sync_rule_id'] is None):
            raise ValueError("Missing the required parameter `sync_rule_id` when calling `update_sync_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_rule_id' in params:
            path_params['SyncRuleId'] = params['sync_rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sync_rule' in params:
            body_params = params['sync_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/rules/{SyncRuleId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_sync_settings(self, sync_settings, **kwargs):  # noqa: E501
        """update_sync_settings  # noqa: E501

        Modify the global SyncIQ settings.  All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_sync_settings(sync_settings, async=True)
        >>> result = thread.get()

        :param async bool
        :param SyncSettingsSettings sync_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_sync_settings_with_http_info(sync_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_sync_settings_with_http_info(sync_settings, **kwargs)  # noqa: E501
            return data

    def update_sync_settings_with_http_info(self, sync_settings, **kwargs):  # noqa: E501
        """update_sync_settings  # noqa: E501

        Modify the global SyncIQ settings.  All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_sync_settings_with_http_info(sync_settings, async=True)
        >>> result = thread.get()

        :param async bool
        :param SyncSettingsSettings sync_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_settings']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_sync_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_settings' is set
        if ('sync_settings' not in params or
                params['sync_settings'] is None):
            raise ValueError("Missing the required parameter `sync_settings` when calling `update_sync_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sync_settings' in params:
            body_params = params['sync_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
