# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 2
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isi_sdk_7_2.api_client import ApiClient


class ProtocolsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_hdfs_proxyuser(self, hdfs_proxyuser, **kwargs):  # noqa: E501
        """create_hdfs_proxyuser  # noqa: E501

        Create a new HDFS proxyuser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_hdfs_proxyuser(hdfs_proxyuser, async=True)
        >>> result = thread.get()

        :param async bool
        :param HdfsProxyuserCreateParams hdfs_proxyuser: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_hdfs_proxyuser_with_http_info(hdfs_proxyuser, **kwargs)  # noqa: E501
        else:
            (data) = self.create_hdfs_proxyuser_with_http_info(hdfs_proxyuser, **kwargs)  # noqa: E501
            return data

    def create_hdfs_proxyuser_with_http_info(self, hdfs_proxyuser, **kwargs):  # noqa: E501
        """create_hdfs_proxyuser  # noqa: E501

        Create a new HDFS proxyuser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_hdfs_proxyuser_with_http_info(hdfs_proxyuser, async=True)
        >>> result = thread.get()

        :param async bool
        :param HdfsProxyuserCreateParams hdfs_proxyuser: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_proxyuser']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_hdfs_proxyuser" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_proxyuser' is set
        if ('hdfs_proxyuser' not in params or
                params['hdfs_proxyuser'] is None):
            raise ValueError("Missing the required parameter `hdfs_proxyuser` when calling `create_hdfs_proxyuser`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_proxyuser' in params:
            body_params = params['hdfs_proxyuser']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/proxyusers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_hdfs_rack(self, hdfs_rack, **kwargs):  # noqa: E501
        """create_hdfs_rack  # noqa: E501

        Create a new HDFS rack.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_hdfs_rack(hdfs_rack, async=True)
        >>> result = thread.get()

        :param async bool
        :param HdfsRackCreateParams hdfs_rack: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_hdfs_rack_with_http_info(hdfs_rack, **kwargs)  # noqa: E501
        else:
            (data) = self.create_hdfs_rack_with_http_info(hdfs_rack, **kwargs)  # noqa: E501
            return data

    def create_hdfs_rack_with_http_info(self, hdfs_rack, **kwargs):  # noqa: E501
        """create_hdfs_rack  # noqa: E501

        Create a new HDFS rack.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_hdfs_rack_with_http_info(hdfs_rack, async=True)
        >>> result = thread.get()

        :param async bool
        :param HdfsRackCreateParams hdfs_rack: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_rack']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_hdfs_rack" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_rack' is set
        if ('hdfs_rack' not in params or
                params['hdfs_rack'] is None):
            raise ValueError("Missing the required parameter `hdfs_rack` when calling `create_hdfs_rack`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_rack' in params:
            body_params = params['hdfs_rack']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/racks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_nfs_alias(self, nfs_alias, **kwargs):  # noqa: E501
        """create_nfs_alias  # noqa: E501

        Create a new NFS alias.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_nfs_alias(nfs_alias, async=True)
        >>> result = thread.get()

        :param async bool
        :param NfsAliasCreateParams nfs_alias: (required)
        :param str zone: Access zone
        :return: CreateNfsAliasResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_nfs_alias_with_http_info(nfs_alias, **kwargs)  # noqa: E501
        else:
            (data) = self.create_nfs_alias_with_http_info(nfs_alias, **kwargs)  # noqa: E501
            return data

    def create_nfs_alias_with_http_info(self, nfs_alias, **kwargs):  # noqa: E501
        """create_nfs_alias  # noqa: E501

        Create a new NFS alias.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_nfs_alias_with_http_info(nfs_alias, async=True)
        >>> result = thread.get()

        :param async bool
        :param NfsAliasCreateParams nfs_alias: (required)
        :param str zone: Access zone
        :return: CreateNfsAliasResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_alias', 'zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_nfs_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_alias' is set
        if ('nfs_alias' not in params or
                params['nfs_alias'] is None):
            raise ValueError("Missing the required parameter `nfs_alias` when calling `create_nfs_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_alias' in params:
            body_params = params['nfs_alias']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/aliases', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateNfsAliasResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_nfs_export(self, nfs_export, **kwargs):  # noqa: E501
        """create_nfs_export  # noqa: E501

        Create a new NFS export.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_nfs_export(nfs_export, async=True)
        >>> result = thread.get()

        :param async bool
        :param NfsExportCreateParams nfs_export: (required)
        :param bool force: If true, the export will be created even if it conflicts with another export.
        :param str zone: Access zone
        :return: CreateQuotaReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_nfs_export_with_http_info(nfs_export, **kwargs)  # noqa: E501
        else:
            (data) = self.create_nfs_export_with_http_info(nfs_export, **kwargs)  # noqa: E501
            return data

    def create_nfs_export_with_http_info(self, nfs_export, **kwargs):  # noqa: E501
        """create_nfs_export  # noqa: E501

        Create a new NFS export.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_nfs_export_with_http_info(nfs_export, async=True)
        >>> result = thread.get()

        :param async bool
        :param NfsExportCreateParams nfs_export: (required)
        :param bool force: If true, the export will be created even if it conflicts with another export.
        :param str zone: Access zone
        :return: CreateQuotaReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_export', 'force', 'zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_nfs_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_export' is set
        if ('nfs_export' not in params or
                params['nfs_export'] is None):
            raise ValueError("Missing the required parameter `nfs_export` when calling `create_nfs_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_export' in params:
            body_params = params['nfs_export']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/exports', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateQuotaReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_nfs_reload_item(self, nfs_reload_item, **kwargs):  # noqa: E501
        """create_nfs_reload_item  # noqa: E501

        Reload default NFS export configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_nfs_reload_item(nfs_reload_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param Empty nfs_reload_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_nfs_reload_item_with_http_info(nfs_reload_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_nfs_reload_item_with_http_info(nfs_reload_item, **kwargs)  # noqa: E501
            return data

    def create_nfs_reload_item_with_http_info(self, nfs_reload_item, **kwargs):  # noqa: E501
        """create_nfs_reload_item  # noqa: E501

        Reload default NFS export configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_nfs_reload_item_with_http_info(nfs_reload_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param Empty nfs_reload_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_reload_item']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_nfs_reload_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_reload_item' is set
        if ('nfs_reload_item' not in params or
                params['nfs_reload_item'] is None):
            raise ValueError("Missing the required parameter `nfs_reload_item` when calling `create_nfs_reload_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_reload_item' in params:
            body_params = params['nfs_reload_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/reload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_smb_share(self, smb_share, **kwargs):  # noqa: E501
        """create_smb_share  # noqa: E501

        Create a new share.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_smb_share(smb_share, async=True)
        >>> result = thread.get()

        :param async bool
        :param SmbShareCreateParams smb_share: (required)
        :param str zone: Zone which contains this share.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_smb_share_with_http_info(smb_share, **kwargs)  # noqa: E501
        else:
            (data) = self.create_smb_share_with_http_info(smb_share, **kwargs)  # noqa: E501
            return data

    def create_smb_share_with_http_info(self, smb_share, **kwargs):  # noqa: E501
        """create_smb_share  # noqa: E501

        Create a new share.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_smb_share_with_http_info(smb_share, async=True)
        >>> result = thread.get()

        :param async bool
        :param SmbShareCreateParams smb_share: (required)
        :param str zone: Zone which contains this share.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_share', 'zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_smb_share" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_share' is set
        if ('smb_share' not in params or
                params['smb_share'] is None):
            raise ValueError("Missing the required parameter `smb_share` when calling `create_smb_share`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smb_share' in params:
            body_params = params['smb_share']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/shares', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_hdfs_proxyuser(self, hdfs_proxyuser_id, **kwargs):  # noqa: E501
        """delete_hdfs_proxyuser  # noqa: E501

        Delete a a HDFS proxyuser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_hdfs_proxyuser(hdfs_proxyuser_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str hdfs_proxyuser_id: Delete a a HDFS proxyuser. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_hdfs_proxyuser_with_http_info(hdfs_proxyuser_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_hdfs_proxyuser_with_http_info(hdfs_proxyuser_id, **kwargs)  # noqa: E501
            return data

    def delete_hdfs_proxyuser_with_http_info(self, hdfs_proxyuser_id, **kwargs):  # noqa: E501
        """delete_hdfs_proxyuser  # noqa: E501

        Delete a a HDFS proxyuser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_hdfs_proxyuser_with_http_info(hdfs_proxyuser_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str hdfs_proxyuser_id: Delete a a HDFS proxyuser. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_proxyuser_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_hdfs_proxyuser" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_proxyuser_id' is set
        if ('hdfs_proxyuser_id' not in params or
                params['hdfs_proxyuser_id'] is None):
            raise ValueError("Missing the required parameter `hdfs_proxyuser_id` when calling `delete_hdfs_proxyuser`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hdfs_proxyuser_id' in params:
            path_params['HdfsProxyuserId'] = params['hdfs_proxyuser_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/proxyusers/{HdfsProxyuserId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_hdfs_rack(self, hdfs_rack_id, **kwargs):  # noqa: E501
        """delete_hdfs_rack  # noqa: E501

        Delete the HDFS rack.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_hdfs_rack(hdfs_rack_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str hdfs_rack_id: Delete the HDFS rack. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_hdfs_rack_with_http_info(hdfs_rack_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_hdfs_rack_with_http_info(hdfs_rack_id, **kwargs)  # noqa: E501
            return data

    def delete_hdfs_rack_with_http_info(self, hdfs_rack_id, **kwargs):  # noqa: E501
        """delete_hdfs_rack  # noqa: E501

        Delete the HDFS rack.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_hdfs_rack_with_http_info(hdfs_rack_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str hdfs_rack_id: Delete the HDFS rack. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_rack_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_hdfs_rack" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_rack_id' is set
        if ('hdfs_rack_id' not in params or
                params['hdfs_rack_id'] is None):
            raise ValueError("Missing the required parameter `hdfs_rack_id` when calling `delete_hdfs_rack`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hdfs_rack_id' in params:
            path_params['HdfsRackId'] = params['hdfs_rack_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/racks/{HdfsRackId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_nfs_alias(self, nfs_alias_id, **kwargs):  # noqa: E501
        """delete_nfs_alias  # noqa: E501

        Delete the export.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_nfs_alias(nfs_alias_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str nfs_alias_id: Delete the export. (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_nfs_alias_with_http_info(nfs_alias_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_nfs_alias_with_http_info(nfs_alias_id, **kwargs)  # noqa: E501
            return data

    def delete_nfs_alias_with_http_info(self, nfs_alias_id, **kwargs):  # noqa: E501
        """delete_nfs_alias  # noqa: E501

        Delete the export.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_nfs_alias_with_http_info(nfs_alias_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str nfs_alias_id: Delete the export. (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_alias_id', 'zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_nfs_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_alias_id' is set
        if ('nfs_alias_id' not in params or
                params['nfs_alias_id'] is None):
            raise ValueError("Missing the required parameter `nfs_alias_id` when calling `delete_nfs_alias`")  # noqa: E501

        if 'nfs_alias_id' in params:
            # tag this parameter so that it can be url encoded with quote_plus
            # by the api_client code because it contains a '/' character that
            # needs to be url encoded.
            params['nfs_alias_id'] = "__x-isi-url-encode-path-param__{0}".format(params['nfs_alias_id'])
        collection_formats = {}

        path_params = {}
        if 'nfs_alias_id' in params:
            path_params['NfsAliasId'] = params['nfs_alias_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/aliases/{NfsAliasId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_nfs_export(self, nfs_export_id, **kwargs):  # noqa: E501
        """delete_nfs_export  # noqa: E501

        Delete the export.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_nfs_export(nfs_export_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str nfs_export_id: Delete the export. (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_nfs_export_with_http_info(nfs_export_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_nfs_export_with_http_info(nfs_export_id, **kwargs)  # noqa: E501
            return data

    def delete_nfs_export_with_http_info(self, nfs_export_id, **kwargs):  # noqa: E501
        """delete_nfs_export  # noqa: E501

        Delete the export.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_nfs_export_with_http_info(nfs_export_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str nfs_export_id: Delete the export. (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_export_id', 'zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_nfs_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_export_id' is set
        if ('nfs_export_id' not in params or
                params['nfs_export_id'] is None):
            raise ValueError("Missing the required parameter `nfs_export_id` when calling `delete_nfs_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nfs_export_id' in params:
            path_params['NfsExportId'] = params['nfs_export_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/exports/{NfsExportId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_nfs_nlm_session(self, nfs_nlm_session_id, **kwargs):  # noqa: E501
        """delete_nfs_nlm_session  # noqa: E501

        Delete an NLM session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_nfs_nlm_session(nfs_nlm_session_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str nfs_nlm_session_id: Delete an NLM session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_nfs_nlm_session_with_http_info(nfs_nlm_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_nfs_nlm_session_with_http_info(nfs_nlm_session_id, **kwargs)  # noqa: E501
            return data

    def delete_nfs_nlm_session_with_http_info(self, nfs_nlm_session_id, **kwargs):  # noqa: E501
        """delete_nfs_nlm_session  # noqa: E501

        Delete an NLM session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_nfs_nlm_session_with_http_info(nfs_nlm_session_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str nfs_nlm_session_id: Delete an NLM session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_nlm_session_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_nfs_nlm_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_nlm_session_id' is set
        if ('nfs_nlm_session_id' not in params or
                params['nfs_nlm_session_id'] is None):
            raise ValueError("Missing the required parameter `nfs_nlm_session_id` when calling `delete_nfs_nlm_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nfs_nlm_session_id' in params:
            path_params['NfsNlmSessionId'] = params['nfs_nlm_session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/nlm/sessions/{NfsNlmSessionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_smb_openfile(self, smb_openfile_id, **kwargs):  # noqa: E501
        """delete_smb_openfile  # noqa: E501

        Close the file in the SMB server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_smb_openfile(smb_openfile_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str smb_openfile_id: Close the file in the SMB server. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_smb_openfile_with_http_info(smb_openfile_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_smb_openfile_with_http_info(smb_openfile_id, **kwargs)  # noqa: E501
            return data

    def delete_smb_openfile_with_http_info(self, smb_openfile_id, **kwargs):  # noqa: E501
        """delete_smb_openfile  # noqa: E501

        Close the file in the SMB server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_smb_openfile_with_http_info(smb_openfile_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str smb_openfile_id: Close the file in the SMB server. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_openfile_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_smb_openfile" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_openfile_id' is set
        if ('smb_openfile_id' not in params or
                params['smb_openfile_id'] is None):
            raise ValueError("Missing the required parameter `smb_openfile_id` when calling `delete_smb_openfile`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'smb_openfile_id' in params:
            path_params['SmbOpenfileId'] = params['smb_openfile_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/openfiles/{SmbOpenfileId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_smb_session(self, smb_session_id, **kwargs):  # noqa: E501
        """delete_smb_session  # noqa: E501

        Close the SMB session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_smb_session(smb_session_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str smb_session_id: Close the SMB session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_smb_session_with_http_info(smb_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_smb_session_with_http_info(smb_session_id, **kwargs)  # noqa: E501
            return data

    def delete_smb_session_with_http_info(self, smb_session_id, **kwargs):  # noqa: E501
        """delete_smb_session  # noqa: E501

        Close the SMB session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_smb_session_with_http_info(smb_session_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str smb_session_id: Close the SMB session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_session_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_smb_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_session_id' is set
        if ('smb_session_id' not in params or
                params['smb_session_id'] is None):
            raise ValueError("Missing the required parameter `smb_session_id` when calling `delete_smb_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'smb_session_id' in params:
            path_params['SmbSessionId'] = params['smb_session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/sessions/{SmbSessionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_smb_sessions_computer_user(self, smb_sessions_computer_user, computer, **kwargs):  # noqa: E501
        """delete_smb_sessions_computer_user  # noqa: E501

        Close the SMB session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_smb_sessions_computer_user(smb_sessions_computer_user, computer, async=True)
        >>> result = thread.get()

        :param async bool
        :param str smb_sessions_computer_user: Close the SMB session. (required)
        :param str computer: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_smb_sessions_computer_user_with_http_info(smb_sessions_computer_user, computer, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_smb_sessions_computer_user_with_http_info(smb_sessions_computer_user, computer, **kwargs)  # noqa: E501
            return data

    def delete_smb_sessions_computer_user_with_http_info(self, smb_sessions_computer_user, computer, **kwargs):  # noqa: E501
        """delete_smb_sessions_computer_user  # noqa: E501

        Close the SMB session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_smb_sessions_computer_user_with_http_info(smb_sessions_computer_user, computer, async=True)
        >>> result = thread.get()

        :param async bool
        :param str smb_sessions_computer_user: Close the SMB session. (required)
        :param str computer: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_sessions_computer_user', 'computer']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_smb_sessions_computer_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_sessions_computer_user' is set
        if ('smb_sessions_computer_user' not in params or
                params['smb_sessions_computer_user'] is None):
            raise ValueError("Missing the required parameter `smb_sessions_computer_user` when calling `delete_smb_sessions_computer_user`")  # noqa: E501
        # verify the required parameter 'computer' is set
        if ('computer' not in params or
                params['computer'] is None):
            raise ValueError("Missing the required parameter `computer` when calling `delete_smb_sessions_computer_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'smb_sessions_computer_user' in params:
            path_params['SmbSessionsComputerUser'] = params['smb_sessions_computer_user']  # noqa: E501
        if 'computer' in params:
            path_params['Computer'] = params['computer']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/sessions/{Computer}/{SmbSessionsComputerUser}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_smb_share(self, smb_share_id, **kwargs):  # noqa: E501
        """delete_smb_share  # noqa: E501

        Delete the share.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_smb_share(smb_share_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str smb_share_id: Delete the share. (required)
        :param str zone: Zone which contains this share.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_smb_share_with_http_info(smb_share_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_smb_share_with_http_info(smb_share_id, **kwargs)  # noqa: E501
            return data

    def delete_smb_share_with_http_info(self, smb_share_id, **kwargs):  # noqa: E501
        """delete_smb_share  # noqa: E501

        Delete the share.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_smb_share_with_http_info(smb_share_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str smb_share_id: Delete the share. (required)
        :param str zone: Zone which contains this share.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_share_id', 'zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_smb_share" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_share_id' is set
        if ('smb_share_id' not in params or
                params['smb_share_id'] is None):
            raise ValueError("Missing the required parameter `smb_share_id` when calling `delete_smb_share`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'smb_share_id' in params:
            path_params['SmbShareId'] = params['smb_share_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/shares/{SmbShareId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_smb_shares(self, **kwargs):  # noqa: E501
        """delete_smb_shares  # noqa: E501

        Delete multiple smb shares.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_smb_shares(async=True)
        >>> result = thread.get()

        :param async bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_smb_shares_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_smb_shares_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_smb_shares_with_http_info(self, **kwargs):  # noqa: E501
        """delete_smb_shares  # noqa: E501

        Delete multiple smb shares.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_smb_shares_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_smb_shares" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/shares', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hdfs_proxyuser(self, hdfs_proxyuser_id, **kwargs):  # noqa: E501
        """get_hdfs_proxyuser  # noqa: E501

        List all proxyusers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_hdfs_proxyuser(hdfs_proxyuser_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str hdfs_proxyuser_id: List all proxyusers. (required)
        :return: HdfsProxyusers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_hdfs_proxyuser_with_http_info(hdfs_proxyuser_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_hdfs_proxyuser_with_http_info(hdfs_proxyuser_id, **kwargs)  # noqa: E501
            return data

    def get_hdfs_proxyuser_with_http_info(self, hdfs_proxyuser_id, **kwargs):  # noqa: E501
        """get_hdfs_proxyuser  # noqa: E501

        List all proxyusers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_hdfs_proxyuser_with_http_info(hdfs_proxyuser_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str hdfs_proxyuser_id: List all proxyusers. (required)
        :return: HdfsProxyusers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_proxyuser_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_proxyuser" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_proxyuser_id' is set
        if ('hdfs_proxyuser_id' not in params or
                params['hdfs_proxyuser_id'] is None):
            raise ValueError("Missing the required parameter `hdfs_proxyuser_id` when calling `get_hdfs_proxyuser`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hdfs_proxyuser_id' in params:
            path_params['HdfsProxyuserId'] = params['hdfs_proxyuser_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/proxyusers/{HdfsProxyuserId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsProxyusers',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hdfs_rack(self, hdfs_rack_id, **kwargs):  # noqa: E501
        """get_hdfs_rack  # noqa: E501

        Retrieve the HDFS rack.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_hdfs_rack(hdfs_rack_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str hdfs_rack_id: Retrieve the HDFS rack. (required)
        :return: HdfsRacks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_hdfs_rack_with_http_info(hdfs_rack_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_hdfs_rack_with_http_info(hdfs_rack_id, **kwargs)  # noqa: E501
            return data

    def get_hdfs_rack_with_http_info(self, hdfs_rack_id, **kwargs):  # noqa: E501
        """get_hdfs_rack  # noqa: E501

        Retrieve the HDFS rack.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_hdfs_rack_with_http_info(hdfs_rack_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str hdfs_rack_id: Retrieve the HDFS rack. (required)
        :return: HdfsRacks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_rack_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_rack" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_rack_id' is set
        if ('hdfs_rack_id' not in params or
                params['hdfs_rack_id'] is None):
            raise ValueError("Missing the required parameter `hdfs_rack_id` when calling `get_hdfs_rack`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hdfs_rack_id' in params:
            path_params['HdfsRackId'] = params['hdfs_rack_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/racks/{HdfsRackId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsRacks',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hdfs_settings(self, **kwargs):  # noqa: E501
        """get_hdfs_settings  # noqa: E501

        Retrieve HDFS properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_hdfs_settings(async=True)
        >>> result = thread.get()

        :param async bool
        :return: HdfsSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_hdfs_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_hdfs_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_hdfs_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_hdfs_settings  # noqa: E501

        Retrieve HDFS properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_hdfs_settings_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: HdfsSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsSettings',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_alias(self, nfs_alias_id, **kwargs):  # noqa: E501
        """get_nfs_alias  # noqa: E501

        Retrieve export information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_alias(nfs_alias_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str nfs_alias_id: Retrieve export information. (required)
        :param str scope: If specified as effective or not specified, all export fields are shown.  If specified as user, only fields with non-default values are shown.
        :param str zone: Access zone
        :return: NfsAliases
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_nfs_alias_with_http_info(nfs_alias_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_alias_with_http_info(nfs_alias_id, **kwargs)  # noqa: E501
            return data

    def get_nfs_alias_with_http_info(self, nfs_alias_id, **kwargs):  # noqa: E501
        """get_nfs_alias  # noqa: E501

        Retrieve export information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_alias_with_http_info(nfs_alias_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str nfs_alias_id: Retrieve export information. (required)
        :param str scope: If specified as effective or not specified, all export fields are shown.  If specified as user, only fields with non-default values are shown.
        :param str zone: Access zone
        :return: NfsAliases
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_alias_id', 'scope', 'zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_alias_id' is set
        if ('nfs_alias_id' not in params or
                params['nfs_alias_id'] is None):
            raise ValueError("Missing the required parameter `nfs_alias_id` when calling `get_nfs_alias`")  # noqa: E501

        if 'nfs_alias_id' in params:
            # tag this parameter so that it can be url encoded with quote_plus
            # by the api_client code because it contains a '/' character that
            # needs to be url encoded.
            params['nfs_alias_id'] = "__x-isi-url-encode-path-param__{0}".format(params['nfs_alias_id'])
        collection_formats = {}

        path_params = {}
        if 'nfs_alias_id' in params:
            path_params['NfsAliasId'] = params['nfs_alias_id']  # noqa: E501

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/aliases/{NfsAliasId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsAliases',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_check(self, **kwargs):  # noqa: E501
        """get_nfs_check  # noqa: E501

        Retrieve NFS export validation information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_check(async=True)
        >>> result = thread.get()

        :param async bool
        :param str zone: Access zone
        :return: NfsCheckExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_nfs_check_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_check_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_check_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_check  # noqa: E501

        Retrieve NFS export validation information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_check_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str zone: Access zone
        :return: NfsCheckExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_check" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/check', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsCheckExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_export(self, nfs_export_id, **kwargs):  # noqa: E501
        """get_nfs_export  # noqa: E501

        Retrieve export information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_export(nfs_export_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str nfs_export_id: Retrieve export information. (required)
        :param str scope: If specified as effective or not specified, all export fields are shown.  If specified as user, only fields with non-default values are shown.
        :param str zone: Access zone
        :return: NfsExports
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_nfs_export_with_http_info(nfs_export_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_export_with_http_info(nfs_export_id, **kwargs)  # noqa: E501
            return data

    def get_nfs_export_with_http_info(self, nfs_export_id, **kwargs):  # noqa: E501
        """get_nfs_export  # noqa: E501

        Retrieve export information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_export_with_http_info(nfs_export_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str nfs_export_id: Retrieve export information. (required)
        :param str scope: If specified as effective or not specified, all export fields are shown.  If specified as user, only fields with non-default values are shown.
        :param str zone: Access zone
        :return: NfsExports
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_export_id', 'scope', 'zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_export_id' is set
        if ('nfs_export_id' not in params or
                params['nfs_export_id'] is None):
            raise ValueError("Missing the required parameter `nfs_export_id` when calling `get_nfs_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nfs_export_id' in params:
            path_params['NfsExportId'] = params['nfs_export_id']  # noqa: E501

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/exports/{NfsExportId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsExports',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_exports_summary(self, **kwargs):  # noqa: E501
        """get_nfs_exports_summary  # noqa: E501

        Retrieve NFS export summary information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_exports_summary(async=True)
        >>> result = thread.get()

        :param async bool
        :param str zone: Access zone
        :return: NfsExportsSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_nfs_exports_summary_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_exports_summary_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_exports_summary_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_exports_summary  # noqa: E501

        Retrieve NFS export summary information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_exports_summary_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str zone: Access zone
        :return: NfsExportsSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_exports_summary" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/exports-summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsExportsSummary',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_nlm_locks(self, **kwargs):  # noqa: E501
        """get_nfs_nlm_locks  # noqa: E501

        List all NLM locks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_nlm_locks(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NfsNlmLocks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_nfs_nlm_locks_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_nlm_locks_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_nlm_locks_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_nlm_locks  # noqa: E501

        List all NLM locks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_nlm_locks_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NfsNlmLocks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_nlm_locks" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_nfs_nlm_locks`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/nlm/locks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsNlmLocks',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_nlm_sessions(self, **kwargs):  # noqa: E501
        """get_nfs_nlm_sessions  # noqa: E501

        List all NLM sessions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_nlm_sessions(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NfsNlmSessions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_nfs_nlm_sessions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_nlm_sessions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_nlm_sessions_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_nlm_sessions  # noqa: E501

        List all NLM sessions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_nlm_sessions_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NfsNlmSessions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_nlm_sessions" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_nfs_nlm_sessions`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/nlm/sessions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsNlmSessions',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_nlm_waiters(self, **kwargs):  # noqa: E501
        """get_nfs_nlm_waiters  # noqa: E501

        List all NLM lock waiters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_nlm_waiters(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NfsNlmWaiters
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_nfs_nlm_waiters_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_nlm_waiters_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_nlm_waiters_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_nlm_waiters  # noqa: E501

        List all NLM lock waiters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_nlm_waiters_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NfsNlmWaiters
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_nlm_waiters" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_nfs_nlm_waiters`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/nlm/waiters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsNlmWaiters',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_settings_export(self, **kwargs):  # noqa: E501
        """get_nfs_settings_export  # noqa: E501

        Retrieve export information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_settings_export(async=True)
        >>> result = thread.get()

        :param async bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str zone: Access zone
        :return: NfsSettingsExport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_nfs_settings_export_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_settings_export_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_settings_export_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_settings_export  # noqa: E501

        Retrieve export information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_settings_export_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str zone: Access zone
        :return: NfsSettingsExport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope', 'zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_settings_export" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/settings/export', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsSettingsExport',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_settings_global(self, **kwargs):  # noqa: E501
        """get_nfs_settings_global  # noqa: E501

        Retrieve the NFS configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_settings_global(async=True)
        >>> result = thread.get()

        :param async bool
        :return: NfsSettingsGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_nfs_settings_global_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_settings_global_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_settings_global_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_settings_global  # noqa: E501

        Retrieve the NFS configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_settings_global_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: NfsSettingsGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_settings_global" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/settings/global', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsSettingsGlobal',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_settings_zone(self, **kwargs):  # noqa: E501
        """get_nfs_settings_zone  # noqa: E501

        Retrieve the NFS server settings for this zone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_settings_zone(async=True)
        >>> result = thread.get()

        :param async bool
        :return: NfsSettingsZone
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_nfs_settings_zone_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_settings_zone_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_settings_zone_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_settings_zone  # noqa: E501

        Retrieve the NFS server settings for this zone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_nfs_settings_zone_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: NfsSettingsZone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_settings_zone" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/settings/zone', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsSettingsZone',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smb_openfiles(self, **kwargs):  # noqa: E501
        """get_smb_openfiles  # noqa: E501

        List open files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_smb_openfiles(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: Order results by this field. Default is id.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SmbOpenfiles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_smb_openfiles_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_smb_openfiles_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_smb_openfiles_with_http_info(self, **kwargs):  # noqa: E501
        """get_smb_openfiles  # noqa: E501

        List open files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_smb_openfiles_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: Order results by this field. Default is id.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SmbOpenfiles
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smb_openfiles" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_smb_openfiles`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/openfiles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbOpenfiles',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smb_sessions(self, **kwargs):  # noqa: E501
        """get_smb_sessions  # noqa: E501

        List open sessions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_smb_sessions(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: Order results by this field.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SmbSessions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_smb_sessions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_smb_sessions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_smb_sessions_with_http_info(self, **kwargs):  # noqa: E501
        """get_smb_sessions  # noqa: E501

        List open sessions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_smb_sessions_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: Order results by this field.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SmbSessions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smb_sessions" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_smb_sessions`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/sessions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbSessions',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smb_settings_global(self, **kwargs):  # noqa: E501
        """get_smb_settings_global  # noqa: E501

        List all settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_smb_settings_global(async=True)
        >>> result = thread.get()

        :param async bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: SmbSettingsGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_smb_settings_global_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_smb_settings_global_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_smb_settings_global_with_http_info(self, **kwargs):  # noqa: E501
        """get_smb_settings_global  # noqa: E501

        List all settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_smb_settings_global_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: SmbSettingsGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smb_settings_global" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/settings/global', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbSettingsGlobal',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smb_settings_share(self, **kwargs):  # noqa: E501
        """get_smb_settings_share  # noqa: E501

        List all settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_smb_settings_share(async=True)
        >>> result = thread.get()

        :param async bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str zone: Zone which contains these share settings.
        :return: SmbSettingsShare
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_smb_settings_share_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_smb_settings_share_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_smb_settings_share_with_http_info(self, **kwargs):  # noqa: E501
        """get_smb_settings_share  # noqa: E501

        List all settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_smb_settings_share_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str zone: Zone which contains these share settings.
        :return: SmbSettingsShare
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope', 'zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smb_settings_share" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/settings/share', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbSettingsShare',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smb_share(self, smb_share_id, **kwargs):  # noqa: E501
        """get_smb_share  # noqa: E501

        Retrieve share.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_smb_share(smb_share_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str smb_share_id: Retrieve share. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param bool resolve_names: If true, resolve group and user names in personas.
        :param str zone: Zone which contains this share.
        :return: SmbShares
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_smb_share_with_http_info(smb_share_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_smb_share_with_http_info(smb_share_id, **kwargs)  # noqa: E501
            return data

    def get_smb_share_with_http_info(self, smb_share_id, **kwargs):  # noqa: E501
        """get_smb_share  # noqa: E501

        Retrieve share.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_smb_share_with_http_info(smb_share_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str smb_share_id: Retrieve share. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param bool resolve_names: If true, resolve group and user names in personas.
        :param str zone: Zone which contains this share.
        :return: SmbShares
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_share_id', 'scope', 'resolve_names', 'zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smb_share" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_share_id' is set
        if ('smb_share_id' not in params or
                params['smb_share_id'] is None):
            raise ValueError("Missing the required parameter `smb_share_id` when calling `get_smb_share`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'smb_share_id' in params:
            path_params['SmbShareId'] = params['smb_share_id']  # noqa: E501

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'resolve_names' in params:
            query_params.append(('resolve_names', params['resolve_names']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/shares/{SmbShareId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbShares',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smb_shares_summary(self, **kwargs):  # noqa: E501
        """get_smb_shares_summary  # noqa: E501

        Return summary information about shares.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_smb_shares_summary(async=True)
        >>> result = thread.get()

        :param async bool
        :return: SmbSharesSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_smb_shares_summary_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_smb_shares_summary_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_smb_shares_summary_with_http_info(self, **kwargs):  # noqa: E501
        """get_smb_shares_summary  # noqa: E501

        Return summary information about shares.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_smb_shares_summary_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: SmbSharesSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smb_shares_summary" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/shares-summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbSharesSummary',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_hdfs_proxyusers(self, **kwargs):  # noqa: E501
        """list_hdfs_proxyusers  # noqa: E501

        List all proxyusers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_hdfs_proxyusers(async=True)
        >>> result = thread.get()

        :param async bool
        :return: HdfsProxyusers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_hdfs_proxyusers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_hdfs_proxyusers_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_hdfs_proxyusers_with_http_info(self, **kwargs):  # noqa: E501
        """list_hdfs_proxyusers  # noqa: E501

        List all proxyusers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_hdfs_proxyusers_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: HdfsProxyusers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_hdfs_proxyusers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/proxyusers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsProxyusers',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_hdfs_racks(self, **kwargs):  # noqa: E501
        """list_hdfs_racks  # noqa: E501

        List all racks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_hdfs_racks(async=True)
        >>> result = thread.get()

        :param async bool
        :return: HdfsRacksExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_hdfs_racks_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_hdfs_racks_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_hdfs_racks_with_http_info(self, **kwargs):  # noqa: E501
        """list_hdfs_racks  # noqa: E501

        List all racks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_hdfs_racks_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: HdfsRacksExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_hdfs_racks" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/racks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsRacksExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_nfs_aliases(self, **kwargs):  # noqa: E501
        """list_nfs_aliases  # noqa: E501

        List all NFS aliases.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_nfs_aliases(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str zone: Access zone
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int limit: Return no more than this many results at once (see resume).
        :param bool check: Check for conflicts when listing exports.
        :param str dir: The direction of the sort.
        :return: NfsAliasesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_nfs_aliases_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_nfs_aliases_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_nfs_aliases_with_http_info(self, **kwargs):  # noqa: E501
        """list_nfs_aliases  # noqa: E501

        List all NFS aliases.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_nfs_aliases_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str zone: Access zone
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int limit: Return no more than this many results at once (see resume).
        :param bool check: Check for conflicts when listing exports.
        :param str dir: The direction of the sort.
        :return: NfsAliasesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'zone', 'resume', 'limit', 'check', 'dir']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_nfs_aliases" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_nfs_aliases`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'check' in params:
            query_params.append(('check', params['check']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/aliases', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsAliasesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_nfs_exports(self, **kwargs):  # noqa: E501
        """list_nfs_exports  # noqa: E501

        List all NFS exports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_nfs_exports(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str zone: Access zone
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int limit: Return no more than this many results at once (see resume).
        :param str scope: If specified as effective or not specified, all export fields are shown.  If specified as user, only fields with non-default values are shown.
        :param bool check: Check for conflicts when listing exports.
        :param str dir: The direction of the sort.
        :return: NfsExportsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_nfs_exports_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_nfs_exports_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_nfs_exports_with_http_info(self, **kwargs):  # noqa: E501
        """list_nfs_exports  # noqa: E501

        List all NFS exports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_nfs_exports_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param str zone: Access zone
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int limit: Return no more than this many results at once (see resume).
        :param str scope: If specified as effective or not specified, all export fields are shown.  If specified as user, only fields with non-default values are shown.
        :param bool check: Check for conflicts when listing exports.
        :param str dir: The direction of the sort.
        :return: NfsExportsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'zone', 'resume', 'limit', 'scope', 'check', 'dir']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_nfs_exports" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_nfs_exports`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'check' in params:
            query_params.append(('check', params['check']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/exports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsExportsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_smb_shares(self, **kwargs):  # noqa: E501
        """list_smb_shares  # noqa: E501

        List all shares.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_smb_shares(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: Order results by this field. Default is id.
        :param str zone: Zone which contains this share.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool resolve_names: If true, resolve group and user names in personas.
        :param int limit: Return no more than this many results at once (see resume).
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str dir: The direction of the sort.
        :return: SmbSharesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_smb_shares_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_smb_shares_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_smb_shares_with_http_info(self, **kwargs):  # noqa: E501
        """list_smb_shares  # noqa: E501

        List all shares.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_smb_shares_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: Order results by this field. Default is id.
        :param str zone: Zone which contains this share.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool resolve_names: If true, resolve group and user names in personas.
        :param int limit: Return no more than this many results at once (see resume).
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str dir: The direction of the sort.
        :return: SmbSharesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'zone', 'resume', 'resolve_names', 'limit', 'scope', 'dir']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_smb_shares" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_smb_shares`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'resolve_names' in params:
            query_params.append(('resolve_names', params['resolve_names']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/shares', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbSharesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_hdfs_proxyuser(self, hdfs_proxyuser, hdfs_proxyuser_id, **kwargs):  # noqa: E501
        """update_hdfs_proxyuser  # noqa: E501

        Create a new HDFS proxyuser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_hdfs_proxyuser(hdfs_proxyuser, hdfs_proxyuser_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param Empty hdfs_proxyuser: (required)
        :param str hdfs_proxyuser_id: Create a new HDFS proxyuser. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_hdfs_proxyuser_with_http_info(hdfs_proxyuser, hdfs_proxyuser_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_hdfs_proxyuser_with_http_info(hdfs_proxyuser, hdfs_proxyuser_id, **kwargs)  # noqa: E501
            return data

    def update_hdfs_proxyuser_with_http_info(self, hdfs_proxyuser, hdfs_proxyuser_id, **kwargs):  # noqa: E501
        """update_hdfs_proxyuser  # noqa: E501

        Create a new HDFS proxyuser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_hdfs_proxyuser_with_http_info(hdfs_proxyuser, hdfs_proxyuser_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param Empty hdfs_proxyuser: (required)
        :param str hdfs_proxyuser_id: Create a new HDFS proxyuser. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_proxyuser', 'hdfs_proxyuser_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hdfs_proxyuser" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_proxyuser' is set
        if ('hdfs_proxyuser' not in params or
                params['hdfs_proxyuser'] is None):
            raise ValueError("Missing the required parameter `hdfs_proxyuser` when calling `update_hdfs_proxyuser`")  # noqa: E501
        # verify the required parameter 'hdfs_proxyuser_id' is set
        if ('hdfs_proxyuser_id' not in params or
                params['hdfs_proxyuser_id'] is None):
            raise ValueError("Missing the required parameter `hdfs_proxyuser_id` when calling `update_hdfs_proxyuser`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hdfs_proxyuser_id' in params:
            path_params['HdfsProxyuserId'] = params['hdfs_proxyuser_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_proxyuser' in params:
            body_params = params['hdfs_proxyuser']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/proxyusers/{HdfsProxyuserId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_hdfs_rack(self, hdfs_rack, hdfs_rack_id, **kwargs):  # noqa: E501
        """update_hdfs_rack  # noqa: E501

        Modify the HDFS rack  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_hdfs_rack(hdfs_rack, hdfs_rack_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param HdfsRack hdfs_rack: (required)
        :param str hdfs_rack_id: Modify the HDFS rack (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_hdfs_rack_with_http_info(hdfs_rack, hdfs_rack_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_hdfs_rack_with_http_info(hdfs_rack, hdfs_rack_id, **kwargs)  # noqa: E501
            return data

    def update_hdfs_rack_with_http_info(self, hdfs_rack, hdfs_rack_id, **kwargs):  # noqa: E501
        """update_hdfs_rack  # noqa: E501

        Modify the HDFS rack  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_hdfs_rack_with_http_info(hdfs_rack, hdfs_rack_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param HdfsRack hdfs_rack: (required)
        :param str hdfs_rack_id: Modify the HDFS rack (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_rack', 'hdfs_rack_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hdfs_rack" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_rack' is set
        if ('hdfs_rack' not in params or
                params['hdfs_rack'] is None):
            raise ValueError("Missing the required parameter `hdfs_rack` when calling `update_hdfs_rack`")  # noqa: E501
        # verify the required parameter 'hdfs_rack_id' is set
        if ('hdfs_rack_id' not in params or
                params['hdfs_rack_id'] is None):
            raise ValueError("Missing the required parameter `hdfs_rack_id` when calling `update_hdfs_rack`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hdfs_rack_id' in params:
            path_params['HdfsRackId'] = params['hdfs_rack_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_rack' in params:
            body_params = params['hdfs_rack']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/racks/{HdfsRackId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_hdfs_settings(self, hdfs_settings, **kwargs):  # noqa: E501
        """update_hdfs_settings  # noqa: E501

        Modify HDFS properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_hdfs_settings(hdfs_settings, async=True)
        >>> result = thread.get()

        :param async bool
        :param HdfsSettingsSettings hdfs_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_hdfs_settings_with_http_info(hdfs_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_hdfs_settings_with_http_info(hdfs_settings, **kwargs)  # noqa: E501
            return data

    def update_hdfs_settings_with_http_info(self, hdfs_settings, **kwargs):  # noqa: E501
        """update_hdfs_settings  # noqa: E501

        Modify HDFS properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_hdfs_settings_with_http_info(hdfs_settings, async=True)
        >>> result = thread.get()

        :param async bool
        :param HdfsSettingsSettings hdfs_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_settings']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hdfs_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_settings' is set
        if ('hdfs_settings' not in params or
                params['hdfs_settings'] is None):
            raise ValueError("Missing the required parameter `hdfs_settings` when calling `update_hdfs_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_settings' in params:
            body_params = params['hdfs_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_nfs_alias(self, nfs_alias, nfs_alias_id, **kwargs):  # noqa: E501
        """update_nfs_alias  # noqa: E501

        Modify the alias. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_nfs_alias(nfs_alias, nfs_alias_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param NfsAlias nfs_alias: (required)
        :param str nfs_alias_id: Modify the alias. All input fields are optional, but one or more must be supplied. (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_nfs_alias_with_http_info(nfs_alias, nfs_alias_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_nfs_alias_with_http_info(nfs_alias, nfs_alias_id, **kwargs)  # noqa: E501
            return data

    def update_nfs_alias_with_http_info(self, nfs_alias, nfs_alias_id, **kwargs):  # noqa: E501
        """update_nfs_alias  # noqa: E501

        Modify the alias. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_nfs_alias_with_http_info(nfs_alias, nfs_alias_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param NfsAlias nfs_alias: (required)
        :param str nfs_alias_id: Modify the alias. All input fields are optional, but one or more must be supplied. (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_alias', 'nfs_alias_id', 'zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_nfs_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_alias' is set
        if ('nfs_alias' not in params or
                params['nfs_alias'] is None):
            raise ValueError("Missing the required parameter `nfs_alias` when calling `update_nfs_alias`")  # noqa: E501
        # verify the required parameter 'nfs_alias_id' is set
        if ('nfs_alias_id' not in params or
                params['nfs_alias_id'] is None):
            raise ValueError("Missing the required parameter `nfs_alias_id` when calling `update_nfs_alias`")  # noqa: E501

        if 'nfs_alias_id' in params:
            # tag this parameter so that it can be url encoded with quote_plus
            # by the api_client code because it contains a '/' character that
            # needs to be url encoded.
            params['nfs_alias_id'] = "__x-isi-url-encode-path-param__{0}".format(params['nfs_alias_id'])
        collection_formats = {}

        path_params = {}
        if 'nfs_alias_id' in params:
            path_params['NfsAliasId'] = params['nfs_alias_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_alias' in params:
            body_params = params['nfs_alias']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/aliases/{NfsAliasId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_nfs_export(self, nfs_export, nfs_export_id, **kwargs):  # noqa: E501
        """update_nfs_export  # noqa: E501

        Modify the export. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_nfs_export(nfs_export, nfs_export_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param NfsExport nfs_export: (required)
        :param str nfs_export_id: Modify the export. All input fields are optional, but one or more must be supplied. (required)
        :param bool force: If true, the export will be updated even if that change conflicts with another export.
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_nfs_export_with_http_info(nfs_export, nfs_export_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_nfs_export_with_http_info(nfs_export, nfs_export_id, **kwargs)  # noqa: E501
            return data

    def update_nfs_export_with_http_info(self, nfs_export, nfs_export_id, **kwargs):  # noqa: E501
        """update_nfs_export  # noqa: E501

        Modify the export. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_nfs_export_with_http_info(nfs_export, nfs_export_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param NfsExport nfs_export: (required)
        :param str nfs_export_id: Modify the export. All input fields are optional, but one or more must be supplied. (required)
        :param bool force: If true, the export will be updated even if that change conflicts with another export.
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_export', 'nfs_export_id', 'force', 'zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_nfs_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_export' is set
        if ('nfs_export' not in params or
                params['nfs_export'] is None):
            raise ValueError("Missing the required parameter `nfs_export` when calling `update_nfs_export`")  # noqa: E501
        # verify the required parameter 'nfs_export_id' is set
        if ('nfs_export_id' not in params or
                params['nfs_export_id'] is None):
            raise ValueError("Missing the required parameter `nfs_export_id` when calling `update_nfs_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nfs_export_id' in params:
            path_params['NfsExportId'] = params['nfs_export_id']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_export' in params:
            body_params = params['nfs_export']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/exports/{NfsExportId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_nfs_settings_export(self, nfs_settings_export, **kwargs):  # noqa: E501
        """update_nfs_settings_export  # noqa: E501

        Modify the default values for NFS exports. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_nfs_settings_export(nfs_settings_export, async=True)
        >>> result = thread.get()

        :param async bool
        :param NfsSettingsExportSettings nfs_settings_export: (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_nfs_settings_export_with_http_info(nfs_settings_export, **kwargs)  # noqa: E501
        else:
            (data) = self.update_nfs_settings_export_with_http_info(nfs_settings_export, **kwargs)  # noqa: E501
            return data

    def update_nfs_settings_export_with_http_info(self, nfs_settings_export, **kwargs):  # noqa: E501
        """update_nfs_settings_export  # noqa: E501

        Modify the default values for NFS exports. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_nfs_settings_export_with_http_info(nfs_settings_export, async=True)
        >>> result = thread.get()

        :param async bool
        :param NfsSettingsExportSettings nfs_settings_export: (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_settings_export', 'zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_nfs_settings_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_settings_export' is set
        if ('nfs_settings_export' not in params or
                params['nfs_settings_export'] is None):
            raise ValueError("Missing the required parameter `nfs_settings_export` when calling `update_nfs_settings_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_settings_export' in params:
            body_params = params['nfs_settings_export']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/settings/export', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_nfs_settings_global(self, nfs_settings_global, **kwargs):  # noqa: E501
        """update_nfs_settings_global  # noqa: E501

        Modify the default values for NFS exports. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_nfs_settings_global(nfs_settings_global, async=True)
        >>> result = thread.get()

        :param async bool
        :param NfsSettingsGlobalSettings nfs_settings_global: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_nfs_settings_global_with_http_info(nfs_settings_global, **kwargs)  # noqa: E501
        else:
            (data) = self.update_nfs_settings_global_with_http_info(nfs_settings_global, **kwargs)  # noqa: E501
            return data

    def update_nfs_settings_global_with_http_info(self, nfs_settings_global, **kwargs):  # noqa: E501
        """update_nfs_settings_global  # noqa: E501

        Modify the default values for NFS exports. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_nfs_settings_global_with_http_info(nfs_settings_global, async=True)
        >>> result = thread.get()

        :param async bool
        :param NfsSettingsGlobalSettings nfs_settings_global: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_settings_global']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_nfs_settings_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_settings_global' is set
        if ('nfs_settings_global' not in params or
                params['nfs_settings_global'] is None):
            raise ValueError("Missing the required parameter `nfs_settings_global` when calling `update_nfs_settings_global`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_settings_global' in params:
            body_params = params['nfs_settings_global']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/settings/global', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_nfs_settings_zone(self, nfs_settings_zone, **kwargs):  # noqa: E501
        """update_nfs_settings_zone  # noqa: E501

        Modify the NFS server settings for this zone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_nfs_settings_zone(nfs_settings_zone, async=True)
        >>> result = thread.get()

        :param async bool
        :param NfsSettingsZoneSettings nfs_settings_zone: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_nfs_settings_zone_with_http_info(nfs_settings_zone, **kwargs)  # noqa: E501
        else:
            (data) = self.update_nfs_settings_zone_with_http_info(nfs_settings_zone, **kwargs)  # noqa: E501
            return data

    def update_nfs_settings_zone_with_http_info(self, nfs_settings_zone, **kwargs):  # noqa: E501
        """update_nfs_settings_zone  # noqa: E501

        Modify the NFS server settings for this zone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_nfs_settings_zone_with_http_info(nfs_settings_zone, async=True)
        >>> result = thread.get()

        :param async bool
        :param NfsSettingsZoneSettings nfs_settings_zone: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_settings_zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_nfs_settings_zone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_settings_zone' is set
        if ('nfs_settings_zone' not in params or
                params['nfs_settings_zone'] is None):
            raise ValueError("Missing the required parameter `nfs_settings_zone` when calling `update_nfs_settings_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_settings_zone' in params:
            body_params = params['nfs_settings_zone']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/settings/zone', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_smb_settings_global(self, smb_settings_global, **kwargs):  # noqa: E501
        """update_smb_settings_global  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_smb_settings_global(smb_settings_global, async=True)
        >>> result = thread.get()

        :param async bool
        :param SmbSettingsGlobalExtended smb_settings_global: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_smb_settings_global_with_http_info(smb_settings_global, **kwargs)  # noqa: E501
        else:
            (data) = self.update_smb_settings_global_with_http_info(smb_settings_global, **kwargs)  # noqa: E501
            return data

    def update_smb_settings_global_with_http_info(self, smb_settings_global, **kwargs):  # noqa: E501
        """update_smb_settings_global  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_smb_settings_global_with_http_info(smb_settings_global, async=True)
        >>> result = thread.get()

        :param async bool
        :param SmbSettingsGlobalExtended smb_settings_global: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_settings_global']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_smb_settings_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_settings_global' is set
        if ('smb_settings_global' not in params or
                params['smb_settings_global'] is None):
            raise ValueError("Missing the required parameter `smb_settings_global` when calling `update_smb_settings_global`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smb_settings_global' in params:
            body_params = params['smb_settings_global']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/settings/global', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_smb_settings_share(self, smb_settings_share, **kwargs):  # noqa: E501
        """update_smb_settings_share  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_smb_settings_share(smb_settings_share, async=True)
        >>> result = thread.get()

        :param async bool
        :param SmbSettingsShareExtended smb_settings_share: (required)
        :param str zone: Zone which contains these share settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_smb_settings_share_with_http_info(smb_settings_share, **kwargs)  # noqa: E501
        else:
            (data) = self.update_smb_settings_share_with_http_info(smb_settings_share, **kwargs)  # noqa: E501
            return data

    def update_smb_settings_share_with_http_info(self, smb_settings_share, **kwargs):  # noqa: E501
        """update_smb_settings_share  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_smb_settings_share_with_http_info(smb_settings_share, async=True)
        >>> result = thread.get()

        :param async bool
        :param SmbSettingsShareExtended smb_settings_share: (required)
        :param str zone: Zone which contains these share settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_settings_share', 'zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_smb_settings_share" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_settings_share' is set
        if ('smb_settings_share' not in params or
                params['smb_settings_share'] is None):
            raise ValueError("Missing the required parameter `smb_settings_share` when calling `update_smb_settings_share`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smb_settings_share' in params:
            body_params = params['smb_settings_share']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/settings/share', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_smb_share(self, smb_share, smb_share_id, **kwargs):  # noqa: E501
        """update_smb_share  # noqa: E501

        Modify share. All input fields are optional, but one or must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_smb_share(smb_share, smb_share_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param SmbShare smb_share: (required)
        :param str smb_share_id: Modify share. All input fields are optional, but one or must be supplied. (required)
        :param str zone: Zone which contains this share.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_smb_share_with_http_info(smb_share, smb_share_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_smb_share_with_http_info(smb_share, smb_share_id, **kwargs)  # noqa: E501
            return data

    def update_smb_share_with_http_info(self, smb_share, smb_share_id, **kwargs):  # noqa: E501
        """update_smb_share  # noqa: E501

        Modify share. All input fields are optional, but one or must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_smb_share_with_http_info(smb_share, smb_share_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param SmbShare smb_share: (required)
        :param str smb_share_id: Modify share. All input fields are optional, but one or must be supplied. (required)
        :param str zone: Zone which contains this share.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_share', 'smb_share_id', 'zone']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_smb_share" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_share' is set
        if ('smb_share' not in params or
                params['smb_share'] is None):
            raise ValueError("Missing the required parameter `smb_share` when calling `update_smb_share`")  # noqa: E501
        # verify the required parameter 'smb_share_id' is set
        if ('smb_share_id' not in params or
                params['smb_share_id'] is None):
            raise ValueError("Missing the required parameter `smb_share_id` when calling `update_smb_share`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'smb_share_id' in params:
            path_params['SmbShareId'] = params['smb_share_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smb_share' in params:
            body_params = params['smb_share']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/shares/{SmbShareId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
