# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 2
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isi_sdk_7_2.api_client import ApiClient


class EventApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_event_event(self, event_event_id, **kwargs):  # noqa: E501
        """get_event_event  # noqa: E501

        Retrieve event information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_event(event_event_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_event_id: Retrieve event information. (required)
        :return: EventEvents
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_event_event_with_http_info(event_event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_event_with_http_info(event_event_id, **kwargs)  # noqa: E501
            return data

    def get_event_event_with_http_info(self, event_event_id, **kwargs):  # noqa: E501
        """get_event_event  # noqa: E501

        Retrieve event information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_event_with_http_info(event_event_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str event_event_id: Retrieve event information. (required)
        :return: EventEvents
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_event_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_event_id' is set
        if ('event_event_id' not in params or
                params['event_event_id'] is None):
            raise ValueError("Missing the required parameter `event_event_id` when calling `get_event_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_event_id' in params:
            path_params['EventEventId'] = params['event_event_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/event/events/{EventEventId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventEvents',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_events(self, **kwargs):  # noqa: E501
        """get_event_events  # noqa: E501

        Retrieve event information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_events(async=True)
        >>> result = thread.get()

        :param async bool
        :param bool count: If true, return a count of events.
        :param str sort: The field that will be used for sorting.
        :param int begin: Specifies the earliest time to query events from.
        :param int end: Specifies the latest time to query events from.
        :param list[int] event_type: Specifies the event_id of events to query for.
        :param bool coalesced: If true, only return events that have been coalesced.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param list[str] devid: Specifies the devid of events to query for.
        :param bool acknowledged: If true, only return events that have been acknowledged.
        :param bool ended: If true, only return events that have ended.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param bool coalescing: If true, only return coalescing events.
        :param list[str] severity: Specifies the severity of events to query for.
        :return: EventEventsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_event_events_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_event_events_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_event_events_with_http_info(self, **kwargs):  # noqa: E501
        """get_event_events  # noqa: E501

        Retrieve event information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_event_events_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param bool count: If true, return a count of events.
        :param str sort: The field that will be used for sorting.
        :param int begin: Specifies the earliest time to query events from.
        :param int end: Specifies the latest time to query events from.
        :param list[int] event_type: Specifies the event_id of events to query for.
        :param bool coalesced: If true, only return events that have been coalesced.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param list[str] devid: Specifies the devid of events to query for.
        :param bool acknowledged: If true, only return events that have been acknowledged.
        :param bool ended: If true, only return events that have ended.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param bool coalescing: If true, only return coalescing events.
        :param list[str] severity: Specifies the severity of events to query for.
        :return: EventEventsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['count', 'sort', 'begin', 'end', 'event_type', 'coalesced', 'resume', 'devid', 'acknowledged', 'ended', 'limit', 'dir', 'coalescing', 'severity']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_events" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_event_events`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'count' in params:
            query_params.append(('count', params['count']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'event_type' in params:
            query_params.append(('event_type', params['event_type']))  # noqa: E501
            collection_formats['event_type'] = 'csv'  # noqa: E501
        if 'coalesced' in params:
            query_params.append(('coalesced', params['coalesced']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'devid' in params:
            query_params.append(('devid', params['devid']))  # noqa: E501
            collection_formats['devid'] = 'csv'  # noqa: E501
        if 'acknowledged' in params:
            query_params.append(('acknowledged', params['acknowledged']))  # noqa: E501
        if 'ended' in params:
            query_params.append(('ended', params['ended']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'coalescing' in params:
            query_params.append(('coalescing', params['coalescing']))  # noqa: E501
        if 'severity' in params:
            query_params.append(('severity', params['severity']))  # noqa: E501
            collection_formats['severity'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/event/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventEventsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
