"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynchronizationJob = exports.SynchronizationJobProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dts_generated_1 = require("./dts.generated");
Object.defineProperty(exports, "SynchronizationJobProperty", { enumerable: true, get: function () { return dts_generated_1.RosSynchronizationJob; } });
/**
 * A ROS resource type:  `ALIYUN::DTS::SynchronizationJob`
 */
class SynchronizationJob extends ros.Resource {
    /**
     * Create a new `ALIYUN::DTS::SynchronizationJob`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosSynchronizationJob = new dts_generated_1.RosSynchronizationJob(this, id, {
            synchronizationObjects: props.synchronizationObjects,
            period: props.period,
            payType: props.payType === undefined || props.payType === null ? 'Postpaid' : props.payType,
            topology: props.topology,
            sourceRegion: props.sourceRegion,
            dataInitialization: props.dataInitialization === undefined || props.dataInitialization === null ? true : props.dataInitialization,
            destinationEndpoint: props.destinationEndpoint,
            networkType: props.networkType,
            sourceEndpoint: props.sourceEndpoint,
            usedTime: props.usedTime,
            structureInitialization: props.structureInitialization === undefined || props.structureInitialization === null ? true : props.structureInitialization,
            synchronizationJobClass: props.synchronizationJobClass,
            destRegion: props.destRegion,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSynchronizationJob;
        this.attrSynchronizationJobId = rosSynchronizationJob.attrSynchronizationJobId;
    }
}
exports.SynchronizationJob = SynchronizationJob;
//# sourceMappingURL=data:application/json;base64,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