# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from flexprice.models.types_transaction_reason import TypesTransactionReason
from flexprice.models.types_transaction_status import TypesTransactionStatus
from flexprice.models.types_wallet_tx_reference_type import TypesWalletTxReferenceType
from typing import Optional, Set
from typing_extensions import Self

class DtoWalletTransactionResponse(BaseModel):
    """
    DtoWalletTransactionResponse
    """ # noqa: E501
    amount: Optional[Union[StrictFloat, StrictInt]] = None
    created_at: Optional[StrictStr] = None
    credit_amount: Optional[Union[StrictFloat, StrictInt]] = None
    credit_balance_after: Optional[Union[StrictFloat, StrictInt]] = None
    credit_balance_before: Optional[Union[StrictFloat, StrictInt]] = None
    credits_available: Optional[Union[StrictFloat, StrictInt]] = None
    description: Optional[StrictStr] = None
    expiry_date: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    metadata: Optional[Dict[str, StrictStr]] = None
    reference_id: Optional[StrictStr] = None
    reference_type: Optional[TypesWalletTxReferenceType] = None
    transaction_reason: Optional[TypesTransactionReason] = None
    transaction_status: Optional[TypesTransactionStatus] = None
    type: Optional[StrictStr] = None
    wallet_id: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["amount", "created_at", "credit_amount", "credit_balance_after", "credit_balance_before", "credits_available", "description", "expiry_date", "id", "metadata", "reference_id", "reference_type", "transaction_reason", "transaction_status", "type", "wallet_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoWalletTransactionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoWalletTransactionResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": obj.get("amount"),
            "created_at": obj.get("created_at"),
            "credit_amount": obj.get("credit_amount"),
            "credit_balance_after": obj.get("credit_balance_after"),
            "credit_balance_before": obj.get("credit_balance_before"),
            "credits_available": obj.get("credits_available"),
            "description": obj.get("description"),
            "expiry_date": obj.get("expiry_date"),
            "id": obj.get("id"),
            "metadata": obj.get("metadata"),
            "reference_id": obj.get("reference_id"),
            "reference_type": obj.get("reference_type"),
            "transaction_reason": obj.get("transaction_reason"),
            "transaction_status": obj.get("transaction_status"),
            "type": obj.get("type"),
            "wallet_id": obj.get("wallet_id")
        })
        return _obj


