# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from flexprice.models.types_auto_topup_trigger import TypesAutoTopupTrigger
from flexprice.models.types_wallet_config import TypesWalletConfig
from flexprice.models.types_wallet_status import TypesWalletStatus
from flexprice.models.types_wallet_type import TypesWalletType
from typing import Optional, Set
from typing_extensions import Self

class DtoWalletResponse(BaseModel):
    """
    DtoWalletResponse
    """ # noqa: E501
    auto_topup_amount: Optional[Union[StrictFloat, StrictInt]] = None
    auto_topup_min_balance: Optional[Union[StrictFloat, StrictInt]] = None
    auto_topup_trigger: Optional[TypesAutoTopupTrigger] = None
    balance: Optional[Union[StrictFloat, StrictInt]] = None
    config: Optional[TypesWalletConfig] = None
    conversion_rate: Optional[Union[StrictFloat, StrictInt]] = None
    created_at: Optional[StrictStr] = None
    credit_balance: Optional[Union[StrictFloat, StrictInt]] = None
    currency: Optional[StrictStr] = None
    customer_id: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    metadata: Optional[Dict[str, StrictStr]] = None
    name: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    wallet_status: Optional[TypesWalletStatus] = None
    wallet_type: Optional[TypesWalletType] = None
    __properties: ClassVar[List[str]] = ["auto_topup_amount", "auto_topup_min_balance", "auto_topup_trigger", "balance", "config", "conversion_rate", "created_at", "credit_balance", "currency", "customer_id", "description", "id", "metadata", "name", "updated_at", "wallet_status", "wallet_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoWalletResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoWalletResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "auto_topup_amount": obj.get("auto_topup_amount"),
            "auto_topup_min_balance": obj.get("auto_topup_min_balance"),
            "auto_topup_trigger": obj.get("auto_topup_trigger"),
            "balance": obj.get("balance"),
            "config": TypesWalletConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "conversion_rate": obj.get("conversion_rate"),
            "created_at": obj.get("created_at"),
            "credit_balance": obj.get("credit_balance"),
            "currency": obj.get("currency"),
            "customer_id": obj.get("customer_id"),
            "description": obj.get("description"),
            "id": obj.get("id"),
            "metadata": obj.get("metadata"),
            "name": obj.get("name"),
            "updated_at": obj.get("updated_at"),
            "wallet_status": obj.get("wallet_status"),
            "wallet_type": obj.get("wallet_type")
        })
        return _obj


