# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from flexprice.models.dto_create_price_tier import DtoCreatePriceTier
from flexprice.models.price_transform_quantity import PriceTransformQuantity
from flexprice.models.types_billing_cadence import TypesBillingCadence
from flexprice.models.types_billing_model import TypesBillingModel
from flexprice.models.types_billing_period import TypesBillingPeriod
from flexprice.models.types_billing_tier import TypesBillingTier
from flexprice.models.types_invoice_cadence import TypesInvoiceCadence
from flexprice.models.types_price_type import TypesPriceType
from typing import Optional, Set
from typing_extensions import Self

class DtoUpdatePlanPriceRequest(BaseModel):
    """
    DtoUpdatePlanPriceRequest
    """ # noqa: E501
    amount: Optional[StrictStr] = None
    billing_cadence: TypesBillingCadence
    billing_model: TypesBillingModel
    billing_period: TypesBillingPeriod
    billing_period_count: Annotated[int, Field(strict=True, ge=1)]
    currency: StrictStr
    description: Optional[StrictStr] = None
    filter_values: Optional[Dict[str, List[StrictStr]]] = None
    id: Optional[StrictStr] = Field(default=None, description="The ID of the price to update (present if the price is being updated)")
    invoice_cadence: TypesInvoiceCadence
    lookup_key: Optional[StrictStr] = None
    metadata: Optional[Dict[str, StrictStr]] = None
    meter_id: Optional[StrictStr] = None
    plan_id: Optional[StrictStr] = None
    tier_mode: Optional[TypesBillingTier] = None
    tiers: Optional[List[DtoCreatePriceTier]] = None
    transform_quantity: Optional[PriceTransformQuantity] = None
    trial_period: Optional[StrictInt] = None
    type: TypesPriceType
    __properties: ClassVar[List[str]] = ["amount", "billing_cadence", "billing_model", "billing_period", "billing_period_count", "currency", "description", "filter_values", "id", "invoice_cadence", "lookup_key", "metadata", "meter_id", "plan_id", "tier_mode", "tiers", "transform_quantity", "trial_period", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoUpdatePlanPriceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tiers (list)
        _items = []
        if self.tiers:
            for _item_tiers in self.tiers:
                if _item_tiers:
                    _items.append(_item_tiers.to_dict())
            _dict['tiers'] = _items
        # override the default output from pydantic by calling `to_dict()` of transform_quantity
        if self.transform_quantity:
            _dict['transform_quantity'] = self.transform_quantity.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoUpdatePlanPriceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": obj.get("amount"),
            "billing_cadence": obj.get("billing_cadence"),
            "billing_model": obj.get("billing_model"),
            "billing_period": obj.get("billing_period"),
            "billing_period_count": obj.get("billing_period_count"),
            "currency": obj.get("currency"),
            "description": obj.get("description"),
            "filter_values": obj.get("filter_values"),
            "id": obj.get("id"),
            "invoice_cadence": obj.get("invoice_cadence"),
            "lookup_key": obj.get("lookup_key"),
            "metadata": obj.get("metadata"),
            "meter_id": obj.get("meter_id"),
            "plan_id": obj.get("plan_id"),
            "tier_mode": obj.get("tier_mode"),
            "tiers": [DtoCreatePriceTier.from_dict(_item) for _item in obj["tiers"]] if obj.get("tiers") is not None else None,
            "transform_quantity": PriceTransformQuantity.from_dict(obj["transform_quantity"]) if obj.get("transform_quantity") is not None else None,
            "trial_period": obj.get("trial_period"),
            "type": obj.get("type")
        })
        return _obj


