# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class DtoTopUpWalletRequest(BaseModel):
    """
    DtoTopUpWalletRequest
    """ # noqa: E501
    amount: Union[StrictFloat, StrictInt] = Field(description="amount is the number of credits to add to the wallet")
    description: Optional[StrictStr] = Field(default=None, description="description to add any specific details about the transaction")
    expiry_date: Optional[StrictInt] = Field(default=None, description="expiry_date YYYYMMDD format in UTC timezone (optional to set nil means no expiry) for ex 20250101 means the credits will expire on 2025-01-01 00:00:00 UTC hence they will be available for use until 2024-12-31 23:59:59 UTC")
    generate_invoice: Optional[StrictBool] = Field(default=None, description="generate_invoice when true, an invoice will be generated for the transaction")
    metadata: Optional[Dict[str, StrictStr]] = None
    purchased_credits: Optional[StrictBool] = Field(default=None, description="purchased_credits when true, the credits are added as purchased credits")
    reference_id: Optional[StrictStr] = Field(default=None, description="reference_id is the ID of the reference ex payment ID, invoice ID, request ID")
    reference_type: Optional[StrictStr] = Field(default=None, description="reference_type is the type of the reference ex payment, invoice, request")
    __properties: ClassVar[List[str]] = ["amount", "description", "expiry_date", "generate_invoice", "metadata", "purchased_credits", "reference_id", "reference_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoTopUpWalletRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoTopUpWalletRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": obj.get("amount"),
            "description": obj.get("description"),
            "expiry_date": obj.get("expiry_date"),
            "generate_invoice": obj.get("generate_invoice"),
            "metadata": obj.get("metadata"),
            "purchased_credits": obj.get("purchased_credits"),
            "reference_id": obj.get("reference_id"),
            "reference_type": obj.get("reference_type")
        })
        return _obj


