# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from flexprice.models.types_entity_type import TypesEntityType
from flexprice.models.types_file_type import TypesFileType
from flexprice.models.types_task_status import TypesTaskStatus
from flexprice.models.types_task_type import TypesTaskType
from typing import Optional, Set
from typing_extensions import Self

class DtoTaskResponse(BaseModel):
    """
    DtoTaskResponse
    """ # noqa: E501
    completed_at: Optional[StrictStr] = None
    created_at: Optional[StrictStr] = None
    created_by: Optional[StrictStr] = None
    entity_type: Optional[TypesEntityType] = None
    error_summary: Optional[StrictStr] = None
    failed_at: Optional[StrictStr] = None
    failed_records: Optional[StrictInt] = None
    file_name: Optional[StrictStr] = None
    file_type: Optional[TypesFileType] = None
    file_url: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    metadata: Optional[Dict[str, Any]] = None
    processed_records: Optional[StrictInt] = None
    started_at: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    successful_records: Optional[StrictInt] = None
    task_status: Optional[TypesTaskStatus] = None
    task_type: Optional[TypesTaskType] = None
    tenant_id: Optional[StrictStr] = None
    total_records: Optional[StrictInt] = None
    updated_at: Optional[StrictStr] = None
    updated_by: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["completed_at", "created_at", "created_by", "entity_type", "error_summary", "failed_at", "failed_records", "file_name", "file_type", "file_url", "id", "metadata", "processed_records", "started_at", "status", "successful_records", "task_status", "task_type", "tenant_id", "total_records", "updated_at", "updated_by"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoTaskResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoTaskResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "completed_at": obj.get("completed_at"),
            "created_at": obj.get("created_at"),
            "created_by": obj.get("created_by"),
            "entity_type": obj.get("entity_type"),
            "error_summary": obj.get("error_summary"),
            "failed_at": obj.get("failed_at"),
            "failed_records": obj.get("failed_records"),
            "file_name": obj.get("file_name"),
            "file_type": obj.get("file_type"),
            "file_url": obj.get("file_url"),
            "id": obj.get("id"),
            "metadata": obj.get("metadata"),
            "processed_records": obj.get("processed_records"),
            "started_at": obj.get("started_at"),
            "status": obj.get("status"),
            "successful_records": obj.get("successful_records"),
            "task_status": obj.get("task_status"),
            "task_type": obj.get("task_type"),
            "tenant_id": obj.get("tenant_id"),
            "total_records": obj.get("total_records"),
            "updated_at": obj.get("updated_at"),
            "updated_by": obj.get("updated_by")
        })
        return _obj


