# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from flexprice.models.price_price import PricePrice
from typing import Optional, Set
from typing_extensions import Self

class DtoSubscriptionUsageByMetersResponse(BaseModel):
    """
    DtoSubscriptionUsageByMetersResponse
    """ # noqa: E501
    amount: Optional[Union[StrictFloat, StrictInt]] = None
    currency: Optional[StrictStr] = None
    display_amount: Optional[StrictStr] = None
    filter_values: Optional[Dict[str, List[StrictStr]]] = None
    meter_display_name: Optional[StrictStr] = None
    meter_id: Optional[StrictStr] = None
    price: Optional[PricePrice] = None
    quantity: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["amount", "currency", "display_amount", "filter_values", "meter_display_name", "meter_id", "price", "quantity"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoSubscriptionUsageByMetersResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of price
        if self.price:
            _dict['price'] = self.price.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoSubscriptionUsageByMetersResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": obj.get("amount"),
            "currency": obj.get("currency"),
            "display_amount": obj.get("display_amount"),
            "filter_values": obj.get("filter_values"),
            "meter_display_name": obj.get("meter_display_name"),
            "meter_id": obj.get("meter_id"),
            "price": PricePrice.from_dict(obj["price"]) if obj.get("price") is not None else None,
            "quantity": obj.get("quantity")
        })
        return _obj


