# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from flexprice.models.types_pause_mode import TypesPauseMode
from flexprice.models.types_pause_status import TypesPauseStatus
from flexprice.models.types_resume_mode import TypesResumeMode
from flexprice.models.types_status import TypesStatus
from typing import Optional, Set
from typing_extensions import Self

class DtoSubscriptionPauseResponse(BaseModel):
    """
    DtoSubscriptionPauseResponse
    """ # noqa: E501
    created_at: Optional[StrictStr] = None
    created_by: Optional[StrictStr] = None
    environment_id: Optional[StrictStr] = Field(default=None, description="EnvironmentID is the environment identifier for the pause")
    id: Optional[StrictStr] = Field(default=None, description="ID is the unique identifier for the subscription pause")
    metadata: Optional[Dict[str, StrictStr]] = None
    original_period_end: Optional[StrictStr] = Field(default=None, description="OriginalPeriodEnd is the end of the billing period when the pause was created")
    original_period_start: Optional[StrictStr] = Field(default=None, description="OriginalPeriodStart is the start of the billing period when the pause was created")
    pause_end: Optional[StrictStr] = Field(default=None, description="PauseEnd is when the pause will end (null for indefinite)")
    pause_mode: Optional[TypesPauseMode] = None
    pause_start: Optional[StrictStr] = Field(default=None, description="PauseStart is when the pause actually started")
    pause_status: Optional[TypesPauseStatus] = None
    reason: Optional[StrictStr] = Field(default=None, description="Reason is the reason for pausing")
    resume_mode: Optional[TypesResumeMode] = None
    resumed_at: Optional[StrictStr] = Field(default=None, description="ResumedAt is when the pause was actually ended (if manually resumed)")
    status: Optional[TypesStatus] = None
    subscription_id: Optional[StrictStr] = Field(default=None, description="SubscriptionID is the identifier for the subscription")
    tenant_id: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    updated_by: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["created_at", "created_by", "environment_id", "id", "metadata", "original_period_end", "original_period_start", "pause_end", "pause_mode", "pause_start", "pause_status", "reason", "resume_mode", "resumed_at", "status", "subscription_id", "tenant_id", "updated_at", "updated_by"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoSubscriptionPauseResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoSubscriptionPauseResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "created_by": obj.get("created_by"),
            "environment_id": obj.get("environment_id"),
            "id": obj.get("id"),
            "metadata": obj.get("metadata"),
            "original_period_end": obj.get("original_period_end"),
            "original_period_start": obj.get("original_period_start"),
            "pause_end": obj.get("pause_end"),
            "pause_mode": obj.get("pause_mode"),
            "pause_start": obj.get("pause_start"),
            "pause_status": obj.get("pause_status"),
            "reason": obj.get("reason"),
            "resume_mode": obj.get("resume_mode"),
            "resumed_at": obj.get("resumed_at"),
            "status": obj.get("status"),
            "subscription_id": obj.get("subscription_id"),
            "tenant_id": obj.get("tenant_id"),
            "updated_at": obj.get("updated_at"),
            "updated_by": obj.get("updated_by")
        })
        return _obj


