# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from flexprice.models.types_pause_mode import TypesPauseMode
from typing import Optional, Set
from typing_extensions import Self

class DtoPauseSubscriptionRequest(BaseModel):
    """
    DtoPauseSubscriptionRequest
    """ # noqa: E501
    dry_run: Optional[StrictBool] = None
    metadata: Optional[Dict[str, StrictStr]] = None
    pause_days: Optional[StrictInt] = None
    pause_end: Optional[StrictStr] = None
    pause_mode: TypesPauseMode
    pause_start: Optional[StrictStr] = None
    reason: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    __properties: ClassVar[List[str]] = ["dry_run", "metadata", "pause_days", "pause_end", "pause_mode", "pause_start", "reason"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoPauseSubscriptionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoPauseSubscriptionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dry_run": obj.get("dry_run"),
            "metadata": obj.get("metadata"),
            "pause_days": obj.get("pause_days"),
            "pause_end": obj.get("pause_end"),
            "pause_mode": obj.get("pause_mode"),
            "pause_start": obj.get("pause_start"),
            "reason": obj.get("reason")
        })
        return _obj


