# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from flexprice.models.dto_environment_response import DtoEnvironmentResponse
from typing import Optional, Set
from typing_extensions import Self

class DtoListEnvironmentsResponse(BaseModel):
    """
    DtoListEnvironmentsResponse
    """ # noqa: E501
    environments: Optional[List[DtoEnvironmentResponse]] = None
    limit: Optional[StrictInt] = None
    offset: Optional[StrictInt] = None
    total: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["environments", "limit", "offset", "total"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoListEnvironmentsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in environments (list)
        _items = []
        if self.environments:
            for _item_environments in self.environments:
                if _item_environments:
                    _items.append(_item_environments.to_dict())
            _dict['environments'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoListEnvironmentsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "environments": [DtoEnvironmentResponse.from_dict(_item) for _item in obj["environments"]] if obj.get("environments") is not None else None,
            "limit": obj.get("limit"),
            "offset": obj.get("offset"),
            "total": obj.get("total")
        })
        return _obj


