# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from flexprice.models.dto_customer_response import DtoCustomerResponse
from flexprice.models.dto_invoice_line_item_response import DtoInvoiceLineItemResponse
from flexprice.models.dto_subscription_response import DtoSubscriptionResponse
from flexprice.models.types_invoice_status import TypesInvoiceStatus
from flexprice.models.types_invoice_type import TypesInvoiceType
from flexprice.models.types_payment_status import TypesPaymentStatus
from typing import Optional, Set
from typing_extensions import Self

class DtoInvoiceResponse(BaseModel):
    """
    DtoInvoiceResponse
    """ # noqa: E501
    amount_due: Optional[Union[StrictFloat, StrictInt]] = None
    amount_paid: Optional[Union[StrictFloat, StrictInt]] = None
    amount_remaining: Optional[Union[StrictFloat, StrictInt]] = None
    billing_period: Optional[StrictStr] = None
    billing_reason: Optional[StrictStr] = None
    billing_sequence: Optional[StrictInt] = None
    created_at: Optional[StrictStr] = None
    created_by: Optional[StrictStr] = None
    currency: Optional[StrictStr] = None
    customer: Optional[DtoCustomerResponse] = None
    customer_id: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    due_date: Optional[StrictStr] = None
    finalized_at: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    idempotency_key: Optional[StrictStr] = None
    invoice_number: Optional[StrictStr] = None
    invoice_pdf_url: Optional[StrictStr] = None
    invoice_status: Optional[TypesInvoiceStatus] = None
    invoice_type: Optional[TypesInvoiceType] = None
    line_items: Optional[List[DtoInvoiceLineItemResponse]] = None
    metadata: Optional[Dict[str, StrictStr]] = None
    paid_at: Optional[StrictStr] = None
    payment_status: Optional[TypesPaymentStatus] = None
    period_end: Optional[StrictStr] = None
    period_start: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    subscription: Optional[DtoSubscriptionResponse] = None
    subscription_id: Optional[StrictStr] = None
    tenant_id: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    updated_by: Optional[StrictStr] = None
    version: Optional[StrictInt] = None
    voided_at: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["amount_due", "amount_paid", "amount_remaining", "billing_period", "billing_reason", "billing_sequence", "created_at", "created_by", "currency", "customer", "customer_id", "description", "due_date", "finalized_at", "id", "idempotency_key", "invoice_number", "invoice_pdf_url", "invoice_status", "invoice_type", "line_items", "metadata", "paid_at", "payment_status", "period_end", "period_start", "status", "subscription", "subscription_id", "tenant_id", "updated_at", "updated_by", "version", "voided_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoInvoiceResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of customer
        if self.customer:
            _dict['customer'] = self.customer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in line_items (list)
        _items = []
        if self.line_items:
            for _item_line_items in self.line_items:
                if _item_line_items:
                    _items.append(_item_line_items.to_dict())
            _dict['line_items'] = _items
        # override the default output from pydantic by calling `to_dict()` of subscription
        if self.subscription:
            _dict['subscription'] = self.subscription.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoInvoiceResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount_due": obj.get("amount_due"),
            "amount_paid": obj.get("amount_paid"),
            "amount_remaining": obj.get("amount_remaining"),
            "billing_period": obj.get("billing_period"),
            "billing_reason": obj.get("billing_reason"),
            "billing_sequence": obj.get("billing_sequence"),
            "created_at": obj.get("created_at"),
            "created_by": obj.get("created_by"),
            "currency": obj.get("currency"),
            "customer": DtoCustomerResponse.from_dict(obj["customer"]) if obj.get("customer") is not None else None,
            "customer_id": obj.get("customer_id"),
            "description": obj.get("description"),
            "due_date": obj.get("due_date"),
            "finalized_at": obj.get("finalized_at"),
            "id": obj.get("id"),
            "idempotency_key": obj.get("idempotency_key"),
            "invoice_number": obj.get("invoice_number"),
            "invoice_pdf_url": obj.get("invoice_pdf_url"),
            "invoice_status": obj.get("invoice_status"),
            "invoice_type": obj.get("invoice_type"),
            "line_items": [DtoInvoiceLineItemResponse.from_dict(_item) for _item in obj["line_items"]] if obj.get("line_items") is not None else None,
            "metadata": obj.get("metadata"),
            "paid_at": obj.get("paid_at"),
            "payment_status": obj.get("payment_status"),
            "period_end": obj.get("period_end"),
            "period_start": obj.get("period_start"),
            "status": obj.get("status"),
            "subscription": DtoSubscriptionResponse.from_dict(obj["subscription"]) if obj.get("subscription") is not None else None,
            "subscription_id": obj.get("subscription_id"),
            "tenant_id": obj.get("tenant_id"),
            "updated_at": obj.get("updated_at"),
            "updated_by": obj.get("updated_by"),
            "version": obj.get("version"),
            "voided_at": obj.get("voided_at")
        })
        return _obj


