# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DtoIngestEventRequest(BaseModel):
    """
    DtoIngestEventRequest
    """ # noqa: E501
    customer_id: Optional[StrictStr] = None
    event_id: Optional[StrictStr] = None
    event_name: StrictStr
    external_customer_id: StrictStr
    properties: Optional[Dict[str, StrictStr]] = Field(default=None, description="Handled separately for dynamic columns")
    source: Optional[StrictStr] = None
    timestamp: Optional[StrictStr] = Field(default=None, description="Handled separately due to parsing")
    __properties: ClassVar[List[str]] = ["customer_id", "event_id", "event_name", "external_customer_id", "properties", "source", "timestamp"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoIngestEventRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoIngestEventRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "customer_id": obj.get("customer_id"),
            "event_id": obj.get("event_id"),
            "event_name": obj.get("event_name"),
            "external_customer_id": obj.get("external_customer_id"),
            "properties": obj.get("properties"),
            "source": obj.get("source"),
            "timestamp": obj.get("timestamp")
        })
        return _obj


