# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from flexprice.models.types_aggregation_type import TypesAggregationType
from flexprice.models.types_window_size import TypesWindowSize
from typing import Optional, Set
from typing_extensions import Self

class DtoGetUsageRequest(BaseModel):
    """
    DtoGetUsageRequest
    """ # noqa: E501
    aggregation_type: TypesAggregationType
    customer_id: Optional[StrictStr] = None
    end_time: Optional[StrictStr] = None
    event_name: StrictStr
    external_customer_id: Optional[StrictStr] = None
    filters: Optional[Dict[str, List[StrictStr]]] = None
    property_name: Optional[StrictStr] = Field(default=None, description="will be empty/ignored in case of COUNT")
    start_time: Optional[StrictStr] = None
    window_size: Optional[TypesWindowSize] = None
    __properties: ClassVar[List[str]] = ["aggregation_type", "customer_id", "end_time", "event_name", "external_customer_id", "filters", "property_name", "start_time", "window_size"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoGetUsageRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoGetUsageRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "aggregation_type": obj.get("aggregation_type"),
            "customer_id": obj.get("customer_id"),
            "end_time": obj.get("end_time"),
            "event_name": obj.get("event_name"),
            "external_customer_id": obj.get("external_customer_id"),
            "filters": obj.get("filters"),
            "property_name": obj.get("property_name"),
            "start_time": obj.get("start_time"),
            "window_size": obj.get("window_size")
        })
        return _obj


