# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from flexprice.models.dto_feature_response import DtoFeatureResponse
from flexprice.models.types_billing_period import TypesBillingPeriod
from flexprice.models.types_feature_type import TypesFeatureType
from flexprice.models.types_status import TypesStatus
from typing import Optional, Set
from typing_extensions import Self

class DtoEntitlementResponse(BaseModel):
    """
    DtoEntitlementResponse
    """ # noqa: E501
    created_at: Optional[StrictStr] = None
    created_by: Optional[StrictStr] = None
    environment_id: Optional[StrictStr] = None
    feature: Optional[DtoFeatureResponse] = None
    feature_id: Optional[StrictStr] = None
    feature_type: Optional[TypesFeatureType] = None
    id: Optional[StrictStr] = None
    is_enabled: Optional[StrictBool] = None
    is_soft_limit: Optional[StrictBool] = None
    plan: Optional[DtoPlanResponse] = None
    plan_id: Optional[StrictStr] = None
    static_value: Optional[StrictStr] = None
    status: Optional[TypesStatus] = None
    tenant_id: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    updated_by: Optional[StrictStr] = None
    usage_limit: Optional[StrictInt] = None
    usage_reset_period: Optional[TypesBillingPeriod] = None
    __properties: ClassVar[List[str]] = ["created_at", "created_by", "environment_id", "feature", "feature_id", "feature_type", "id", "is_enabled", "is_soft_limit", "plan", "plan_id", "static_value", "status", "tenant_id", "updated_at", "updated_by", "usage_limit", "usage_reset_period"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoEntitlementResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of feature
        if self.feature:
            _dict['feature'] = self.feature.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan
        if self.plan:
            _dict['plan'] = self.plan.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoEntitlementResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "created_by": obj.get("created_by"),
            "environment_id": obj.get("environment_id"),
            "feature": DtoFeatureResponse.from_dict(obj["feature"]) if obj.get("feature") is not None else None,
            "feature_id": obj.get("feature_id"),
            "feature_type": obj.get("feature_type"),
            "id": obj.get("id"),
            "is_enabled": obj.get("is_enabled"),
            "is_soft_limit": obj.get("is_soft_limit"),
            "plan": DtoPlanResponse.from_dict(obj["plan"]) if obj.get("plan") is not None else None,
            "plan_id": obj.get("plan_id"),
            "static_value": obj.get("static_value"),
            "status": obj.get("status"),
            "tenant_id": obj.get("tenant_id"),
            "updated_at": obj.get("updated_at"),
            "updated_by": obj.get("updated_by"),
            "usage_limit": obj.get("usage_limit"),
            "usage_reset_period": obj.get("usage_reset_period")
        })
        return _obj

from flexprice.models.dto_plan_response import DtoPlanResponse
# TODO: Rewrite to not use raise_errors
DtoEntitlementResponse.model_rebuild(raise_errors=False)

