# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from flexprice.models.types_status import TypesStatus
from typing import Optional, Set
from typing_extensions import Self

class DtoCustomerResponse(BaseModel):
    """
    DtoCustomerResponse
    """ # noqa: E501
    address_city: Optional[StrictStr] = Field(default=None, description="AddressCity is the city of the customer's address")
    address_country: Optional[StrictStr] = Field(default=None, description="AddressCountry is the country of the customer's address (ISO 3166-1 alpha-2)")
    address_line1: Optional[StrictStr] = Field(default=None, description="AddressLine1 is the first line of the customer's address")
    address_line2: Optional[StrictStr] = Field(default=None, description="AddressLine2 is the second line of the customer's address")
    address_postal_code: Optional[StrictStr] = Field(default=None, description="AddressPostalCode is the postal code of the customer's address")
    address_state: Optional[StrictStr] = Field(default=None, description="AddressState is the state of the customer's address")
    created_at: Optional[StrictStr] = None
    created_by: Optional[StrictStr] = None
    email: Optional[StrictStr] = Field(default=None, description="Email is the email of the customer")
    environment_id: Optional[StrictStr] = Field(default=None, description="EnvironmentID is the environment identifier for the customer")
    external_id: Optional[StrictStr] = Field(default=None, description="ExternalID is the external identifier for the customer")
    id: Optional[StrictStr] = Field(default=None, description="ID is the unique identifier for the customer")
    metadata: Optional[Dict[str, StrictStr]] = Field(default=None, description="Metadata")
    name: Optional[StrictStr] = Field(default=None, description="Name is the name of the customer")
    status: Optional[TypesStatus] = None
    tenant_id: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    updated_by: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["address_city", "address_country", "address_line1", "address_line2", "address_postal_code", "address_state", "created_at", "created_by", "email", "environment_id", "external_id", "id", "metadata", "name", "status", "tenant_id", "updated_at", "updated_by"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoCustomerResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoCustomerResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address_city": obj.get("address_city"),
            "address_country": obj.get("address_country"),
            "address_line1": obj.get("address_line1"),
            "address_line2": obj.get("address_line2"),
            "address_postal_code": obj.get("address_postal_code"),
            "address_state": obj.get("address_state"),
            "created_at": obj.get("created_at"),
            "created_by": obj.get("created_by"),
            "email": obj.get("email"),
            "environment_id": obj.get("environment_id"),
            "external_id": obj.get("external_id"),
            "id": obj.get("id"),
            "metadata": obj.get("metadata"),
            "name": obj.get("name"),
            "status": obj.get("status"),
            "tenant_id": obj.get("tenant_id"),
            "updated_at": obj.get("updated_at"),
            "updated_by": obj.get("updated_by")
        })
        return _obj


