# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class DtoCustomerInvoiceSummary(BaseModel):
    """
    DtoCustomerInvoiceSummary
    """ # noqa: E501
    currency: Optional[StrictStr] = None
    customer_id: Optional[StrictStr] = None
    overdue_invoice_count: Optional[StrictInt] = None
    total_invoice_count: Optional[StrictInt] = None
    total_overdue_amount: Optional[Union[StrictFloat, StrictInt]] = None
    total_revenue_amount: Optional[Union[StrictFloat, StrictInt]] = None
    total_unpaid_amount: Optional[Union[StrictFloat, StrictInt]] = None
    unpaid_fixed_charges: Optional[Union[StrictFloat, StrictInt]] = None
    unpaid_invoice_count: Optional[StrictInt] = None
    unpaid_usage_charges: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["currency", "customer_id", "overdue_invoice_count", "total_invoice_count", "total_overdue_amount", "total_revenue_amount", "total_unpaid_amount", "unpaid_fixed_charges", "unpaid_invoice_count", "unpaid_usage_charges"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoCustomerInvoiceSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoCustomerInvoiceSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency": obj.get("currency"),
            "customer_id": obj.get("customer_id"),
            "overdue_invoice_count": obj.get("overdue_invoice_count"),
            "total_invoice_count": obj.get("total_invoice_count"),
            "total_overdue_amount": obj.get("total_overdue_amount"),
            "total_revenue_amount": obj.get("total_revenue_amount"),
            "total_unpaid_amount": obj.get("total_unpaid_amount"),
            "unpaid_fixed_charges": obj.get("unpaid_fixed_charges"),
            "unpaid_invoice_count": obj.get("unpaid_invoice_count"),
            "unpaid_usage_charges": obj.get("unpaid_usage_charges")
        })
        return _obj


