# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from flexprice.models.types_billing_cadence import TypesBillingCadence
from flexprice.models.types_billing_period import TypesBillingPeriod
from typing import Optional, Set
from typing_extensions import Self

class DtoCreateSubscriptionRequest(BaseModel):
    """
    DtoCreateSubscriptionRequest
    """ # noqa: E501
    billing_cadence: TypesBillingCadence
    billing_period: TypesBillingPeriod
    billing_period_count: Annotated[int, Field(strict=True, ge=1)]
    currency: StrictStr
    customer_id: StrictStr
    end_date: Optional[StrictStr] = None
    lookup_key: Optional[StrictStr] = None
    metadata: Optional[Dict[str, StrictStr]] = None
    plan_id: StrictStr
    start_date: StrictStr
    trial_end: Optional[StrictStr] = None
    trial_start: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["billing_cadence", "billing_period", "billing_period_count", "currency", "customer_id", "end_date", "lookup_key", "metadata", "plan_id", "start_date", "trial_end", "trial_start"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoCreateSubscriptionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoCreateSubscriptionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "billing_cadence": obj.get("billing_cadence"),
            "billing_period": obj.get("billing_period"),
            "billing_period_count": obj.get("billing_period_count"),
            "currency": obj.get("currency"),
            "customer_id": obj.get("customer_id"),
            "end_date": obj.get("end_date"),
            "lookup_key": obj.get("lookup_key"),
            "metadata": obj.get("metadata"),
            "plan_id": obj.get("plan_id"),
            "start_date": obj.get("start_date"),
            "trial_end": obj.get("trial_end"),
            "trial_start": obj.get("trial_start")
        })
        return _obj


