# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from flexprice.models.dto_create_invoice_line_item_request import DtoCreateInvoiceLineItemRequest
from flexprice.models.types_invoice_billing_reason import TypesInvoiceBillingReason
from flexprice.models.types_invoice_status import TypesInvoiceStatus
from flexprice.models.types_invoice_type import TypesInvoiceType
from flexprice.models.types_payment_status import TypesPaymentStatus
from typing import Optional, Set
from typing_extensions import Self

class DtoCreateInvoiceRequest(BaseModel):
    """
    DtoCreateInvoiceRequest
    """ # noqa: E501
    amount_due: Union[StrictFloat, StrictInt]
    amount_paid: Optional[Union[StrictFloat, StrictInt]] = None
    billing_period: Optional[StrictStr] = None
    billing_reason: Optional[TypesInvoiceBillingReason] = None
    currency: StrictStr
    customer_id: StrictStr
    description: Optional[StrictStr] = None
    due_date: Optional[StrictStr] = None
    environment_id: Optional[StrictStr] = None
    idempotency_key: Optional[StrictStr] = None
    invoice_status: Optional[TypesInvoiceStatus] = None
    invoice_type: Optional[TypesInvoiceType] = None
    line_items: Optional[List[DtoCreateInvoiceLineItemRequest]] = None
    metadata: Optional[Dict[str, StrictStr]] = None
    payment_status: Optional[TypesPaymentStatus] = None
    period_end: Optional[StrictStr] = None
    period_start: Optional[StrictStr] = None
    subscription_id: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["amount_due", "amount_paid", "billing_period", "billing_reason", "currency", "customer_id", "description", "due_date", "environment_id", "idempotency_key", "invoice_status", "invoice_type", "line_items", "metadata", "payment_status", "period_end", "period_start", "subscription_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoCreateInvoiceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in line_items (list)
        _items = []
        if self.line_items:
            for _item_line_items in self.line_items:
                if _item_line_items:
                    _items.append(_item_line_items.to_dict())
            _dict['line_items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoCreateInvoiceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount_due": obj.get("amount_due"),
            "amount_paid": obj.get("amount_paid"),
            "billing_period": obj.get("billing_period"),
            "billing_reason": obj.get("billing_reason"),
            "currency": obj.get("currency"),
            "customer_id": obj.get("customer_id"),
            "description": obj.get("description"),
            "due_date": obj.get("due_date"),
            "environment_id": obj.get("environment_id"),
            "idempotency_key": obj.get("idempotency_key"),
            "invoice_status": obj.get("invoice_status"),
            "invoice_type": obj.get("invoice_type"),
            "line_items": [DtoCreateInvoiceLineItemRequest.from_dict(_item) for _item in obj["line_items"]] if obj.get("line_items") is not None else None,
            "metadata": obj.get("metadata"),
            "payment_status": obj.get("payment_status"),
            "period_end": obj.get("period_end"),
            "period_start": obj.get("period_start"),
            "subscription_id": obj.get("subscription_id")
        })
        return _obj


