# coding: utf-8

"""
    FlexPrice API

    FlexPrice API Service

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class DtoCreateCustomerRequest(BaseModel):
    """
    DtoCreateCustomerRequest
    """ # noqa: E501
    address_city: Optional[Annotated[str, Field(strict=True, max_length=100)]] = None
    address_country: Optional[StrictStr] = None
    address_line1: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    address_line2: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    address_postal_code: Optional[Annotated[str, Field(strict=True, max_length=20)]] = None
    address_state: Optional[Annotated[str, Field(strict=True, max_length=100)]] = None
    email: Optional[StrictStr] = None
    external_id: StrictStr
    metadata: Optional[Dict[str, StrictStr]] = None
    name: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["address_city", "address_country", "address_line1", "address_line2", "address_postal_code", "address_state", "email", "external_id", "metadata", "name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoCreateCustomerRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoCreateCustomerRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address_city": obj.get("address_city"),
            "address_country": obj.get("address_country"),
            "address_line1": obj.get("address_line1"),
            "address_line2": obj.get("address_line2"),
            "address_postal_code": obj.get("address_postal_code"),
            "address_state": obj.get("address_state"),
            "email": obj.get("email"),
            "external_id": obj.get("external_id"),
            "metadata": obj.get("metadata"),
            "name": obj.get("name")
        })
        return _obj


