try:
    import ujson as json
except ModuleNotFoundError:
    import json


def get_message_text(data: str) -> str:
    data = json.loads(data)
    result = ''
    try:
        for msg in data['message']:
            if msg['type'] == 'text':
                result += msg['data']['text'].strip() + ' '
        return result.strip()
    except Exception:
        return ''


def get_message_at(data: str) -> list:
    qq_list = []
    data = json.loads(data)
    try:
        for msg in data['message']:
            if msg['type'] == 'at':
                qq_list.append(int(msg['data']['qq']))
        return qq_list
    except Exception:
        return []


def is_number(s) -> bool:
    try:
        float(s)
        return True
    except ValueError:
        pass
    try:
        import unicodedata
        unicodedata.numeric(s)
        return True
    except (TypeError, ValueError):
        pass
    return False