# -*- coding: utf-8 -*-
"""OOPDProjectV2.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1wcYpT91ei7P8PaFbfDVdUEkADZL7uIiy

## `OOPD End Sem Project`
## `Two Layer Perceptron`

<a href = "https://colab.research.google.com/drive/1qLT9UC7YatwVN9yeAGHpoBMZvZuBekem?usp=sharing">Previous copy</a>

#### Agenda -
<ul>
  <li><b>Apply Inheritance, Polymorphism, Encapsulation, etc.</b></li>
  <li><b>Make subroutines stick to OOPD principles, and comment out each relevant step</b></li>
  <li><b>Loading the dataset into a database and reloading from the later before the process of modelling and evaluation starts</b></li>
  <li>
      <b>Creating a class that implements 2 layer perceptron from scratch based on known principles of OOP design</b>
  </li>
</ul>
"""

## Importing requisite Libraries and Modules
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
from sklearn.datasets import load_digits
import sqlite3 as sql
from sklearn.preprocessing import StandardScaler,MinMaxScaler

## \@author {Giridhar S., Palani Vigneshwar, Shashwat Vaibhav, Arpit Mathur}

"""## Class ALERT!
## A class `DescribeNCreate` which describes the all the relevant information and statements(when verbose is True) regarding the dataset.
"""

## A generic class returning some descriptive stats about the dataset
class DescribeNCreate():
  
  ## defining the construtors and methods.
  def __init__(self, dataset):
    ## storing passed dataset during object instantiation to the object member variable
    self.datas = dataset
  
  def  information(self, verbose= True):
    ## This method gives(prints out) the generic information about our mnist data
    print(f'This is the mnist data repository')
    print(f'The dataset stores the pixel-wise information of the handwritten digit')
    if verbose == True:
      ## printing only when the user wants all the information
      print('The dataset stores the information for each Image ')
      print('Every pixel-value(intensity) is stored in a column designated for that pixel')
      print(f'Total Number of attributes/features are {len(self.datas.feature_names)} and the features are\n {self.datas.feature_names}')
      print(f'Number of instances: {len(self.datas.data)} . Let\'s take a peek\n {self.datas.data}')
  
  def createDF(self):
    ## This method/routine creates dataframe from the dataset metadata, it can be useful for further analysis
    ## This function requires pandas module, make sure it has been imported as pd -->we have already imported 
    dummyDF = pd.DataFrame(data = self.datas.data, columns = self.datas.feature_names)
    ## Now adding the target column
    ## This step is necessary to ensure we have all the columns
    ## for creating a complete dataframe of features and target variable for every instance
    dummyDF['target'] = self.datas.target
    return dummyDF

  def descriptive_stats(self, dummyDF):
      ## This function is a generic routine that returns the descriptive statistics about a dataframe  
      print('top 5 instances')
      print(dummyDF.head())
      print(f'information:\n {dummyDF.info()}' )
      print(f'Number of columns in the DataFrame(including target): {len(dummyDF.columns)}')
      print(f'Features of the dataframe\n: {dummyDF.columns}')
      print(f'Describing the dataframe:\n {dummyDF.describe().T}')

"""## Database setup"""

## implementing a database based approach
## to call mnist data, store it by creating dataframe
## using DescribeNCreate class and then store it in a csv file and then restoring it to a sql database

## Inheritance
## Loading the data to database --> implementation from scratch
class DataBASE(DescribeNCreate): 
  ## This class inherits from the class DescribeNCreate
  ## it implements specific subroutines/methods and uses EXCEPTION HANDLING to ensure avoidable circumstances are routed with requisite message  
  ## make sure module sqlite3 has been imported --> we have imported sqlite3 as sql 
  ## make sure numpy module has been imported --> we have imported it as np
     def df_to_db(self, dataframe, db_name):
       ## a function that  stores the row-wise data into database of name db_name.db
       filename = db_name + '.db'
       ## make connection
       ## add row wise data from dataframe to the .db file using standard sql DDL commands
       ## creating a connection object
       try:
         conn_obj = sql.connect(filename)
         ##print('1st debug pnt')
         print('connected')##adding for debugging purpose
         schema_string = 'CREATE TABLE IF NOT EXISTS mnist_data('
         for col in dataframe.columns:
           if col != 'target':
             schema_string = schema_string + col + ' ' ##-->column name
             schema_string = schema_string + 'REAL, '     ##--> data type of column 
           else:
             ##Last column ---> 'target' of integer type
             schema_string = schema_string + col + ' '
             schema_string = schema_string + 'INTEGER );' 
          ##end of for loop 
          ##****---SCHEMA CREATION---****
          ##Now let's execute the code to create schema for Our database
         ##print('3rd debug pnt') 
         conn_obj.execute(schema_string)
         print('Created Schema')##adding for debugging purpose
         conn_obj.commit() ## committing to ensure the schema and therby table has been  created and saved.
        
         ## Let's ensure that whenever a new object of this type has been created
         ## the data does not get appended everytime to the database table
         ## hence on every new instantiation table content would be deleted
         ##Ensuring-->>

         query_delete = 'DELETE FROM mnist_data'
         conn_obj.execute(query_delete)
         conn_obj.commit()
  
         ## <-- Ensured
          ## Let's insert values into the table

         insert_string_start = 'INSERT INTO mnist_data VALUES('
         insert_string_end = ');'
          
         for locn in np.arange(0, len(dataframe)):
           instance_row_val = dataframe.iloc[locn].values
           upper_bound = len(instance_row_val)
           ##print('inside loop debug pnt')
           insert_string_mid = ''
           for val in np.arange(0,upper_bound):
             if val != (upper_bound-1): 
                ##now  the last element
               insert_string_mid = insert_string_mid + str(instance_row_val[val]) + ',' 

             else:
               ## last element of the row
               insert_string_mid = insert_string_mid + str(instance_row_val[val])


           insert_string = insert_string_start + insert_string_mid + insert_string_end
            
             ## Executing INSERT operation for each instance in dataframe to be inserted as a row in database table
          #  print('INSERT INTO Query Formulated, Now inserting')
           conn_obj.execute(insert_string)
           conn_obj.commit()

         print(f'Database created successfully inside database file {filename} with the table name ---> mnist_data !!')

       except:
         print("DB ERROR!!!! UNABLE TO CONNECT/ COMMAND FAULT !!!!")
       
       finally:
         ##Let's close the connection object
         print('Closing database connection')
         conn_obj.close()

class FetchDB(DataBASE):
  ## inherits from DataBASE class 
  ## implements subroutines to fetch database and tables 

  def db_to_df(self, dbname, tablename):
    ## this method converts database to dataframe
      db_file    = dbname    + '.db'
      try:
        conn_obj = sql.connect(db_file)
        print('<---- Connection  Established ----->')

        query = f'SELECT * FROM {tablename} ;'

        ## query formulated to select every instance from the database

        created_df = pd.read_sql_query(query, conn_obj)
        print('Executed Query')
        
      
      except:
        ## throws error when issues related to database connectivity or
        ## query error is encountered inside the try block
        print("UNABLE TO CONNECT! ERROR WHILE FETCHING!!")
      
      finally:
        print("<-----Closing connection----->")
        conn_obj.close()

      return created_df

## Class to add test data and their predicted values to a new database(name provided) with a table(name provided)
class newDataBASE:
  ## defining constructor
  ## make sure sqlite3 has been imported --> we have imported it as sql
  ## this class defines contructors and other methods along with EXCEPTION Handling
  def __init__(self, dbname, tablename):
    self.dbname = dbname + '.db'
    self.tablename = tablename

  def create_table(self, X, Predicted, features):

    try:
      conn_obj = sql.connect(self.dbname)
      print('connected successfully')

      schema_string = f'CREATE TABLE IF NOT EXISTS {self.tablename}('
      for col in features:
          if col != 'target':
            schema_string = schema_string + col + ' ' ##-->column name
            schema_string = schema_string + 'REAL, '     ##--> data type of column 
        
             ##Last column ---> 'target' of integer type
      schema_string = schema_string + 'Predicted' + ' '
      schema_string = schema_string + 'INTEGER );'

      conn_obj.execute(schema_string)
      print('Creation of schema for new database has been successfull')

      insert_start = f'INSERT INTO {self.tablename} VALUES('
      insert_end = ');'
      

      for row in np.arange(0,X.shape[0]):
        insert_mid = ''

        for col in np.arange(0,X.shape[1]):
          insert_mid = insert_mid + str(X[row][col]) + ','
        
        insert_mid = insert_mid + str(Predicted[row])
        
        insert = insert_start + insert_mid + insert_end
        print(insert)

        conn_obj.execute(insert)
      
      conn_obj.commit()

    except:
      print("DATABASE NOT CONNECTED/ COMMAND ERROR  !!")
    
    finally:
      print(f'new table with name {self.tablename} has been created inside {self.dbname}')
      conn_obj.close()

"""## Next Steps"""

## activation function class
class activation_function():
  ## This class acts as a generic class consisting of methods/routines to implement several activation functions
   
  def sigmoid(self,x):
    ## sigmoid activation
    return 1/(1+ np.exp(-x))
 
  def softmax(self,x):
    ## softmax activation
    e = np.exp(x - x.max())
    return e / np.sum(e,axis=0)

   
  def tanh(self,x):
    ## tanh activation
    return (np.exp(x) - np.exp(-x))/(np.exp(x) + np.exp(-x))
  
  
  def Relu(self,x):
    ## Relu activation
    return np.maximum(0.0,x)

  
  def diff_sigmoid(self,x):
    ## differentiation of sigmoid activation
    return self.sigmoid(x) * (1 - self.sigmoid(x))
  
  def diff_softmax(self,x):
    ## differentiation of softmax activation
    return self.softmax(x) * (1-self.softmax(x))

  def diff_tanh(self,x):
    ## differentiation of tanh activation
    return 1 - (self.tanh(x))**2
 
  def diff_relu(self,x):
    ## differentiation of relu activation
    return np.where(x>0,1.0,0.0)

class propagation(activation_function):
  ## propogation class inheriting the activation class 
  ## defines methods for necessary for forward and backward propagation
  
  def setw(self,w1,w2,w3):
    ## function that set the weights. Encapsulation is implemented in this function
      
      self.__w1= w1
      self.__w2 = w2
      self.__w3 = w3

  def setb(self,b1,b2,b3):
    ## function that sets the bias. Encapsulation is implemented in this function
      self.__b1= b1
      self.__b2 = b2
      self.__b3 = b3


  def forward_propagation(self,train):
    ## function to implement forward propagation in the network
    
    layer={}
    
    ##input
    layer['I0'] = train
    
    layer['Y1'] = np.dot(self.__w1,train) + self.__b1
    layer['I1'] = self.Relu(layer['Y1'])

    layer['Y2'] = np.dot(self.__w2,layer['I1']) + self.__b2
    layer['I2'] = self.sigmoid(layer['Y2'])

    layer['Y3'] = np.dot(self.__w3,layer['I2']) + self.__b3
    layer['I3'] = self.softmax(layer['Y3'])

    return layer


  def backward_propagation(self,train_y,layer):
    ## function to implement backward propagation in the network
    update_parameters={}

    error = (layer['I3'] - train_y)/layer['I3'].shape[0] * self.diff_softmax(layer['Y3'])
    update_parameters['b3'] = np.sum(error,axis=0)
    update_parameters['w3'] = np.dot( np.reshape(error, (error.size,1 ) ), np.reshape( layer['I2'], (1,layer['I2'].size) ) )
    
    
    error = np.dot(self.__w3.T,error) * self.diff_sigmoid(layer['Y2'])
    update_parameters['b2'] = np.sum(error,axis=0)
    update_parameters['w2'] = np.dot( np.reshape(error, (error.size,1 ) ), np.reshape( layer['I1'], (1,layer['I1'].size) ) )
    

    error = np.dot(self.__w2.T,error) * self.diff_relu(layer['Y1'])
    update_parameters['b1'] = np.sum(error,axis=0)
    update_parameters['w1'] = np.dot( np.reshape(error, (error.size,1 ) ), np.reshape( layer['I0'], (1,layer['I0'].size) ) )
    

    return update_parameters

class tlp(propagation):
  ## class tlp inheriting the propagation class 
  def __init__(self,shape,epochs=10,learn_rate=0.1):
    ## Constructor of the class
    self.__shape = shape
    self.__epochs = epochs
    self.__learn_rate = learn_rate
    self.initialize()

  
  def initialize(self):
    ## Initializing the weights and bias of the layers in the network and also creating input layer, two hidden layers and one output layer
    input = self.__shape[0]
    hidden_layer1 = self.__shape[1]
    hidden_layer2 = self.__shape[2]
    output = self.__shape[3]
    np.random.seed(0)
    ## Initializing the weights by selecting random value 
    self.__w1 = np.random.randn(hidden_layer1,input)
    self.__w2 = np.random.randn(hidden_layer2,hidden_layer1)
    self.__w3 = np.random.randn(output,hidden_layer2)

    ## Initializing the bias by selecting random value
    self.__b1 = np.random.randn(self.__w1.shape[0],)
    self.__b2 = np.random.randn(self.__w2.shape[0],)
    self.__b3 = np.random.randn(self.__w3.shape[0],)

  
  
    
  def update(self,update_parameters):
    ##  function to update the weights and bias

    self.__w3 -= self.__learn_rate*update_parameters['w3']
    self.__w2 -= self.__learn_rate*update_parameters['w2']
    self.__w1 -= self.__learn_rate*update_parameters['w1']

    self.__b3 -= self.__learn_rate*update_parameters['b3']
    self.__b2 -= self.__learn_rate*update_parameters['b2']
    self.__b1 -= self.__learn_rate*update_parameters['b1']

  
  def train(self,train_x,train_y):
    ## function to train the model
    
    for i in range(self.__epochs):
      for j in range(len(train_x)):
        self.setw(self.__w1,self.__w2,self.__w3)
        self.setb(self.__b1,self.__b2,self.__b3)
        layer = self.forward_propagation(train_x[j])
        update_parameters = self.backward_propagation(train_y[j],layer)
        self.update(update_parameters)

   
  def predict(self,test_x):
    ## function to predict the output
    pred=[]
    for j in range(len(test_x)):
        layer = self.forward_propagation(test_x[j])
        pred.append(np.argmax(layer['I3']))

    return pred
    
  
  def accuracy(self,y,pred):
    ## function to find the accuracy
    comm=[]
    for i in range(len(y)):
      if y[i]==pred[i]:
        comm.append(y[i])

    return len(comm)/len(y)