# -*- coding: utf-8 -*-
"""
Copyright (C) 2014-2023, Jacques Beilin <jacques.beilin@gmail.com>

This software is a computer program whose purpose is to [describe
functionalities and technical features of your software].

This software is governed by the CeCILL-C license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL-C
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author, the holder of the
economic rights, and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading, using, modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate, and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and, more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C license and that you accept its terms.

"""

from math import pi

c = 299792458.0
f1 = 1575420000.0 # L1-CARRIER FREQUENCY   GPS       1/SEC
f2 = 1227600000.0 # L2-CARRIER FREQUENCY   GPS       1/SEC
f5 = 1176450000.0
f1_2 = f1**2
f2_2 = f2**2
k_L3 = 1.0/(f1_2 - f2_2)
lambda1 = c/f1
lambda2 = c/f2

Rmin=6356000 # rayon min pour savoir si un point est sur terre
Rmax=6380000 # rayon max pour savoir si un point est sur terre

# limit values for PR
PRmin = 15000000;
PRmax = 35000000;

# meteo for tropospheric correction
T = 285.0 # Kelvin
P = 1013.15 # Hpa
H = 50 # percent

# Angle conversion
d2r = pi / 180.0

# ellipsoide IAG GRS 80
a = 6378137.0
rf = 298.257222101
f = 1/rf
Omega_e = -7.2921151467e-5 #rad.s-1

