# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pipper', 'pipper.versioning']

package_data = \
{'': ['*'], 'pipper': ['resources/*']}

install_requires = \
['boto3>=1.16.0',
 'pip',
 'poetry',
 'requests>=2.24.0',
 'semver>=2.13.0',
 'setuptools',
 'toml',
 'wheel']

entry_points = \
{'console_scripts': ['pipper = pipper.command:run']}

setup_kwargs = {
    'name': 'pipper',
    'version': '0.8.1',
    'description': 'A serverless Python package manager for private packages that runs on S3.',
    'long_description': "# Pipper\n\n[![PyPI version](https://badge.fury.io/py/pipper.svg)](https://pypi.org/project/pipper/)\n[![build status](https://gitlab.com/rocket-boosters/pipper/badges/main/pipeline.svg)](https://gitlab.com/rocket-boosters/pipper/commits/main)\n[![coverage report](https://gitlab.com/rocket-boosters/pipper/badges/main/coverage.svg)](https://gitlab.com/rocket-boosters/pipper/commits/main)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![Code style: flake8](https://img.shields.io/badge/code%20style-flake8-white)](https://gitlab.com/pycqa/flake8)\n[![Code style: mypy](https://img.shields.io/badge/code%20style-mypy-white)](http://mypy-lang.org/)\n[![PyPI - License](https://img.shields.io/pypi/l/pipper)](https://pypi.org/project/pipper/)\n\n__Private Python package manager on an S3 bucket__\n\nA Python package manager wrapped around pip and poetry for lightweight\nmanagement of non-public packages with an AWS S3 static backend. Requires no\nserver or database resources, only a private S3 bucket that stores the pipper\npackages. Authentication is handled using standard AWS Identity and Access\nManagement (IAM) users, roles and policies.\n\n\n## Installing pipper\n\nThe pipper package can be installed using pip:\n\n    $ pip install pipper\n\nor with poetry:\n\n    $ poetry add pipper --dev\n\n## Basic Usage\n\nPipper is primarily used from the command line and consists of multiple \nsub-command actions. The general format of a pipper command is:\n\n    $ pipper <ACTION> <REQUIRED_ARGS> --flag=<VALUE> --other-flag ...\n\nThe available actions are:\n\n * [install](#install-action): add or update new packages\n * [download](#download-action): save remote packages locally\n * [info](#info-action): information on a specific package\n * [bundle](#bundle-action): bundle a package for publishing\n * [publish](#publish-action): release a new or updated package\n * [authorize](#authorize-action): create a pre-authorized url for download\n * [repository](#repository-action): Modify pre-defined pipper repositories\n\n    \n## AWS Credentials\n\nPipper uses AWS credentials for authentication. To maximize flexibility, the \nAWS credentials can be specified in a myriad of ways. Pipper will try to\nidentify credentials in the following order:\n\n__1. Explicit Credentials:__ You can specify the AWS credentials directly on\nthe command line with the `--credentials` flag:\n\n* `-c --credentials <AWS_ACCESS_KEY_ID> <AWS_SECRET> <AWS_SESSION_TOKEN>`\n\nThis can be useful for situations where profiles are not initialized or \nundesirable. If your credentials do not require a session token, which is\nusually the case, that argument can be omitted. It's also possible to specify\na missing token using a `0` value for the `<AWS_SESSION_TOKEN>` argument for\nsimplicity in cases where omitting the value is more difficult than including\nit with an explicit ignore value.\n\n\n__2. Pipper Configuration:__ Using pipper's _repository_ command action, you can store\ncredentials and remote information in a pipper config file. If you do create a pipper\nrepository configuration, which stores AWS credentials, you can reference\nthat repository configuration by name to provide credentials to the \nvarious commands with the `--repository` command flag:\n\n* `-r --repository <PIPPER_REPOSITORY_NAME>`\n\nFor more information on how to specify repository configurations for use with\nthis flag, see the [repository](#repository-action). This is the recommended\nway to specify credentials for persistent environments like your local computer.\n\n__3. AWS Profiles:__ Standard AWS profile-based credentials can be used as \nwell. Use the `--profile` flag to specify the name of the profile you wish\nto use:\n\n* `-p --profile <AWS_PROFILE_NAME>`\n \n__4. Pipper Environmental Variables:__ If none of the previous forms of \ncredentials are provided, pipper will try to use pipper-specific environmental \nvariables:\n\n`PIPPER_AWS_ACCESS_KEY_ID`\n     \n`PIPPER_AWS_SECRET_ACCESS_KEY`  \n\n`PIPPER_AWS_SESSION_TOKEN`\n\n__5. AWS Environmental Variables:__ If none of the previous forms of credentials\nare provided, pipper will attempt to use the standard AWS environmental \nvariables:\n\n`AWS_ACCESS_KEY_ID` \n\n`AWS_SECRET_ACCESS_KEY`\n\n`AWS_SESSION_TOKEN`\n\nIf neither set of environmental variables exist, pipper\nwill fallback to using the _default_ profile credentials if they exist.\n\n__6. Default Pipper Repository Configuration:__ If none of the other \ncredentials are specified, pipper will try to use the default repository\nconfiguration if one exists.\n\n__7. System-level credentials:__ In the end, pipper will try to use the \ndefault system-level credentials, which is useful in situations like EC2\ninstances where the credentials are baked into the instance. However, on\nremote systems the lack of specified credentials will likely result in \nauthorization exceptions.\n\n\n## Install Action\n\nThe pipper command can be used to install packages directly from the command\nlin in much the same way you install packages with pip. The command is\nfollowed by one or more packages to install. Specific package versions can be\ndownloaded by appending the version to package names with a colon separator.\n\n    $ pipper install <PACKAGE_NAME[:VERSION]> <PACKAGE_NAME[:VERSION]>\n\nThere are a number of flags available to modify how the install command\nfunctions:\n\n* `-b --bucket <BUCKET_NAME>`\n\n    Name of the S3 bucket where the remote pipper files are stored.\n\n* `-i --input <INPUT_FILE>`\n\n    Allows you to load one or more packages from a pipper-formatted\n    JSON file. Use this in place of specifying the packages directly\n    in the command when convenient.\n    \n* `-u --upgrade`\n\n    When specified currently installed packages will be updated to the latest\n    version. If this flag is not specified the installation process will\n    ignore already installed packages, even if a newer version is available.\n\nWhen installing pipper packages, pipper dependencies are handled recursively as\nlong as the dependency packages have a properly configured pipper.json file\nlocated at the top-level of the repository.\n\n### Installation Examples\n\n    $ pipper install foo --bucket my_bucket --profile my_profile\n\nInstalls the `foo` package using the default AWS credentials associated with\nthe _my_profile_ AWS profile from the _my_bucket_ S3 bucket.\n\n\n## Download Action\n\nThe download action can be used to download pipper packages for later use. This\ncan be helpful if you want to make packages available while offline or when\nAWS credentials are unavailable.\n\n    $ pipper download <PACKAGE_NAME[:VERSION]>\n\n* `-b --bucket <BUCKET_NAME>`\n\n    Name of the S3 bucket where the remote pipper files are stored.\n\n* `-d --directory <DIRECTORY_NAME>`\n\n    The directory where the pipper bundle file for the package should be\n    saved to when downloaded.\n\n* `-i --input <INPUT_FILE>`\n\n    Allows you to download one or more packages from a pipper-formatted\n    JSON file. Use this in place of specifying the packages directly\n    in the command when convenient.\n\n* `-e --extract`\n\n    When specified, the downloaded pipper files will be immediately extracted\n    into their consituent wheel and metadata files. Useful if you want to \n    install directly with pip using advanced options such as installing to\n    a specific directly.\n\n\n## Repository Action\n\nThe repository action allows you to create and managed named repositories, \nwhich can be used to simplify the management of credentials within the \ncommand line. The repository command action has a number of sub-actions:\n\n\n### Repository: add\n\n    $ pipper repository add <REPOSITORY_NAME>\n\nAdds a new repository configuration with the specified name. Use the \n`-p --profile` or `-c --credentials` flag to specify the AWS credentials to\nbe used by this repository. The _add_ sub-action has other flags:\n\n* `-b --bucket <BUCKET_NAME>`\n\n    Name of the S3 bucket where the remote pipper files are stored for this\n    configuration. If the bucket is set in the repository configuration, it\n    will automatically be used by pipper.\n\n* `-d --default`\n\n    If this flag is set, this repository configuration will be the default one\n    used when no credentials or other information is specified.\n\n\n### Repository: modify\n\n    $ pipper repostory modify <EXISTING_REPOSITORY_NAME>\n\nModifies an existing repository configuration with new values. This sub-action\nhas the same flags as the _add_ sub-action. Any flags that you set will be\nused to replace existing values. Any omitted flags will retain their existing\nvalues.\n\n\n### Repository: remove\n\n    $ pipper repository remove <EXISTING_REPOSITORY_NAME>\n    \nRemoves an existing repository configuration from the configuration storage.\n\n\n### Repository: list\n\n    $ pipper repository list\n\nUse this command to list the currently stored repository configurations. It\nalso lets you know which of the configurations is set to the default value.\n\n\n### Repository: exists\n\n    $ pipper repository exists\n\nDisplays information on whether or not a repository configuration currently \nexists.\n\n\n## Authorize Action\n\nThere are times when having AWS credentials available isn't practical. To get\naround those you can create pre-authorized URLs for downloading and installing\npackages that can be used where credentials are not available.\n\n    $ pipper authorize <PACKAGE_NAME[:VERSION]> ...\n    \n* `-b --bucket <BUCKET_NAME>`\n\n    Name of the S3 bucket where the remote pipper files are stored.\n\n* `-i --input <INPUT_FILE>`\n\n    Allows you to load one or more packages from a pipper-formatted\n    JSON file. Use this in place of specifying the packages directly\n    in the command when convenient.\n\n* `-o --ouput <OUTPUT_FILE>`\n\n    If specified, a pre-authorized pipper config file will be written that\n    can be used later by download and installation commands.\n\n* `-e --expires <EXPIRES_IN>`\n\n    How long the authorized URL is valid before it expires. The format\n    should be `<NUMBER><UNIT>`, where the number is a positive integer and\n    the unit can be hours, minutes or seconds. Units can be abbreviated, e.g.:\n    \n    * _12mins_: 12 minutes\n    * _130m_: 130 minutes\n    * _18s_: 18 seconds\n    * _3hr_: 3 hours\n\n\n## Info Action\n\nPrints information on the locally installed and remote versions of the \nspecified package. Also, informs you if there is a newer version of the package\navailable for upgrade.\n\n    $ pipper info <PACKAGE_NAME>\n\n* `-l --local`\n\n    Only display local package information, which can be useful if you're\n    just looking for what is installed locally and don't want to provide\n    AWS credential information as well.\n\n* `-b --bucket <BUCKET_NAME>`\n\n    Name of the S3 bucket where the remote pipper files are stored. This\n    flag is needed unless the local flag is used, which does not communicate\n    with the remote S3 files.\n\n\n## Bundle Action\n\nCreates a pipper package distribution file that can be installed directly or\npublished to a remote S3 bucket for distribution.\n\n    $ pipper bundle <PACKAGE_DIRECTORY>\n    \n* `-o --output <OUTPUT_DIRECTORY>`\n\n    The directory where the pipper bundle should be saved. Defaults to the \n    current working directory.\n    \n    \n## Publish Action\n\nDeploys a pipper bundle file to a remote S3 bucket for distribution.\n\n    $ pipper publish <PIPPER_FILENAME>\n    \nIf you specify a directory instead of a filename, pipper will search for a\npipper file in that directory and upload it. If multiple pipper files are\nfound, the most recently created one will be uploaded.\n    \n    $ pipper publish <DIRECTORY_CONTAINING_PIPPER_FILE>\n\n* `-b --bucket <BUCKET_NAME>`\n    \n    Name of the S3 bucket where the package will be published.\n\n* `-f --force`\n    \n    Unless this flag is specified, publishing a package will be skipped if an\n    identical version of the package has already been published.\n\n\n## Version Locking\n\nPipper supports version matching/locking in a similar fashion to pip. However,\nthe syntax is a little bit stricter. Values must conform to semantic\nversions. Consider a library `foo`. A specific version can be installed using\nany of the following statements:\n\n- `foo` no version will install latest\n- `foo:1.2.3` that specific version\n- `foo:=1.2.3` that specific version\n- `foo:==1.2.3` that specific version\n- `foo:1.2.*` the latest revision of `1.2.x`\n- `foo:1.*.*` the latest minor version and revision of `1.x.x`\n- `foo:<1.2.3` any version below the specified one\n- `foo:<=1.2.3` any version equal to or below the specified one\n- `foo:>1.2.3` any version above the specified one\n- `foo:>=1.2.3` any version equal to or above the specified one\n",
    'author': 'Scott Ernst',
    'author_email': 'swernst@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.com/rocket-boosters/pipper',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0.0',
}


setup(**setup_kwargs)
