import datetime
from typing import Any

class BaseTzInfo(datetime.tzinfo):
    zone: str | None  # Actually None but should be set on concrete subclasses

class StaticTzInfo(BaseTzInfo):
    def fromutc(self, dt: datetime.datetime) -> datetime.datetime: ...
    def localize(self, dt: datetime.datetime, is_dst: bool = ...) -> datetime.datetime: ...
    def normalize(self, dt: datetime.datetime, is_dst: bool = ...) -> datetime.datetime: ...
    def tzname(self, dt: datetime.datetime | None, is_dst: bool | None = ...) -> str: ...
    def utcoffset(self, dt: datetime.datetime | None, is_dst: bool | None = ...) -> datetime.timedelta: ...
    def dst(self, dt: datetime.datetime | None, is_dst: bool | None = ...) -> datetime.timedelta: ...

class DstTzInfo(BaseTzInfo):
    def __init__(self, _inf: Any = ..., _tzinfos: Any = ...) -> None: ...
    def fromutc(self, dt: datetime.datetime) -> datetime.datetime: ...
    def localize(self, dt: datetime.datetime, is_dst: bool | None = ...) -> datetime.datetime: ...
    def normalize(self, dt: datetime.datetime) -> datetime.datetime: ...
    def tzname(self, dt: datetime.datetime | None, is_dst: bool | None = ...) -> str: ...
    def utcoffset(self, dt: datetime.datetime | None, is_dst: bool | None = ...) -> datetime.timedelta | None: ...
    def dst(self, dt: datetime.datetime | None, is_dst: bool | None = ...) -> datetime.timedelta | None: ...
