/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.tools;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.RandomAccess;

public class CustomArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private int size = 0;
    private transient E[] v;

    public CustomArrayList(int capacity) {
        this.v = new Object[capacity];
    }

    public CustomArrayList() {
        this(10);
    }

    public void trimToSize(int s) {
        this.size = s;
    }

    public void addNotRepeated(E value) {
        for (int i = 0; i < this.size; ++i) {
            if (!value.equals(this.v[i])) continue;
            return;
        }
        this.add(value);
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void insert(E x) {
        if (this.size == this.v.length) {
            this.v = Arrays.copyOf(this.v, this.v.length + (this.v.length >> 1));
        }
        this.v[this.size++] = x;
    }

    @Override
    public boolean add(E x) {
        if (this.size == this.v.length) {
            this.v = Arrays.copyOf(this.v, this.v.length + (this.v.length >> 1));
        }
        this.v[this.size++] = x;
        return true;
    }

    public void removePosition(int x) {
        this.v[x] = this.v[--this.size];
    }

    @Override
    public E get(int index) {
        return this.v[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public E retrieve() {
        --this.size;
        return this.get(this.size);
    }

    public void append(CustomArrayList<E> array) {
        for (Object v : array) {
            this.add(v);
        }
    }

    public boolean includes(E elem) {
        for (E val : this.v) {
            if (val != elem) continue;
            return true;
        }
        return false;
    }
}

