/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.agreement_technologies.common.map_planner.CausalLink;
import org.agreement_technologies.common.map_planner.Condition;
import org.agreement_technologies.common.map_planner.Ordering;
import org.agreement_technologies.common.map_planner.Plan;
import org.agreement_technologies.common.map_planner.PlannerFactory;
import org.agreement_technologies.common.map_planner.Step;
import org.agreement_technologies.common.map_viewer.PlanViewer;

public class PlanViewerImp
extends JPanel
implements PlanViewer,
MouseListener,
MouseMotionListener,
MouseWheelListener,
ActionListener {
    private static final long serialVersionUID = -677123886339372031L;
    private Plan plan = null;
    private Graph g = null;
    private ArrayList<Node>[] levels = null;
    private int maxLevels;
    private int maxNodesPerLevel;
    private int width;
    private int height;
    private int mouseX;
    private int mouseY;
    private Hashtable<String, Color> agentColor;
    private PopUpMenu popUpMenu;
    private BufferedImage back;
    private double scale;
    private Node selected;
    private boolean showPrecs;
    private boolean showEffs;
    private PlannerFactory pf;
    private static Font NODE_FONT = new Font("Arial Narrow", 0, 11);
    private static final Color[] AGENT_COLORS = new Color[]{Color.BLACK, new Color(160, 30, 35), new Color(30, 35, 140), new Color(40, 100, 25), new Color(105, 70, 30), new Color(90, 30, 115), new Color(178, 20, 180), new Color(24, 132, 132)};
    private static final int VER_SEPARATION = 100;
    private static final int HOR_SEPARATION = 200;
    private static final int NODE_WIDTH = 60;
    private static final int NODE_HEIGHT = 40;

    public PlanViewerImp() {
        this.pf = null;
        this.back = null;
        this.showEffs = false;
        this.showPrecs = false;
        this.initComponents();
    }

    private void initComponents() {
        this.scale = 1.0;
        this.selected = null;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.popUpMenu = new PopUpMenu();
        this.popUpMenu.itemCopy.addActionListener(this);
        this.popUpMenu.itemSave.addActionListener(this);
        this.popUpMenu.showEffs.addActionListener(this);
        this.popUpMenu.showPrecs.addActionListener(this);
    }

    public PlanViewerImp(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.initComponents();
    }

    public PlanViewerImp(LayoutManager layout) {
        super(layout);
        this.initComponents();
    }

    public PlanViewerImp(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.initComponents();
    }

    private int scale(int n) {
        return (int)(this.scale * (double)n);
    }

    private int unscale(int n) {
        return (int)((double)n / this.scale);
    }

    private void showOrderingInfo(Node nOrig, int adjIndex, boolean ordering) {
        String title = ordering ? "Ordering information" : "Causal link information";
        String s = nOrig.stepToString();
        s = ordering ? s + " --> " : s + " -- (" + nOrig.causalLink.get(adjIndex).toString() + ") -->";
        int stepIndex = nOrig.adjacents.get(adjIndex);
        s = s + this.g.v[stepIndex].stepToString();
        JOptionPane.showMessageDialog(this.getParent(), s, title, 1);
    }

    private double distanceToSegment(Point p, int x, int y, int xx, int yy) {
        double dist2;
        double dist1;
        double r_numerator = (p.x - x) * (xx - x) + (p.y - y) * (yy - y);
        double r_denomenator = (xx - x) * (xx - x) + (yy - y) * (yy - y);
        double r = r_numerator / r_denomenator;
        double s = (double)((y - p.y) * (xx - x) - (x - p.x) * (yy - y)) / r_denomenator;
        double distanceLine = Math.abs(s) * Math.sqrt(r_denomenator);
        double distanceSegment = r >= 0.0 && r <= 1.0 ? distanceLine : ((dist1 = (double)((p.x - x) * (p.x - x) + (p.y - y) * (p.y - y))) < (dist2 = (double)((p.x - xx) * (p.x - xx) + (p.y - yy) * (p.y - yy))) ? Math.sqrt(dist1) : Math.sqrt(dist2));
        return distanceSegment;
    }

    private void showNodeInfo(Node n) {
        Step a = n.step;
        String s = a.getIndex() + ": " + n.stepToString();
        s = s + "\nPrecs: ";
        Condition[] precs = a.getPrecs();
        for (int i = 0; i < precs.length; ++i) {
            if (i > 0) {
                s = s + ", ";
                if (i % 8 == 0) {
                    s = s + "\n\t";
                }
            }
            s = s + "(" + precs[i].labeled(this.pf) + ")";
        }
        s = s + "\nEffs: ";
        Condition[] effs = a.getEffs();
        for (int i = 0; i < effs.length; ++i) {
            if (i > 0) {
                s = s + ", ";
                if (i % 8 == 0) {
                    s = s + "\n\t";
                }
            }
            s = s + "(" + effs[i].labeled(this.pf) + ")";
        }
        JOptionPane.showMessageDialog(this.getParent(), s, "Step information", 1);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void showPlan(Plan plan, PlannerFactory pf) {
        this.plan = plan;
        this.pf = pf;
        this.scale = 1.0;
        this.selected = null;
        this.agentColor = new Hashtable(5);
        this.createGraph();
        this.height = 3 * (this.maxNodesPerLevel * 100) / 2;
        this.width = (this.maxLevels + 2) * 100;
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.back = new BufferedImage(this.width, this.height, 5);
        this.repaint();
        this.revalidate();
    }

    private void createGraph() {
        this.g = new Graph(this.plan);
        this.maxLevels = this.g.getNumLevels();
        this.levels = new ArrayList[this.maxLevels];
        this.maxNodesPerLevel = 0;
        for (int i = 0; i < this.maxLevels; ++i) {
            this.levels[i] = new ArrayList();
            this.g.addNodesAtLevel(this.maxLevels - i - 1, this.levels[i]);
            if (this.levels[i].size() <= this.maxNodesPerLevel) continue;
            this.maxNodesPerLevel = this.levels[i].size();
        }
        int height = this.maxNodesPerLevel * 100;
        int x = 100;
        for (int level = 0; level < this.maxLevels; ++level) {
            int numNodes = this.levels[level].size();
            int levelHeight = numNodes * 100;
            int y = (height - levelHeight) / 2 + 30;
            for (Node n : this.levels[level]) {
                n.x = x;
                n.y = y + (int)(Math.random() * 20.0 - 10.0);
                y += 100;
                String agent = n.step.getAgent();
                if (agent == null || this.agentColor.containsKey(agent)) continue;
                int cindex = this.agentColor.size() % AGENT_COLORS.length;
                this.agentColor.put(agent, AGENT_COLORS[cindex]);
            }
            x += 100;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.back != null) {
            this.draw(this.back.getGraphics());
            g.drawImage(this.back, 0, 0, null);
        }
    }

    private void draw(Graphics g) {
        int level;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, this.back.getWidth(), this.back.getHeight());
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Enumeration<String> ags = this.agentColor.keys();
        int x = 10;
        int y = 10;
        while (ags.hasMoreElements()) {
            String ag = ags.nextElement();
            Color c = this.agentColor.get(ag);
            g2d.setColor(c);
            g2d.fillRect(x, y, 10, 10);
            g2d.drawString(ag, x + 16, y + 8);
            y += 20;
        }
        g2d.setColor(Color.black);
        g2d.drawString("Makespan: " + (this.maxLevels - 2), x, y + 8);
        for (level = 0; level < this.maxLevels; ++level) {
            for (Node n : this.levels[level]) {
                for (int i = 0; i < n.adjacents.size(); ++i) {
                    int dn = n.adjacents.get(i);
                    boolean ordering = n.causalLink.get(i) == null;
                    this.drawArrow(g2d, n, this.g.v[dn], ordering);
                }
            }
        }
        for (level = 0; level < this.maxLevels; ++level) {
            for (Node n : this.levels[level]) {
                this.drawNode(g2d, n);
            }
        }
    }

    private void drawArrow(Graphics2D g2d, Node n, Node dn, boolean ordering) {
        if (ordering) {
            g2d.setColor(Color.LIGHT_GRAY);
        } else {
            g2d.setColor(Color.BLACK);
        }
        this.drawArrow(g2d, this.scale(n.x + 60), this.scale(n.y + 20), this.scale(dn.x), this.scale(dn.y + 20));
    }

    private void drawArrow(Graphics2D g, int x, int y, int xx, int yy) {
        float arrowWidth = 6.0f;
        float theta = 0.423f;
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        float[] vecLine = new float[2];
        float[] vecLeft = new float[2];
        xPoints[0] = xx;
        yPoints[0] = yy;
        vecLine[0] = (float)xPoints[0] - (float)x;
        vecLine[1] = (float)yPoints[0] - (float)y;
        vecLeft[0] = -vecLine[1];
        vecLeft[1] = vecLine[0];
        float fLength = (float)Math.sqrt(vecLine[0] * vecLine[0] + vecLine[1] * vecLine[1]);
        float th = arrowWidth / (2.0f * fLength);
        float ta = arrowWidth / (2.0f * ((float)Math.tan(theta) / 2.0f) * fLength);
        float baseX = (float)xPoints[0] - ta * vecLine[0];
        float baseY = (float)yPoints[0] - ta * vecLine[1];
        xPoints[1] = (int)(baseX + th * vecLeft[0]);
        yPoints[1] = (int)(baseY + th * vecLeft[1]);
        xPoints[2] = (int)(baseX - th * vecLeft[0]);
        yPoints[2] = (int)(baseY - th * vecLeft[1]);
        g.drawLine(x, y, (int)baseX, (int)baseY);
        g.fillPolygon(xPoints, yPoints, 3);
    }

    private void drawNode(Graphics2D g2d, Node n) {
        int x;
        int y;
        g2d.setFont(NODE_FONT);
        FontMetrics metrics = g2d.getFontMetrics(NODE_FONT);
        if (n.step == this.plan.getInitialStep()) {
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.fillOval(this.scale(n.x), this.scale(n.y), this.scale(60), this.scale(40));
            g2d.setColor(Color.BLACK);
            g2d.drawOval(this.scale(n.x), this.scale(n.y), this.scale(60), this.scale(40));
            g2d.drawOval(this.scale(n.x + 3), this.scale(n.y + 3), this.scale(54), this.scale(34));
            this.drawText(g2d, "0.Init", this.scale(n.x), this.scale(n.y), this.scale(60), this.scale(40), metrics);
        } else if (n.step == this.plan.getFinalStep()) {
            g2d.setColor(Color.WHITE);
            g2d.fillOval(this.scale(n.x), this.scale(n.y), this.scale(60), this.scale(40));
            g2d.setColor(Color.BLACK);
            g2d.drawOval(this.scale(n.x), this.scale(n.y), this.scale(60), this.scale(40));
            g2d.drawOval(this.scale(n.x + 3), this.scale(n.y + 3), this.scale(54), this.scale(34));
            this.drawText(g2d, "1.Goals", this.scale(n.x), this.scale(n.y), this.scale(60), this.scale(40), metrics);
        } else {
            Color c;
            g2d.setColor(Color.WHITE);
            g2d.fillOval(this.scale(n.x), this.scale(n.y), this.scale(60), this.scale(40));
            Color color = c = n.step.getAgent() != null ? this.agentColor.get(n.step.getAgent()) : Color.black;
            if (c == null) {
                c = Color.BLACK;
            }
            g2d.setColor(c);
            g2d.drawOval(this.scale(n.x), this.scale(n.y), this.scale(60), this.scale(40));
            String a = n.step != null ? n.step.getActionName() : "";
            this.drawText(g2d, n.step.getIndex() + "." + a, this.scale(n.x), this.scale(n.y), this.scale(60), this.scale(40), metrics);
        }
        if (this.showPrecs) {
            int incY = (int)((double)metrics.getHeight() * 0.9);
            int cx = this.scale(n.x) + this.scale(60) / 2;
            y = this.scale(n.y);
            for (Condition c : n.step.getPrecs()) {
                String p = c.toString();
                x = cx - metrics.stringWidth(p) / 2;
                g2d.drawString(p, x, y);
                y -= incY;
            }
        }
        if (this.showEffs) {
            int incY = (int)((double)metrics.getHeight() * 0.9);
            int cx = this.scale(n.x) + this.scale(60) / 2;
            y = this.scale(n.y) + this.scale(40) + incY;
            for (Condition ef : n.step.getEffs()) {
                String e = ef.toString();
                x = cx - metrics.stringWidth(e) / 2;
                g2d.drawString(e, x, y);
                y += incY;
            }
        }
    }

    private void drawText(Graphics2D g2d, String text, int x, int y, int width, int height, FontMetrics metrics) {
        int tw = metrics.stringWidth(text);
        int th = (int)((double)metrics.getHeight() * 0.9);
        if (tw > width) {
            String line2;
            String line1 = text;
            while (metrics.stringWidth(line1 = line1.substring(0, line1.length() - 1)) > width) {
            }
            int pos_spc = line1.lastIndexOf(32);
            if (pos_spc != -1) {
                line1 = line1.substring(0, pos_spc);
            }
            if (metrics.stringWidth(line2 = text.substring(line1.length()).trim()) > width) {
                while (metrics.stringWidth(line2 + "...") > width) {
                    line2 = line2.substring(0, line2.length() - 1);
                }
            }
            int posx = x + (width - metrics.stringWidth(line1)) / 2;
            int posy = y + height / 2;
            g2d.drawString(line1, posx, posy);
            posx = x + (width - metrics.stringWidth(line2)) / 2;
            g2d.drawString(line2, posx, posy + th);
        } else {
            int posx = x + (width - tw) / 2;
            int posy = y + height / 2 + th / 4;
            g2d.drawString(text, posx, posy);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.popUpMenu.itemCopy) {
            if (this.back == null) {
                return;
            }
            ImageSelection imageSelection = new ImageSelection(this.back);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageSelection, null);
        } else if (e.getSource() == this.popUpMenu.itemSave) {
            try {
                FileWriter outFile = new FileWriter("plan.txt");
                PrintWriter out = new PrintWriter(outFile);
                out.println(this.plan.numSteps());
                for (int i = 0; i < this.plan.numSteps(); ++i) {
                    Step s = this.plan.getStepsArray().get(i);
                    out.println(s.getActionName());
                    if (s == this.plan.getInitialStep() || s == this.plan.getFinalStep()) {
                        out.println("");
                    } else {
                        out.println(s.getAgent());
                    }
                    out.println(s.getPrecs().length);
                    for (Condition prec : s.getPrecs()) {
                        out.println(prec.toString());
                    }
                    out.println(s.getEffs().length);
                    for (Condition eff : s.getEffs()) {
                        out.println(eff.toString());
                    }
                }
                out.println(this.plan.getCausalLinksArray().size());
                for (CausalLink cl : this.plan.getCausalLinksArray()) {
                    out.println(cl.getIndex1());
                    out.println(cl.getIndex2());
                    out.println(cl.getCondition().toString());
                }
                out.println(this.plan.getOrderingsArray().size());
                for (Ordering o : this.plan.getOrderingsArray()) {
                    out.println(o.getIndex1());
                    out.println(o.getIndex2());
                }
                out.close();
            }
            catch (IOException iOException) {}
        } else if (e.getSource() == this.popUpMenu.showPrecs) {
            this.showPrecs = this.popUpMenu.showPrecs.isSelected();
            this.repaint();
        } else if (e.getSource() == this.popUpMenu.showEffs) {
            this.showEffs = this.popUpMenu.showEffs.isSelected();
            this.repaint();
        }
    }

    @Override
    public int getMakespan() {
        return this.maxLevels;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int m = e.getWheelRotation();
        if (m > 0 && this.scale < 4.0) {
            this.scale += 0.25;
        } else if (m < 0 && this.scale > 0.25) {
            this.scale -= 0.25;
        }
        int fs = this.scale <= 0.25 ? 8 : (this.scale <= 0.5 ? 9 : (this.scale <= 0.75 ? 10 : (this.scale <= 1.25 ? 11 : (this.scale <= 2.0 ? 12 : (this.scale <= 3.0 ? 14 : 16)))));
        NODE_FONT = new Font("Arial Narrow", 0, fs);
        this.setPreferredSize(new Dimension((int)((double)this.width * this.scale), (int)((double)this.height * this.scale)));
        this.back = new BufferedImage((int)((double)this.width * this.scale), (int)((double)this.height * this.scale), 5);
        this.repaint();
        this.revalidate();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.selected != null) {
            int incX = this.unscale(e.getX() - this.mouseX);
            int incY = this.unscale(e.getY() - this.mouseY);
            this.selected.x += incX;
            this.selected.y += incY;
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.selected = null;
        if (e.getButton() == 3) {
            this.popUpMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private Node selectedNode(Point p) {
        for (int level = 0; level < this.maxLevels; ++level) {
            for (Node n : this.levels[level]) {
                if (!n.contains(p)) continue;
                return n;
            }
        }
        return null;
    }

    private void showSelectedOrderings(Point p) {
        for (int level = 0; level < this.maxLevels; ++level) {
            for (Node n : this.levels[level]) {
                for (int i = 0; i < n.adjacents.size(); ++i) {
                    boolean ordering;
                    int dn = n.adjacents.get(i);
                    boolean bl = ordering = n.causalLink.get(i) == null;
                    if (!(this.distanceToSegment(p, n.x + 60, n.y + 20, this.g.v[dn].x, this.g.v[dn].y + 20) < 2.0)) continue;
                    this.showOrderingInfo(n, i, ordering);
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            Point p = new Point(this.unscale(this.mouseX), this.unscale(this.mouseY));
            if (e.getClickCount() == 1) {
                if (this.selected == null) {
                    this.selected = this.selectedNode(p);
                    if (this.selected == null) {
                        this.showSelectedOrderings(p);
                    }
                }
            } else {
                Node n = this.selectedNode(p);
                if (n != null) {
                    this.showNodeInfo(n);
                } else {
                    this.showSelectedOrderings(p);
                }
            }
        } else if (e.getButton() == 3) {
            this.popUpMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public static class ImageSelection
    implements Transferable {
        private final Image image;

        public ImageSelection(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }

    private class PopUpMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;
        JMenuItem itemCopy = new JMenuItem("Copy plan to clipboard");
        JMenuItem itemSave;
        JCheckBoxMenuItem showPrecs;
        JCheckBoxMenuItem showEffs;

        public PopUpMenu() {
            this.add(this.itemCopy);
            this.itemSave = new JMenuItem("Save plan to plan.txt");
            this.add(this.itemSave);
            this.addSeparator();
            this.showPrecs = new JCheckBoxMenuItem("Show preconditions");
            this.add(this.showPrecs);
            this.showEffs = new JCheckBoxMenuItem("Show effects");
            this.add(this.showEffs);
        }
    }

    private static class Graph {
        int numNodes;
        int numEdges;
        Node[] v;

        public Graph(Plan plan) {
            int j;
            int i;
            ArrayList<Step> planSteps = plan.getStepsArray();
            this.numNodes = planSteps.size();
            this.numEdges = 0;
            this.v = new Node[this.numNodes];
            for (int i2 = 0; i2 < this.v.length; ++i2) {
                this.v[i2] = new Node(planSteps.get(i2));
            }
            ArrayList<Ordering> orderings = plan.getOrderingsArray();
            for (Ordering po : orderings) {
                this.insertEdge(po.getIndex1(), po.getIndex2(), true, null);
            }
            ArrayList<CausalLink> causalLinks = plan.getCausalLinksArray();
            for (CausalLink cl : causalLinks) {
                this.insertEdge(cl.getIndex1(), cl.getIndex2(), false, cl.getCondition());
            }
            for (i = 1; i < this.v.length; ++i) {
                boolean hasPred = false;
                for (j = 0; j < this.v.length; ++j) {
                    if (!this.edgeExists(j, i)) continue;
                    hasPred = true;
                    break;
                }
                if (hasPred) continue;
                this.insertEdge(0, i, true, null);
            }
            for (i = 2; i < this.v.length; ++i) {
                boolean hasSuc = false;
                for (j = 2; j < this.v.length; ++j) {
                    if (!this.edgeExists(i, j)) continue;
                    hasSuc = true;
                    break;
                }
                if (hasSuc) continue;
                this.insertEdge(i, 1, true, null);
            }
            for (i = 0; i < this.v.length; ++i) {
                this.v[i].distanceToLast = this.maxPath(i, plan.getFinalStep().getIndex());
            }
        }

        private boolean edgeExists(int i, int j) {
            return this.v[i].adjacents.contains(j);
        }

        public final void insertEdge(int i, int j, boolean ordering, Condition cond) {
            if (!this.edgeExists(i, j)) {
                this.v[i].adjacents.add(j);
                this.v[i].causalLink.add(cond);
                ++this.numEdges;
            } else if (!ordering) {
                int index = this.v[i].adjacents.indexOf(j);
                this.v[i].causalLink.set(index, cond);
            }
        }

        public final int maxPath(int vOrigen, int vDestino) {
            int[] distanciaMax = new int[this.v.length];
            for (int i = 0; i < this.v.length; ++i) {
                distanciaMax[i] = -1;
            }
            distanciaMax[vOrigen] = 0;
            ArrayDeque<Integer> q = new ArrayDeque<Integer>();
            q.add(vOrigen);
            while (!q.isEmpty()) {
                int vActual = (Integer)q.poll();
                ArrayList<Integer> aux = this.v[vActual].adjacents;
                for (int i = 0; i < aux.size(); ++i) {
                    int vSiguiente = aux.get(i);
                    if (distanciaMax[vSiguiente] > distanciaMax[vActual]) continue;
                    distanciaMax[vSiguiente] = distanciaMax[vActual] + 1;
                    if (distanciaMax[vSiguiente] > this.v.length) {
                        System.out.println("Error: loop in the plan");
                        return this.v.length;
                    }
                    q.add(vSiguiente);
                }
            }
            return distanciaMax[vDestino];
        }

        public void addNodesAtLevel(int level, ArrayList<Node> list) {
            for (int i = 0; i < this.v.length; ++i) {
                if (this.v[i].distanceToLast != level) continue;
                list.add(this.v[i]);
            }
        }

        public int getNumLevels() {
            int n = -1;
            for (int i = 0; i < this.v.length; ++i) {
                if (this.v[i].distanceToLast <= n) continue;
                n = this.v[i].distanceToLast;
            }
            return n + 1;
        }
    }

    private static class Node {
        Step step;
        int distanceToLast;
        ArrayList<Integer> adjacents;
        ArrayList<Condition> causalLink;
        int x;
        int y;

        Node(Step ps) {
            this.step = ps;
            this.distanceToLast = -1;
            this.adjacents = new ArrayList();
            this.causalLink = new ArrayList();
        }

        public String stepToString() {
            if (this.step.getIndex() == 0) {
                return "Initial step";
            }
            if (this.step.getIndex() == 1) {
                return "Final step";
            }
            return this.step.getActionName();
        }

        boolean contains(Point p) {
            double xRadius = 30.0;
            double yRadius = 20.0;
            double xTar = (double)(p.x - this.x) - xRadius;
            double yTar = (double)(p.y - this.y) - yRadius;
            return Math.pow(xTar / xRadius, 2.0) + Math.pow(yTar / yRadius, 2.0) <= 1.0;
        }
    }
}

