/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import org.agreement_technologies.common.map_planner.CausalLink;
import org.agreement_technologies.common.map_planner.Condition;
import org.agreement_technologies.common.map_planner.OpenCondition;
import org.agreement_technologies.common.map_planner.Ordering;
import org.agreement_technologies.common.map_planner.PlannerFactory;
import org.agreement_technologies.common.map_planner.Step;
import org.agreement_technologies.service.map_planner.InternalProposal;
import org.agreement_technologies.service.map_planner.POPCondition;
import org.agreement_technologies.service.map_planner.POPIncrementalPlan;
import org.agreement_technologies.service.map_planner.PlannerFactoryImp;

public class ProposalToSend
implements Serializable {
    private static final long serialVersionUID = 6509357846584167L;
    private ArrayList<PCausalLink> causalLinks;
    private ArrayList<POrdering> orderings;
    private PStep step;
    private boolean isSolution;
    private boolean repeatedState;
    private int h;
    private int hLand;
    private BitSet achievedLandmarks;

    public ProposalToSend(InternalProposal prop, String ag, boolean repeated) {
        this.repeatedState = repeated;
        this.causalLinks = new ArrayList();
        this.orderings = new ArrayList();
        POPIncrementalPlan plan = (POPIncrementalPlan)prop.plan;
        for (CausalLink c : plan.getCausalLinks()) {
            this.causalLinks.add(new PCausalLink(c));
        }
        for (Ordering o : plan.getOrderings()) {
            this.orderings.add(new POrdering(o));
        }
        this.step = new PStep(plan.getStep());
        this.isSolution = plan.isSolution();
        this.h = plan.getH();
        this.hLand = plan.getHLan();
        this.achievedLandmarks = prop.achievedLandmarks;
    }

    public BitSet getAchievedLandmarks() {
        return this.achievedLandmarks;
    }

    public boolean isRepeated() {
        return this.repeatedState;
    }

    public Step getStep(PlannerFactoryImp configuration) {
        return this.step.toStep(configuration);
    }

    public ArrayList<Ordering> getOrderings(PlannerFactoryImp configuration) {
        ArrayList<Ordering> o = new ArrayList<Ordering>(this.orderings.size());
        for (POrdering po : this.orderings) {
            o.add(po.toOrdering(configuration));
        }
        return o;
    }

    public CausalLink[] getCausalLinks(PlannerFactoryImp configuration, POPIncrementalPlan basePlan, Step newStep, ArrayList<Ordering> orderings) {
        ArrayList<CausalLink> acl = new ArrayList<CausalLink>();
        for (PCausalLink pcl : this.causalLinks) {
            if (pcl == null) continue;
            CausalLink cl = pcl.toCausalLink(configuration, basePlan, newStep);
            if (cl != null) {
                acl.add(cl);
                continue;
            }
            orderings.add(configuration.createOrdering(pcl.step1, pcl.step2));
        }
        return acl.toArray(new CausalLink[acl.size()]);
    }

    public boolean isSolution() {
        return this.isSolution;
    }

    public int getH() {
        return this.h;
    }

    public int getHLand() {
        return this.hLand;
    }

    public static class PStep
    implements Serializable {
        private static final long serialVersionUID = 2695531841107912873L;
        private final int index;
        private String agent;
        private String actionName;
        PGroundedCond[] prec;
        PGroundedCond[] eff;

        public PStep(Step step) {
            if (step != null) {
                this.index = step.getIndex();
                this.agent = step.getAgent();
                this.actionName = step.getActionName();
                ArrayList<PGroundedCond> aPrecs = new ArrayList<PGroundedCond>();
                for (Condition cond : step.getPrecs()) {
                    aPrecs.add(new PGroundedCond(cond));
                }
                ArrayList<PGroundedCond> aEffs = new ArrayList<PGroundedCond>();
                for (Condition eff : step.getEffs()) {
                    aEffs.add(new PGroundedCond(eff));
                }
                this.prec = aPrecs.toArray(new PGroundedCond[aPrecs.size()]);
                this.eff = aEffs.toArray(new PGroundedCond[aEffs.size()]);
            } else {
                this.index = -1;
            }
        }

        public Step toStep(PlannerFactoryImp pf) {
            int i;
            if (this.index == -1) {
                return null;
            }
            ArrayList<Condition> sPrec = new ArrayList<Condition>(this.prec.length);
            ArrayList<Condition> sEff = new ArrayList<Condition>(this.eff.length);
            for (i = 0; i < this.prec.length; ++i) {
                sPrec.add(this.prec[i].toCondition());
            }
            for (i = 0; i < this.eff.length; ++i) {
                sEff.add(this.eff[i].toCondition());
            }
            return pf.createStep(this.index, this.agent, this.actionName, sPrec.toArray(new Condition[sPrec.size()]), sEff.toArray(new Condition[sEff.size()]));
        }
    }

    public static class POrdering
    implements Serializable {
        private static final long serialVersionUID = 4213546490197217271L;
        private final int step1;
        private final int step2;

        public POrdering(CausalLink c) {
            this.step1 = c.getIndex1();
            this.step2 = c.getIndex2();
        }

        public Ordering toOrdering(PlannerFactory pf) {
            return pf.createOrdering(this.step1, this.step2);
        }

        public POrdering(Ordering o) {
            this.step1 = o.getIndex1();
            this.step2 = o.getIndex2();
        }

        public boolean equals(Object x) {
            POrdering po = (POrdering)x;
            return this.step1 == po.step1 && this.step2 == po.step2;
        }
    }

    public static class PCausalLink
    implements Serializable {
        private static final long serialVersionUID = -7424617979375788553L;
        private int step1;
        private int step2;
        private PGroundedCond cond;

        public PCausalLink(CausalLink c) {
            this.step1 = c.getIndex1();
            this.step2 = c.getIndex2();
            this.cond = new PGroundedCond(c.getCondition());
        }

        public Ordering toOrdering(PlannerFactory pf) {
            return pf.createOrdering(this.step1, this.step2);
        }

        public CausalLink toCausalLink(PlannerFactoryImp pf, POPIncrementalPlan basePlan, Step newStep) {
            Condition gc = this.cond.toCondition();
            Step s1 = this.step1 == 0 ? basePlan.getInitialStep() : PCausalLink.findStep(this.step1, basePlan);
            Step s2 = newStep != null ? newStep : basePlan.getFinalStep();
            return pf.createCausalLink(gc, s1, s2);
        }

        private static Step findStep(int s, POPIncrementalPlan basePlan) {
            if (basePlan.getStep().getIndex() == s) {
                return basePlan.getStep();
            }
            return PCausalLink.findStep(s, basePlan.getFather());
        }
    }

    public static class POpenCondition
    implements Serializable {
        private static final long serialVersionUID = 7396924233555014626L;
        private int stepIndex;
        private PGroundedCond cond;

        public POpenCondition(OpenCondition oc) {
            this.stepIndex = oc.getStep().getIndex();
            this.cond = new PGroundedCond(oc.getCondition());
        }

        public String toString() {
            return "[" + this.stepIndex + "] " + this.cond;
        }
    }

    public static class PGroundedCond
    implements Serializable {
        private static final long serialVersionUID = -425234291857601218L;
        private int var;
        private int value;
        private int condition;

        public PGroundedCond(Condition cond) {
            this.var = cond.getVarCode();
            this.value = cond.getValueCode();
            this.condition = cond.getType();
        }

        public Condition toCondition() {
            return new POPCondition(this.condition, this.var, this.value);
        }

        public String toString() {
            String res = this.condition == 1 ? "=" : "<>";
            return this.var + res + this.value;
        }
    }
}

