/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.util.ArrayList;
import java.util.Hashtable;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_communication.Message;
import org.agreement_technologies.common.map_communication.MessageFilter;
import org.agreement_technologies.common.map_communication.PlanningAgentListener;
import org.agreement_technologies.common.map_heuristic.Heuristic;
import org.agreement_technologies.common.map_negotiation.PlanSelection;
import org.agreement_technologies.common.map_planner.CausalLink;
import org.agreement_technologies.common.map_planner.Condition;
import org.agreement_technologies.common.map_planner.ExtendedPlanner;
import org.agreement_technologies.common.map_planner.IPlan;
import org.agreement_technologies.common.map_planner.OpenCondition;
import org.agreement_technologies.common.map_planner.Ordering;
import org.agreement_technologies.common.map_planner.POPSearchMethod;
import org.agreement_technologies.common.map_planner.Plan;
import org.agreement_technologies.common.map_planner.Step;
import org.agreement_technologies.service.map_planner.HeuristicAdjustment;
import org.agreement_technologies.service.map_planner.InternalProposal;
import org.agreement_technologies.service.map_planner.MetricChecker;
import org.agreement_technologies.service.map_planner.NewBasePlanMessage;
import org.agreement_technologies.service.map_planner.OrderingManager;
import org.agreement_technologies.service.map_planner.POPAction;
import org.agreement_technologies.service.map_planner.POPCausalLink;
import org.agreement_technologies.service.map_planner.POPIncrementalPlan;
import org.agreement_technologies.service.map_planner.POPInternalPlan;
import org.agreement_technologies.service.map_planner.POPInternalSearchTree;
import org.agreement_technologies.service.map_planner.POPOpenCondition;
import org.agreement_technologies.service.map_planner.POPOrdering;
import org.agreement_technologies.service.map_planner.POPPrecEff;
import org.agreement_technologies.service.map_planner.POPStep;
import org.agreement_technologies.service.map_planner.POPThreat;
import org.agreement_technologies.service.map_planner.PlannerFactoryImp;
import org.agreement_technologies.service.map_planner.ProposalToSend;
import org.agreement_technologies.service.map_planner.SolutionChecker;
import org.agreement_technologies.service.map_planner.StateMemoization;
import org.agreement_technologies.service.tools.CustomArrayList;

public abstract class Planner
implements ExtendedPlanner {
    static final int EQUAL = 1;
    static final int DISTINCT = 2;
    static final int NO_TIMEOUT = -1;
    static final int IDA_SEARCH = 1;
    static final int A_SEARCH = 2;
    protected POPIncrementalPlan basePlan;
    protected PlannerFactoryImp configuration;
    protected Heuristic heuristic;
    protected AgentCommunication comm;
    protected StateMemoization memoization;
    protected POPInternalSearchTree internalSearchTree;
    protected POPSearchMethod searchTree;
    protected SolutionChecker solutionChecker;
    protected PlanSelection planSelection;
    protected ArrayList<POPInternalPlan> successors;
    protected String myAgent;
    protected POPInternalPlan currentInternal;
    protected POPIncrementalPlan initialIncrementalPlan;
    protected POPInternalPlan initialInternalPlan;
    protected int expandedNodes;
    protected PlanningAgentListener agentListener;
    protected OrderingManager matrix;
    protected Hashtable<Integer, Integer> lastValues;
    protected Hashtable<String, Boolean> hashEffects;
    protected Step initialStep;
    protected Step finalStep;
    protected POPIncrementalPlan[] antecessors;
    protected ArrayList<OpenCondition> openConditions;
    protected CustomArrayList<CausalLink> totalCausalLinks;
    protected int numCausalLinks;
    protected boolean modifiedCausalLinks;
    protected CustomArrayList<Ordering> totalOrderings;
    protected int numOrderings;
    protected boolean modifiedOrderings;
    protected int planningStep;
    protected long planTime = 0L;
    protected long evaluationTime = 0L;
    protected long communicationTime = 0L;
    protected ExtendedPlanner parent;
    protected ArrayList<ArrayList<ProposalToSend>> proposalsToSend;
    protected MessageFilterProposals proposalsFilter;
    protected MessageFilterAdjustment adjustmentFilter;
    private int discarded;
    private Hashtable<Integer, Boolean> hazardousVars;
    private HeuristicAdjustment hAdjustment;
    private NewBasePlanMessage newBasePlanMsg;
    private final ArrayList<InternalProposal> allProposals;

    public Planner(AgentCommunication comm) {
        this.comm = comm;
        this.proposalsToSend = new ArrayList(comm.getOtherAgents().size());
        for (int i = 0; i < comm.getOtherAgents().size(); ++i) {
            this.proposalsToSend.add(new ArrayList());
        }
        this.proposalsFilter = new MessageFilterProposals();
        this.adjustmentFilter = new MessageFilterAdjustment();
        this.newBasePlanMsg = new NewBasePlanMessage();
        this.allProposals = new ArrayList();
    }

    @Override
    public POPIncrementalPlan[] getAntecessors() {
        return this.antecessors;
    }

    @Override
    public CustomArrayList<CausalLink> getTotalCausalLinks() {
        return this.totalCausalLinks;
    }

    @Override
    public CustomArrayList<Ordering> getTotalOrderings() {
        return this.totalOrderings;
    }

    @Override
    public Step getInitialStep() {
        return this.initialStep;
    }

    @Override
    public Step getFinalStep() {
        return this.finalStep;
    }

    @Override
    public void setNumCausalLinks(int n) {
        this.numCausalLinks = n;
    }

    @Override
    public void setModifiedCausalLinks(boolean m) {
        this.modifiedCausalLinks = m;
    }

    @Override
    public int getNumCausalLinks() {
        return this.numCausalLinks;
    }

    @Override
    public boolean getModifiedCausalLinks() {
        return this.modifiedCausalLinks;
    }

    @Override
    public void setNumOrderings(int n) {
        this.numOrderings = n;
    }

    @Override
    public void setModifiedOrderings(boolean m) {
        this.modifiedOrderings = m;
    }

    @Override
    public boolean getModifiedOrderings() {
        return this.modifiedOrderings;
    }

    @Override
    public void addCausalLink(CausalLink cl) {
        this.getTotalCausalLinks().add(cl);
        if (!this.getModifiedCausalLinks()) {
            this.setModifiedCausalLinks(true);
        }
    }

    @Override
    public void addOrdering(Ordering cl) {
        this.totalOrderings.add(cl);
        if (!this.modifiedOrderings) {
            this.modifiedOrderings = true;
        }
    }

    @Override
    public int getIterations() {
        return this.planningStep;
    }

    @Override
    public Plan computePlan(long start) {
        this.planningStep = 1;
        Plan solution = null;
        int solutions = 0;
        MetricChecker metricChecker = new MetricChecker(this.comm);
        if (this.planningStep == 1) {
            this.discarded = 0;
        }
        this.openConditions = new ArrayList();
        for (OpenCondition oc : this.initialInternalPlan.getPreconditions()) {
            this.openConditions.add(oc);
        }
        this.basePlan = (POPIncrementalPlan)this.searchTree.checkNextPlan();
        if (this.solutionChecker.isSolution(this.basePlan, this.configuration).booleanValue()) {
            if (this.agentListener != null) {
                this.agentListener.trace(1, "Solution found");
            }
            return this.basePlan;
        }
        if (this.agentListener != null) {
            this.agentListener.newPlan(this.searchTree.checkNextPlan(), this.configuration);
        }
        boolean adjustHLandStage = this.heuristic.requiresHLandStage();
        while (solution == null) {
            if (this.agentListener != null) {
                this.agentListener.trace(0, "Planning step: " + this.planningStep);
            }
            long t1 = System.currentTimeMillis();
            this.basePlan = this.selectNextPlan(adjustHLandStage);
            this.communicationTime += System.currentTimeMillis() - t1;
            if (this.basePlan == null) break;
            if (this.agentListener != null) {
                this.agentListener.trace(1, "Plan " + this.basePlan.getName() + " (h=" + this.basePlan.getH() + ", hL=" + this.basePlan.getHLan() + ") selected");
            } else if (this.comm.batonAgent()) {
                System.out.println("; Hdtg = " + this.basePlan.getH() + ", Hlan = " + this.basePlan.getHLan());
            }
            this.setAntecessors(this.basePlan);
            this.initialInternalPlan.setNumSteps(this.antecessors.length);
            this.basePlan.calculateCausalLinks();
            this.basePlan.calculateOrderings();
            t1 = System.currentTimeMillis();
            ArrayList<IPlan> proposals = this.computeSuccessors(this.initialInternalPlan);
            this.planTime += System.currentTimeMillis() - t1;
            solution = this.sendProposals(proposals, this.basePlan, adjustHLandStage);
            ++this.planningStep;
            if (solution != null && !this.solutionChecker.isSolution((POPIncrementalPlan)solution, this.configuration).booleanValue()) {
                solution = null;
            }
            if (this.agentListener == null || solution == null) continue;
            if (metricChecker.isBestSolution(solution, this.configuration.getNegotiationFactory().getNegotiationType())) {
                this.printStatistics(solution, metricChecker);
            }
            ++solutions;
        }
        if (this.comm.getAgentIndex(this.myAgent) == 1) {
            System.out.println("\n; Solution plan - CoDMAP Distributed format");
            System.out.println("; -----------------------------------------");
            for (int i = 0; i < this.comm.getAgentList().size(); ++i) {
                solution.printPlan(2, this.comm.getAgentList().get(i), this.comm.getAgentList());
            }
        }
        return solution;
    }

    private POPIncrementalPlan selectNextPlan(boolean adjustHLandStage) {
        POPIncrementalPlan plan;
        if (this.comm.numAgents() == 1) {
            return (POPIncrementalPlan)this.searchTree.getNextPlan();
        }
        if (this.comm.batonAgent()) {
            if (!adjustHLandStage) {
                for (InternalProposal p : this.allProposals) {
                    if (p.plan.isSolution()) continue;
                    this.searchTree.addPlan(p.plan);
                }
            }
            if ((plan = (POPIncrementalPlan)this.searchTree.getNextPlan()) != null) {
                this.newBasePlanMsg.setName(plan.getName());
            } else {
                this.newBasePlanMsg.setName("<NOPLAN>");
            }
            this.comm.sendMessage(this.newBasePlanMsg, true);
        } else {
            this.newBasePlanMsg = (NewBasePlanMessage)this.comm.receiveMessage(this.comm.getBatonAgent(), true);
            this.storeAndAdjustProposals();
            String planName = this.newBasePlanMsg.getPlanName();
            plan = planName.equals("<NOPLAN>") ? null : (POPIncrementalPlan)this.searchTree.removePlan(planName);
        }
        this.newBasePlanMsg.Clear();
        this.allProposals.clear();
        return plan;
    }

    private void storeAndAdjustProposals() {
        block0: for (NewBasePlanMessage.HeuristicChange change : this.newBasePlanMsg.getChanges()) {
            String planName = change.getName();
            for (InternalProposal p : this.allProposals) {
                if (!p.plan.getName().equals(planName)) continue;
                p.plan.setH(p.plan.getH(), p.plan.getHLan() - change.getIncH());
                continue block0;
            }
        }
        for (InternalProposal p : this.allProposals) {
            if (p.plan.isSolution()) continue;
            this.searchTree.addPlan(p.plan);
        }
    }

    private void printStatistics(Plan solution, MetricChecker mc) {
        this.agentListener.trace(1, "Solution found: " + solution.getName());
        this.agentListener.trace(0, String.format("Planning (expansion) time: %.3f sec.", (double)this.planTime / 1000.0));
        this.agentListener.trace(0, String.format("Evaluation time: %.3f sec.", (double)this.evaluationTime / 1000.0));
        this.agentListener.trace(0, String.format("Communication time: %.3f sec.", (double)this.communicationTime / 1000.0));
        this.agentListener.trace(0, String.format("Average branching factor: %.3f", (double)(this.searchTree.size() + this.planningStep) / (double)this.planningStep));
        if (this.configuration.getNegotiationFactory().getNegotiationType() != 0) {
            this.agentListener.trace(0, String.format("Metric value: %.1f", this.evaluateMetric((POPIncrementalPlan)solution)));
            this.agentListener.trace(0, String.format("Average metric value: %.1f", mc.getBestMetric()));
        }
        this.agentListener.trace(0, String.format("Discarded plans: %d", this.discarded));
        this.calculateTimeSteps(solution);
    }

    public double evaluateMetric(POPIncrementalPlan plan) {
        double makespan = this.configuration.getGroundedTask().metricRequiresMakespan() ? plan.computeMakespan() : 0.0;
        if (plan.isSolution()) {
            return this.configuration.getGroundedTask().evaluateMetric(plan.computeState(plan.getFather().linearization(), this.configuration), makespan);
        }
        return this.configuration.getGroundedTask().evaluateMetric(plan.computeState(plan.linearization(), this.configuration), makespan);
    }

    public void setAntecessors(POPIncrementalPlan nextPlan) {
        int offset = 1;
        if (nextPlan.isRoot()) {
            this.antecessors = new POPIncrementalPlan[1];
        } else if (nextPlan.isSolution()) {
            --offset;
            this.antecessors = nextPlan.getStep().getIndex() == 1 ? new POPIncrementalPlan[nextPlan.getFather().getStep().getIndex() + 1] : new POPIncrementalPlan[nextPlan.getStep().getIndex() + 1];
        } else {
            this.antecessors = new POPIncrementalPlan[nextPlan.getStep().getIndex()];
        }
        POPIncrementalPlan aux = nextPlan;
        int pos = this.antecessors.length - 1;
        while (!aux.isRoot()) {
            if (aux.getStep().getIndex() == 1) {
                this.antecessors[pos] = aux;
                ++offset;
                aux = aux.getFather();
                continue;
            }
            this.antecessors[aux.getStep().getIndex() - offset] = aux;
            pos = aux.getStep().getIndex() - 1;
            aux = aux.getFather();
        }
        this.antecessors[0] = aux;
    }

    public abstract IPlan sendProposalsMonoagent(ArrayList<IPlan> var1, IPlan var2);

    public abstract ArrayList<IPlan> POPForwardLoop();

    public abstract void evaluatePlan(IPlan var1, ArrayList<EvaluationThread> var2);

    protected ArrayList<IPlan> computeSuccessors(POPInternalPlan basePlan) {
        this.currentInternal = basePlan;
        this.internalSearchTree = new POPInternalSearchTree(this.initialInternalPlan);
        ArrayList<IPlan> solutions = this.addFinalStep();
        ArrayList<IPlan> plans = null;
        if (solutions == null) {
            plans = this.POPForwardLoop();
        }
        if (solutions != null) {
            if (plans != null) {
                for (IPlan p : solutions) {
                    plans.add(p);
                }
            } else {
                plans = solutions;
            }
        }
        for (IPlan p : plans) {
            p.setG(p.numSteps());
        }
        return plans;
    }

    protected IPlan sendProposals(ArrayList<IPlan> prop, IPlan basePlan, boolean adjustHLandStage) {
        if (this.comm.numAgents() == 1) {
            return this.sendProposalsMonoagent(prop, basePlan);
        }
        ArrayList<InternalProposal> ownProposals = new ArrayList<InternalProposal>();
        for (IPlan p : prop) {
            if (this.memoization.search((POPIncrementalPlan)p) == null) {
                if (!p.isSolution()) {
                    this.memoization.add((POPIncrementalPlan)p);
                }
                ownProposals.add(new InternalProposal(p));
                continue;
            }
            ++this.discarded;
        }
        long t2 = System.currentTimeMillis();
        this.evaluateProposals(ownProposals, basePlan, adjustHLandStage);
        this.evaluationTime += System.currentTimeMillis() - t2;
        long t3 = System.currentTimeMillis();
        IPlan solution = this.communicateProposals(ownProposals, adjustHLandStage);
        this.communicationTime += System.currentTimeMillis() - t3;
        return solution;
    }

    protected void evaluatePrivateGoals(ArrayList<IPlan> allProposals, IPlan basePlan) {
        this.heuristic.startEvaluation(basePlan);
        for (IPlan p : allProposals) {
            this.heuristic.evaluatePlanPrivacy(p, 0);
        }
        this.heuristic.waitEndEvaluation();
    }

    protected void evaluateProposals(ArrayList<InternalProposal> proposals, IPlan basePlan, boolean adjustHLandStage) {
        this.heuristic.startEvaluation(basePlan);
        if (adjustHLandStage) {
            ArrayList<Integer> achievedLandmarks = new ArrayList<Integer>();
            for (InternalProposal p : proposals) {
                this.heuristic.evaluatePlan(p.plan, 0, achievedLandmarks);
                p.setAchievedLandmarks(achievedLandmarks, this.heuristic.numGlobalLandmarks());
                achievedLandmarks.clear();
            }
        } else {
            for (InternalProposal p : proposals) {
                this.heuristic.evaluatePlan(p.plan, 0);
            }
        }
        this.heuristic.waitEndEvaluation();
    }

    protected IPlan communicateProposals(ArrayList<InternalProposal> ownProposals, boolean adjustHLandStage) {
        IPlan solution;
        this.prepareProposalsToSend(ownProposals);
        if (!adjustHLandStage) {
            int propCount = 0;
            for (String ag : this.comm.getOtherAgents()) {
                this.comm.sendMessage(ag, this.proposalsToSend.get(propCount++), false);
            }
            solution = this.receiveProposals(ownProposals);
        } else {
            int propCount = 0;
            int batonAgentIndex = 0;
            for (String ag : this.comm.getOtherAgents()) {
                if (!ag.equals(this.comm.getBatonAgent())) {
                    this.comm.sendMessage(ag, this.proposalsToSend.get(propCount), false);
                } else {
                    batonAgentIndex = propCount;
                }
                ++propCount;
            }
            solution = this.adjustAndReceiveProposals(ownProposals, batonAgentIndex);
        }
        return solution;
    }

    private IPlan adjustAndReceiveProposals(ArrayList<InternalProposal> ownProposals, int batonAgentIndex) {
        IPlan solution;
        if (!this.comm.batonAgent()) {
            solution = this.receiveProposals(ownProposals);
            this.adjustHeuristic(this.allProposals);
            this.hAdjustment.addOwnProposals(this.proposalsToSend.get(batonAgentIndex));
            this.comm.sendMessage(this.comm.getBatonAgent(), this.hAdjustment, false);
        } else {
            solution = this.receiveHeuristicAdjustments(ownProposals);
        }
        return solution;
    }

    private IPlan receiveHeuristicAdjustments(ArrayList<InternalProposal> ownProposals) {
        IPlan solution = null;
        this.hAdjustment = new HeuristicAdjustment(1 + ownProposals.size() * this.comm.numAgents());
        int index = 0;
        for (String ag : this.comm.getAgentList()) {
            if (ag.equals(this.comm.getThisAgentName())) {
                for (InternalProposal p : ownProposals) {
                    p.plan.setName(index++, this.basePlan);
                    this.allProposals.add(p);
                    if (p.plan.isSolution()) {
                        solution = p.plan;
                    } else {
                        this.memoization.add((POPIncrementalPlan)p.plan);
                    }
                    if (this.agentListener == null) continue;
                    this.agentListener.trace(2, "Sending plan " + p.plan.getName() + "[" + p.plan.getH() + "]");
                    this.agentListener.newPlan(p.plan, this.configuration);
                }
                continue;
            }
            this.adjustmentFilter.fromAgent = ag;
            HeuristicAdjustment h = (HeuristicAdjustment)this.comm.receiveMessage(this.adjustmentFilter, false);
            for (ProposalToSend prop : h.getProposals()) {
                POPIncrementalPlan p = new POPIncrementalPlan(prop, this.basePlan, this.configuration, this);
                p.setName(index++, this.basePlan);
                String planName = p.getName();
                InternalProposal proposal = new InternalProposal(p, prop.getAchievedLandmarks());
                ArrayList<Integer> newLand = this.heuristic.checkNewLandmarks(proposal.plan, proposal.achievedLandmarks);
                this.hAdjustment.merge(planName, newLand);
                this.allProposals.add(proposal);
                if (p.isSolution()) {
                    solution = p;
                } else {
                    this.memoization.add(p);
                }
                if (this.agentListener == null) continue;
                this.agentListener.trace(2, "Received plan " + planName + " from " + ag + "[" + p.getH() + "]");
                this.agentListener.newPlan(p, this.configuration);
            }
            ArrayList<String> planNames = h.proposalsWithAdjustments();
            for (String planName : planNames) {
                this.hAdjustment.merge(planName, h.getNewLandmarks(planName));
            }
        }
        this.updateHLandValues();
        return solution;
    }

    private void updateHLandValues() {
        for (InternalProposal p : this.allProposals) {
            IPlan plan = p.plan;
            String planName = plan.getName();
            int incH = this.hAdjustment.getNumNewLandmarks(planName);
            if (incH > 0) {
                this.newBasePlanMsg.addAdjustment(planName, incH);
                plan.setH(plan.getH(), plan.getHLan() - incH);
            }
            if (plan.isSolution()) continue;
            this.searchTree.addPlan(plan);
        }
    }

    private void adjustHeuristic(ArrayList<InternalProposal> proposals) {
        this.hAdjustment = new HeuristicAdjustment(proposals.size());
        for (InternalProposal prop : proposals) {
            IPlan plan = prop.plan;
            String fromAgent = plan.lastAddedStep().getAgent();
            if (fromAgent == null || this.comm.getThisAgentName().equals(fromAgent)) continue;
            ArrayList<Integer> newLandmarks = this.heuristic.checkNewLandmarks(plan, prop.achievedLandmarks);
            this.hAdjustment.add(plan.getName(), newLandmarks);
        }
    }

    private IPlan receiveProposals(ArrayList<InternalProposal> ownProposals) {
        IPlan solution = null;
        int index = 0;
        for (String ag : this.comm.getAgentList()) {
            if (ag.equals(this.comm.getThisAgentName())) {
                for (InternalProposal p : ownProposals) {
                    p.plan.setName(index++, this.basePlan);
                    this.allProposals.add(p);
                    if (p.plan.isSolution()) {
                        solution = p.plan;
                    } else {
                        this.memoization.add((POPIncrementalPlan)p.plan);
                    }
                    if (this.agentListener == null) continue;
                    this.agentListener.trace(2, "Sending plan " + p.plan.getName() + "[" + p.plan.getH() + "]");
                    this.agentListener.newPlan(p.plan, this.configuration);
                }
                continue;
            }
            this.proposalsFilter.fromAgent = ag;
            ArrayList pp = (ArrayList)this.comm.receiveMessage(this.proposalsFilter, false);
            for (ProposalToSend prop : pp) {
                POPIncrementalPlan p = new POPIncrementalPlan(prop, this.basePlan, this.configuration, this);
                p.setName(index++, this.basePlan);
                this.allProposals.add(new InternalProposal(p, prop.getAchievedLandmarks()));
                if (p.isSolution()) {
                    solution = p;
                } else {
                    this.memoization.add(p);
                }
                if (this.agentListener == null) continue;
                this.agentListener.trace(2, "Received plan " + p.getName() + " from " + ag + "[" + p.getH() + "]");
                this.agentListener.newPlan(p, this.configuration);
            }
        }
        return solution;
    }

    private void prepareProposalsToSend(ArrayList<InternalProposal> proposals) {
        for (int i = 0; i < this.comm.getOtherAgents().size(); ++i) {
            this.proposalsToSend.get(i).clear();
        }
        for (InternalProposal prop : proposals) {
            int propCount = 0;
            for (String ag : this.comm.getOtherAgents()) {
                ProposalToSend pp = new ProposalToSend(prop, ag, false);
                this.proposalsToSend.get(propCount).add(pp);
                ++propCount;
            }
        }
    }

    protected void calculateTimeSteps(Plan solution) {
        ArrayList<Ordering> ord = solution.getOrderingsArray();
        ArrayList<CausalLink> cl = solution.getCausalLinksArray();
        Hashtable<Integer, Integer> stepsFound = new Hashtable<Integer, Integer>();
        boolean moreFound = true;
        int timeStep = 0;
        while (moreFound) {
            moreFound = false;
            for (int i = 2; i < solution.getStepsArray().size(); ++i) {
                if (solution.getStepsArray().get(i).getTimeStep() != -1) continue;
                boolean found = true;
                for (Ordering o : ord) {
                    if (o.getIndex2() != i || stepsFound.get(o.getIndex1()) != null && (Integer)stepsFound.get(o.getIndex1()) != timeStep) continue;
                    found = false;
                    break;
                }
                if (found) {
                    for (CausalLink c : cl) {
                        if (c.getIndex1() == 0 || c.getIndex2() == 1 || c.getIndex2() != i || stepsFound.get(c.getIndex1()) != null && (Integer)stepsFound.get(c.getIndex1()) != timeStep) continue;
                        found = false;
                        break;
                    }
                }
                if (!found) continue;
                moreFound = true;
                stepsFound.put(i, timeStep);
                solution.getStepsArray().get(i).setTimeStep(timeStep);
            }
            ++timeStep;
        }
    }

    protected ArrayList<POPAction> calculateApplicableActions_old() {
        ArrayList<POPAction> applicableActions = new ArrayList<POPAction>();
        for (POPAction pa : this.configuration.getActions()) {
            if (!this.isApplicable(this.currentInternal, pa).booleanValue()) continue;
            if (this.isHazardous(pa)) {
                applicableActions.add(pa);
                continue;
            }
            if (this.memoization.search(this.basePlan, pa) != null) continue;
            applicableActions.add(pa);
        }
        this.agentListener.trace(1, "Agent " + this.comm.getThisAgentName() + " found " + applicableActions.size() + " applicable actions");
        return applicableActions;
    }

    protected ArrayList<POPAction> calculateApplicableActions() {
        ArrayList<POPAction> applicableActions = new ArrayList<POPAction>();
        this.calculateEffectsLastValues(this.currentInternal);
        for (POPAction pa : this.configuration.getActions()) {
            if (!this.isActionSupportable(this.currentInternal, pa).booleanValue() || this.memoization.search(this.basePlan, pa) != null) continue;
            applicableActions.add(pa);
        }
        if (this.agentListener != null) {
            this.agentListener.trace(1, "Agent " + this.comm.getThisAgentName() + " found " + applicableActions.size() + " applicable actions");
        }
        return applicableActions;
    }

    public Boolean isActionSupportable(POPInternalPlan p, POPAction a) {
        for (int i = 0; i < a.getPrecs().size(); ++i) {
            Integer value;
            POPPrecEff prec = a.getPrecs().get(i);
            if (!(a.hasEffectInVariable(i) ? (value = this.lastValues.get(prec.getVarCode())) != null && value.intValue() != prec.getValueCode() : this.hashEffects.get(prec.toKey()) == null)) continue;
            return false;
        }
        return true;
    }

    public void calculateEffectsLastValues(POPInternalPlan p) {
        int[] linearization = this.basePlan.linearization();
        this.hashEffects = new Hashtable();
        this.lastValues = new Hashtable();
        for (int i = linearization.length - 1; i >= 0; --i) {
            int index = linearization[i];
            if (index == 1) continue;
            POPStep ps = (POPStep)p.getStep(index);
            for (POPPrecEff eff : ps.getEffects()) {
                this.hashEffects.put(eff.toKey(), true);
                if (this.lastValues.get(eff.getVarCode()) != null) continue;
                this.lastValues.put(eff.getVarCode(), eff.getValueCode());
            }
        }
    }

    public boolean isHazardous(POPAction a) {
        for (POPPrecEff eff : a.getEffects()) {
            if (this.hazardousVars.get(eff.getVarCode()) == null) continue;
            return true;
        }
        return false;
    }

    public Boolean isApplicable(POPInternalPlan p, POPAction a) {
        if (this.hashEffects == null) {
            this.hashEffects = new Hashtable();
            this.hazardousVars = new Hashtable();
            for (int i = 0; i < p.numSteps(); ++i) {
                POPStep ps = (POPStep)p.getStep(i);
                if (ps.getIndex() == 1) continue;
                for (POPPrecEff eff : ps.getEffects()) {
                    this.hashEffects.put(eff.toKey(), Boolean.TRUE);
                    if (ps.getIndex() == 0) continue;
                    Boolean found = false;
                    for (POPPrecEff pre : ps.getPreconditions()) {
                        if (pre.getVarCode() != eff.getVarCode()) continue;
                        found = true;
                        break;
                    }
                    if (found.booleanValue()) continue;
                    this.hazardousVars.put(eff.getVarCode(), Boolean.TRUE);
                }
            }
        }
        for (POPPrecEff prec : a.getPrecs()) {
            if (this.hashEffects.get(prec.toKey()) != null) continue;
            return false;
        }
        return true;
    }

    public void restoreCausalLinks() {
        this.getTotalCausalLinks().trimToSize(this.getNumCausalLinks());
        this.setModifiedCausalLinks(false);
    }

    public void restoreOrderings() {
        this.totalOrderings.trimToSize(this.numOrderings);
        this.modifiedOrderings = false;
    }

    protected ArrayList<IPlan> solveAction(POPStep step) {
        ArrayList<IPlan> refinements = new ArrayList<IPlan>();
        this.successors.clear();
        while (!this.internalSearchTree.isEmpty()) {
            ++this.expandedNodes;
            this.restoreCausalLinks();
            this.restoreOrderings();
            this.currentInternal = this.internalSearchTree.getNextPlan();
            this.currentInternal.addCausalLinks();
            this.currentInternal.addOrderings();
            this.matrix.rebuild(this.currentInternal);
            if (this.solutionChecker.keepsConstraints(this.currentInternal, step).booleanValue()) {
                POPIncrementalPlan refinement = new POPIncrementalPlan(this.currentInternal, this.antecessors[this.antecessors.length - 1], this.parent);
                refinements.add(refinement);
                continue;
            }
            if (this.currentInternal.getThreats().size() > 0) {
                this.solveThreat(this.currentInternal, step.getIndex() == 1);
                continue;
            }
            if (this.currentInternal.getPreconditions().size() <= 0) continue;
            this.solveOpenCondition(this.currentInternal, step);
        }
        return refinements;
    }

    public void solveOpenCondition(POPInternalPlan father, POPStep newStep) {
        boolean isFinalStep;
        ArrayList<POPInternalPlan> suc = new ArrayList<POPInternalPlan>();
        boolean bl = isFinalStep = newStep.getIndex() == 1;
        if (father.numSteps() <= newStep.getIndex()) {
            POPOpenCondition prec = new POPOpenCondition(newStep.getPreconditions()[0], newStep, true);
            for (int i = 0; i < father.numSteps(); ++i) {
                POPStep step = (POPStep)father.getStep(i);
                POPAction act = step.getAction();
                if (step.getIndex() == 1) continue;
                for (POPPrecEff eff : act.getEffects()) {
                    if (eff.getVarCode() != prec.getCondition().getVarCode() || (prec.getCondition().getType() != 1 || eff.getValueCode() != prec.getCondition().getValueCode() || eff.getType() != 1) && (prec.getCondition().getType() != 2 || eff.getValueCode() == prec.getCondition().getValueCode())) continue;
                    POPInternalPlan successor = new POPInternalPlan(father, newStep, new POPCausalLink(step, prec.getPrecEff(), newStep), new POPOrdering(step.getIndex(), prec.getStep().getIndex()), father.getPreconditions(), null, prec, isFinalStep, this);
                    this.detectThreatsNewStep(newStep, step.getIndex(), father, successor);
                    this.detectThreatsLink(successor.getCausalLink(), father, successor);
                    suc.add(successor);
                }
            }
        } else {
            POPOpenCondition prec = (POPOpenCondition)father.getPreconditions().get(father.getPreconditions().size() - 1);
            father.getPreconditions().remove(father.getPreconditions().size() - 1);
            for (int i = 0; i < father.numSteps(); ++i) {
                POPStep step = (POPStep)father.getStep(i);
                POPAction act = step.getAction();
                if (step.getIndex() == prec.getStep().getIndex() || step.getIndex() == 1) continue;
                for (POPPrecEff eff : act.getEffects()) {
                    if (eff.getVarCode() != prec.getCondition().getVarCode() || (prec.getCondition().getType() != 1 || eff.getValueCode() != prec.getCondition().getValueCode() || eff.getType() != 1) && (prec.getCondition().getType() != 2 || eff.getValueCode() == prec.getCondition().getValueCode()) || this.matrix.checkOrdering(prec.getStep().getIndex(), step.getIndex())) continue;
                    POPStep st = (POPStep)father.getStep(prec.getStep().getIndex());
                    POPInternalPlan successor = new POPInternalPlan(father, null, new POPCausalLink(step, prec.getPrecEff(), st), new POPOrdering(step.getIndex(), prec.getStep().getIndex()), father.getPreconditions(), null, prec, isFinalStep, this);
                    if (!this.matrix.checkOrdering(step.getIndex(), prec.getStep().getIndex())) {
                        successor.setOrdering(step.getIndex(), prec.getStep().getIndex());
                    }
                    this.detectThreatsLink(successor.getCausalLink(), father, successor);
                    suc.add(successor);
                }
            }
            father.cleanPlan();
        }
        this.internalSearchTree.addSuccessors(suc);
    }

    @Override
    public void solveThreat(POPInternalPlan father, boolean isFinalStep) {
        POPInternalPlan successor1 = null;
        POPInternalPlan successor2 = null;
        POPThreat threat = father.getThreats().remove(father.getThreats().size() - 1);
        int index1 = threat.getCausalLink().getIndex1();
        int index2 = threat.getCausalLink().getIndex2();
        int indexThreat = threat.getThreateningStep();
        if (this.matrix.checkOrdering(indexThreat, index1) || this.matrix.checkOrdering(index2, indexThreat)) {
            this.internalSearchTree.addPlan(father);
        }
        if (index2 != 1 && !this.matrix.checkOrdering(indexThreat, index2) && !this.matrix.checkOrdering(index2, indexThreat)) {
            successor1 = new POPInternalPlan(father, null, null, null, father.getPreconditions(), father.getThreats(), null, isFinalStep, father.getPlanner());
            successor1.setOrdering(index2, indexThreat);
            this.internalSearchTree.addPlan(successor1);
        }
        if (index1 != 0 && !this.matrix.checkOrdering(index1, indexThreat) && !this.matrix.checkOrdering(indexThreat, index1)) {
            successor2 = new POPInternalPlan(father, null, null, null, father.getPreconditions(), father.getThreats(), null, isFinalStep, father.getPlanner());
            successor2.setOrdering(indexThreat, index1);
            this.internalSearchTree.addPlan(successor2);
        }
        if (successor1 != null || successor2 != null) {
            father.cleanPlan();
        }
    }

    public void detectThreatsLink(POPCausalLink link, POPInternalPlan father, POPInternalPlan successor) {
        ArrayList<POPThreat> threats = new ArrayList<POPThreat>();
        int type = link.getCondition().getType();
        int index1 = link.getIndex1();
        int index2 = link.getIndex2();
        for (int i = 2; i < father.numSteps(); ++i) {
            POPStep step = (POPStep)father.getStep(i);
            if (step == null) {
                father.setNumSteps(-1);
                father.numSteps();
                step = (POPStep)father.getStep(i);
            }
            if (index1 == i || index2 == i) continue;
            for (int j = 0; j < step.getAction().getEffects().size(); ++j) {
                Boolean order;
                if (type == 1 && step.getAction().getEffects().get(j).getVarCode() == link.getCondition().getVarCode() && step.getAction().getEffects().get(j).getValueCode() != link.getCondition().getValueCode()) {
                    order = i == 0 ? Boolean.valueOf(true) : Boolean.valueOf(this.matrix.checkOrdering(i, index1));
                    if (!order.booleanValue()) {
                        order = this.matrix.checkOrdering(index2, i);
                    }
                    if (!order.booleanValue()) {
                        threats.add(new POPThreat(step, link));
                    }
                }
                if (type != 2 || step.getAction().getEffects().get(j).getVarCode() != link.getCondition().getVarCode() || step.getAction().getEffects().get(j).getValueCode() != link.getCondition().getValueCode()) continue;
                order = i == 0 ? Boolean.valueOf(true) : Boolean.valueOf(this.matrix.checkOrdering(i, index1));
                if (!order.booleanValue()) {
                    order = this.matrix.checkOrdering(index2, i);
                }
                if (order.booleanValue()) continue;
                threats.add(new POPThreat(step, link));
            }
        }
        successor.addThreats(threats);
    }

    public void detectThreatsNewStep(POPStep step, int index, POPInternalPlan father, POPInternalPlan successor) {
        ArrayList<POPThreat> threats = new ArrayList<POPThreat>();
        int indexStep = step.getIndex();
        for (int i = 0; i < step.getAction().getEffects().size(); ++i) {
            for (int j = father.getTotalCausalLinks().size() - 1; j >= 0; --j) {
                Boolean order;
                POPCausalLink link = (POPCausalLink)father.getTotalCausalLinks().get(j);
                Condition precondition = link.getCondition();
                int index1 = link.getIndex1();
                int index2 = link.getIndex2();
                if (indexStep == index1 || indexStep == index2) continue;
                if (link.getCondition().getType() == 1) {
                    if (step.getAction().getEffects().get(i).getVarCode() != precondition.getVarCode() || step.getAction().getEffects().get(i).getValueCode() == precondition.getValueCode() || (order = Boolean.valueOf(this.matrix.checkOrdering(index2, index))).booleanValue()) continue;
                    threats.add(new POPThreat(step, link));
                    continue;
                }
                if (link.getCondition().getType() != 2 || step.getAction().getEffects().get(i).getVarCode() != precondition.getVarCode() || step.getAction().getEffects().get(i).getValueCode() != precondition.getValueCode() || (order = index1 == index ? Boolean.valueOf(true) : Boolean.valueOf(this.matrix.checkOrdering(index, index1))).booleanValue()) continue;
                threats.add(new POPThreat(step, link));
            }
        }
        successor.addThreats(threats);
    }

    public void setInitialStep(Step s) {
        this.initialStep = s;
    }

    public void setFinalStep(Step s) {
        this.finalStep = s;
    }

    public SolutionChecker getSolutionChecker() {
        return this.solutionChecker;
    }

    public POPIncrementalPlan getBasePlan() {
        return this.basePlan;
    }

    public int getNumOrderings() {
        return this.numOrderings;
    }

    private ArrayList<IPlan> addFinalStep() {
        POPStep st;
        this.hashEffects = null;
        POPInternalPlan auxInternal = this.currentInternal;
        this.initialInternalPlan.setNumSteps(-1);
        if (this.basePlan.getH() == 0 && this.isApplicable(this.currentInternal, (st = (POPStep)this.currentInternal.getFinalStep()).getAction()).booleanValue()) {
            ArrayList<IPlan> succ = this.solveAction(st);
            this.currentInternal = auxInternal;
            this.restoreCausalLinks();
            this.restoreOrderings();
            this.currentInternal.restorePlan(this.openConditions);
            if (succ.size() > 0) {
                return succ;
            }
        }
        return null;
    }

    public static class MessageFilterAdjustment
    implements MessageFilter {
        protected String fromAgent;

        @Override
        public boolean validMessage(Message m) {
            return m.sender().equals(this.fromAgent) && m.content() instanceof HeuristicAdjustment;
        }
    }

    public static class MessageFilterProposals
    implements MessageFilter {
        protected String fromAgent;

        @Override
        public boolean validMessage(Message m) {
            return m.sender().equals(this.fromAgent) && m.content() instanceof ArrayList;
        }
    }

    public class EvaluationThread
    extends Thread {
        IPlan plan;
        int threadIndex;

        EvaluationThread(IPlan plan, int threadIndex) {
            this.plan = plan;
            this.threadIndex = threadIndex;
        }

        @Override
        public void run() {
            Planner.this.heuristic.evaluatePlan(this.plan, this.threadIndex);
        }
    }
}

